/*
 * Decompiled with CFR 0.152.
 */
package com.willblaschko.android.alexa;

import android.content.Context;
import android.speech.tts.TextToSpeech;
import android.speech.tts.UtteranceProgressListener;
import com.willblaschko.android.alexa.AuthorizationManager;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class VoiceHelper {
    private static final String TAG = "VoiceHelper";
    private static VoiceHelper mInstance;
    private Context mContext;
    private TextToSpeech mTextToSpeech;
    private boolean mIsIntialized = false;
    Map<String, SpeechFromTextCallback> mCallbacks = new HashMap<String, SpeechFromTextCallback>();
    private TextToSpeech.OnInitListener mInitListener = new TextToSpeech.OnInitListener(){

        public void onInit(int status) {
            if (status == 0) {
                VoiceHelper.this.mIsIntialized = true;
            } else {
                new IllegalStateException("Unable to initialize Text to Speech engine").printStackTrace();
            }
        }
    };
    private UtteranceProgressListener mUtteranceProgressListener = new UtteranceProgressListener(){

        public void onStart(String utteranceId) {
        }

        public void onDone(String utteranceId) {
            SpeechFromTextCallback callback = VoiceHelper.this.mCallbacks.get(utteranceId);
            if (callback != null) {
                File cacheFile = VoiceHelper.this.getCacheFile(utteranceId);
                try {
                    byte[] data = FileUtils.readFileToByteArray((File)cacheFile);
                    callback.onSuccess(data);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    callback.onError(e);
                }
                cacheFile.delete();
                VoiceHelper.this.mCallbacks.remove(utteranceId);
            }
        }

        public void onError(String utteranceId) {
            this.onError(utteranceId, -1);
        }

        public void onError(String utteranceId, int errorCode) {
            super.onError(utteranceId, errorCode);
            SpeechFromTextCallback callback = VoiceHelper.this.mCallbacks.get(utteranceId);
            if (callback != null) {
                callback.onError(new Exception("Unable to process request, error code: " + errorCode));
            }
        }
    };

    private VoiceHelper(Context context) {
        this.mContext = context.getApplicationContext();
        this.mTextToSpeech = new TextToSpeech(this.mContext, this.mInitListener);
        this.mTextToSpeech.setPitch(0.8f);
        this.mTextToSpeech.setSpeechRate(1.5f);
        this.mTextToSpeech.setOnUtteranceProgressListener(this.mUtteranceProgressListener);
    }

    public static VoiceHelper getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new VoiceHelper(context);
        }
        return mInstance;
    }

    public void getSpeechFromText(String text, SpeechFromTextCallback callback) {
        String utteranceId = AuthorizationManager.createCodeVerifier();
        this.mCallbacks.put(utteranceId, callback);
        TextToSpeech textToSpeech = this.getTextToSpeech();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("utteranceId", utteranceId);
        textToSpeech.synthesizeToFile(text, params, this.getCacheFile(utteranceId).toString());
    }

    private TextToSpeech getTextToSpeech() {
        if (!this.mIsIntialized) {
            throw new IllegalStateException("Text to Speech engine is not initalized");
        }
        return this.mTextToSpeech;
    }

    private File getCacheFile(String utteranceId) {
        return new File(this.getCacheDir(), utteranceId + ".wav");
    }

    private File getCacheDir() {
        return this.mContext.getCacheDir();
    }

    public static interface SpeechFromTextCallback {
        public void onSuccess(byte[] var1);

        public void onError(Exception var1);
    }
}

