/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.content.Context;
import android.os.Bundle;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.endpoint.AbstractOauthTokenRequest;
import com.amazon.identity.auth.device.endpoint.OauthCodeForTokenResponse;
import com.amazon.identity.auth.device.endpoint.TokenResponse;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.message.BasicNameValuePair;

class OauthCodeForTokenRequest
extends AbstractOauthTokenRequest {
    private static final String LOG_TAG = OauthCodeForTokenRequest.class.getName();
    private final String mCode;
    private final String mRedirectUri;
    private final String mDirectedId;
    private final String mCodeVerifier;

    OauthCodeForTokenRequest(String appName, String appVersion, String libVersion, Bundle options, String code, String codeVerifier, String redirectUri, String directedId, AppInfo appInfo, Context context) throws AuthError {
        super(appName, appVersion, libVersion, context, options, appInfo);
        this.mCode = code;
        this.mRedirectUri = redirectUri;
        this.mDirectedId = directedId;
        this.mCodeVerifier = codeVerifier;
    }

    public String getGrantType() {
        return "authorization_code";
    }

    protected TokenResponse generateTokenResponse(HttpResponse httpResponse) {
        return new OauthCodeForTokenResponse(httpResponse, this.getAppFamilyId(), this.mDirectedId);
    }

    public HttpResponse executeRequest() throws ClientProtocolException, IOException {
        MAPLog.pii(LOG_TAG, "Oauth Code for Token Exchange executeRequest. redirectUri=" + this.mRedirectUri + " appId=" + this.getAppFamilyId(), "code=" + this.mCode);
        return super.executeRequest();
    }

    protected void addRequestInfoParameters() throws AuthError {
        super.addRequestInfoParameters();
        this.postParameters.add(new BasicNameValuePair("code", this.mCode));
        this.postParameters.add(new BasicNameValuePair("redirect_uri", this.mRedirectUri));
        this.postParameters.add(new BasicNameValuePair("code_verifier", this.mCodeVerifier));
    }
}

