/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.datastore;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.amazon.identity.auth.device.dataobject.AuthorizationToken;
import com.amazon.identity.auth.device.dataobject.AuthorizationTokenFactory;
import com.amazon.identity.auth.device.datastore.AbstractDataSource;
import com.amazon.identity.auth.device.datastore.DatabaseHelper;
import com.amazon.identity.auth.device.utils.MAPUtils;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.text.SimpleDateFormat;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AuthorizationTokenDataSource
extends AbstractDataSource<AuthorizationToken> {
    private static final String LOG_TAG = AuthorizationTokenDataSource.class.getName();
    private static final String[] ALL_COLUMNS = AuthorizationToken.ALL_COLUMNS;
    private static AuthorizationTokenDataSource INSTANCE;

    private AuthorizationTokenDataSource(SQLiteDatabase database) {
        super(database);
    }

    public static synchronized AuthorizationTokenDataSource getInstance(Context context) {
        if (INSTANCE == null) {
            INSTANCE = new AuthorizationTokenDataSource(MAPUtils.getMAPdatabase(context));
        }
        return INSTANCE;
    }

    public static void resetInstance() {
        INSTANCE = null;
        MAPUtils.resetDatabaseInstance();
    }

    public List<AuthorizationToken> findByAppFamilyId(String appFamilyId) {
        return this.findAllRowsBySingleColumn(ALL_COLUMNS[AuthorizationToken.COL_INDEX.APP_FAMILY_ID.colId], appFamilyId);
    }

    public AuthorizationToken findById(long id) {
        return (AuthorizationToken)this.findByRowId(id);
    }

    public AuthorizationToken findByPrimaryKey(long id) {
        return (AuthorizationToken)this.findByRowId(id);
    }

    public List<AuthorizationToken> findByDirectedId(String directedId) {
        return this.findAllRowsBySingleColumn(ALL_COLUMNS[AuthorizationToken.COL_INDEX.DIRECTED_ID.colId], directedId);
    }

    public int deleteByAppFamilyId(String appFamilyId) {
        return this.deleteRowsBySingleColumn(ALL_COLUMNS[AuthorizationToken.COL_INDEX.APP_FAMILY_ID.colId], appFamilyId);
    }

    public int deleteByDirectedId(String directedId) {
        return this.deleteRowsBySingleColumn(ALL_COLUMNS[AuthorizationToken.COL_INDEX.DIRECTED_ID.colId], directedId);
    }

    @Override
    public String getLogTag() {
        return LOG_TAG;
    }

    @Override
    public AuthorizationToken cursorToObject(Cursor cursor) {
        if (cursor == null || cursor.getCount() == 0) {
            return null;
        }
        SimpleDateFormat dateFormat = DatabaseHelper.getDateFormat();
        try {
            AuthorizationToken.AUTHZ_TOKEN_TYPE type = AuthorizationToken.AUTHZ_TOKEN_TYPE.values()[cursor.getInt(this.getColumnIndex(cursor, AuthorizationToken.COL_INDEX.TYPE.colId))];
            AuthorizationToken to_return = AuthorizationTokenFactory.getAuthorizationToken(type);
            to_return.setId(cursor.getLong(this.getColumnIndex(cursor, AuthorizationToken.COL_INDEX.ID.colId)));
            to_return.setAppFamilyId(cursor.getString(this.getColumnIndex(cursor, AuthorizationToken.COL_INDEX.APP_FAMILY_ID.colId)));
            to_return.setTokenValue(cursor.getString(this.getColumnIndex(cursor, AuthorizationToken.COL_INDEX.TOKEN.colId)));
            to_return.setCreationTime(dateFormat.parse(cursor.getString(this.getColumnIndex(cursor, AuthorizationToken.COL_INDEX.CREATION_TIME.colId))));
            to_return.setExpirationTime(dateFormat.parse(cursor.getString(this.getColumnIndex(cursor, AuthorizationToken.COL_INDEX.EXPIRATION_TIME.colId))));
            to_return.setMiscData(cursor.getBlob(this.getColumnIndex(cursor, AuthorizationToken.COL_INDEX.MISC_DATA.colId)));
            to_return.setDirectedId(cursor.getString(this.getColumnIndex(cursor, AuthorizationToken.COL_INDEX.DIRECTED_ID.colId)));
            return to_return;
        }
        catch (Exception e) {
            MAPLog.e(LOG_TAG, "" + e.getMessage(), e);
            return null;
        }
    }

    @Override
    public String getTableName() {
        return "AuthorizationToken";
    }

    @Override
    public String[] getAllColumns() {
        return ALL_COLUMNS;
    }
}

