/*
 * Decompiled with CFR 0.152.
 */
package com.whiteelephant.gifplayer;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Movie;
import android.os.Build;
import android.os.SystemClock;
import android.support.annotation.RawRes;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import com.whiteelephant.gifplayer.R;
import java.io.InputStream;

public class GifView
extends View {
    private static final String TAG = GifView.class.getName();
    private Movie _movie;
    private long _gifStartedTime = 0L;
    private int _currentAnimationTime = 0;
    float _animationMultiplier = 1.0f;
    int _repeatMode;
    int _gifID;
    private long _resumedAt;
    private int _state;
    private GifStartListener _gifStartListener;
    private GifStopListener _gifStopListener;
    private GifPauseListener _gifPauseListener;
    private GifResumeListener _gifResumeListener;
    private GifCompletionListener _gifCompletionListener;
    private float mScale;
    private int mMeasuredMovieWidth;
    private int mMeasuredMovieHeight;
    public static final int PLAY_ONCE = 100;
    public static final int PLAY_REPEAT = 101;
    private int DEFAULT_GIF_PLAY_MODE = 101;
    private int DEFAULT_GIF_SPEED = 1;

    public GifView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.GifView);
        if (a.hasValue(R.styleable.GifView_playMode)) {
            this.setPlayMode(a.getInt(R.styleable.GifView_playMode, this.DEFAULT_GIF_PLAY_MODE));
        }
        if (a.hasValue(R.styleable.GifView_animationSpeed)) {
            this.setAnimationSpeed(a.getFloat(R.styleable.GifView_animationSpeed, (float)this.DEFAULT_GIF_SPEED));
        }
        if (a.hasValue(R.styleable.GifView_src)) {
            int value = a.getResourceId(R.styleable.GifView_src, 17170459);
            this.setGIFResource(value);
        }
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
    }

    public void setGIFResource(@RawRes int gifID) {
        this._gifID = gifID;
    }

    public void setAnimationSpeed(float animationSpeed) {
        this._animationMultiplier = animationSpeed;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this._movie != null) {
            this.setMeasuredDimension(this._movie.width(), this._movie.height());
        } else {
            this.setMeasuredDimension(this.getSuggestedMinimumWidth(), this.getSuggestedMinimumHeight());
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this._movie != null) {
            this.updateGifPlayingTime();
            this.drawGif(canvas);
        } else {
            this.drawGif(canvas);
        }
    }

    private void updateGifPlayingTime() {
        int dur;
        long now = SystemClock.uptimeMillis();
        if (this._gifStartedTime == 0L) {
            this._gifStartedTime = now;
        }
        if ((dur = this._movie.duration()) == 0) {
            dur = 1000;
        }
        this._currentAnimationTime = this._state == 1 ? this._movie.duration() + 1000 : (this._state != 3 && this._state != 2 ? (int)((float)(SystemClock.uptimeMillis() - this._gifStartedTime) * this._animationMultiplier) : (int)((float)(this.getGifPlayingTime(this._resumedAt) - this._gifStartedTime) * this._animationMultiplier));
        if (this._repeatMode == 101 && this._state != 1) {
            this._currentAnimationTime %= dur;
        }
    }

    private void drawGif(Canvas canvas) {
        if (this._state == 1) {
            this.gifStopped();
            this._resumedAt = 0L;
            this._movie.setTime(this._currentAnimationTime);
            this._movie.draw(canvas, 0.0f, 0.0f);
        } else if (this._state == 2) {
            this.gifPaused();
            this._movie.setTime(this._currentAnimationTime);
            this._movie.draw(canvas, 0.0f, 0.0f);
        } else {
            this._movie.setTime(this._currentAnimationTime);
            this._movie.draw(canvas, 0.0f, 0.0f);
            if (this._currentAnimationTime < this._movie.duration()) {
                this.invalidate();
            } else {
                this.gifCompleted();
            }
        }
    }

    public void setPlayMode(int repeatMode) {
        this._repeatMode = repeatMode;
    }

    public void stop() {
        if (this._state == 1) {
            Log.d((String)TAG, (String)" Gif is already in Stop stage, you can't stop it again");
        } else {
            this._state = 1;
        }
        this.requestLayout();
        this.invalidate();
    }

    public void start() {
        this._state = 0;
        this._movie = Movie.decodeStream((InputStream)this.getResources().openRawResource(this._gifID));
        this._currentAnimationTime = 0;
        this._gifStartedTime = 0L;
        this.requestLayout();
        this.invalidate();
        this.gifStarted();
    }

    public void pause() {
        if (this._state == 2) {
            Log.i((String)TAG, (String)"Gif already in Pause state.");
        } else if (this._state == 1) {
            Log.i((String)TAG, (String)"Gif Stopped state. Pause not allowed on already stopeed Gif ");
        } else {
            if (this._state != 3) {
                this._resumedAt = SystemClock.uptimeMillis();
            }
            this._state = 2;
            this._currentAnimationTime = 0;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void resume() {
        if (this._state == 0) {
            Log.i((String)TAG, (String)"Gif in Start state. Resume not allowed on Started gif. ");
        } else if (this._state == 3) {
            Log.i((String)TAG, (String)"Gif already in Resume state.");
        } else if (this._state == 1) {
            Log.i((String)TAG, (String)"Gif in Stop state. Resume not allowed in Stopped gif. ");
        } else {
            this._state = 3;
            this.requestLayout();
            this.invalidate();
            this.gifResumed();
        }
    }

    public void gifStarted() {
        if (this._gifStartListener != null) {
            this._gifStartListener.onGifStarted();
        } else {
            Log.i((String)TAG, (String)"GifStarted but no listeners found. If you want to receive the call backs, Please set the handler before you call start method");
        }
    }

    public void gifStopped() {
        if (this._gifStopListener != null) {
            this._gifStopListener.onGifStopped();
        } else {
            Log.i((String)TAG, (String)"Gif Stopped but but no listeners found. If you want to receive thecall backs, Please set the handler before you call stop method");
        }
    }

    public void gifPaused() {
        if (this._gifPauseListener != null) {
            this._gifPauseListener.onGifPause();
        } else {
            Log.i((String)TAG, (String)"Gif Paused but but no listeners found. If you want to receive thecall backs, Please set the handler before you call pause method");
        }
    }

    public void gifResumed() {
        if (this._gifResumeListener != null) {
            this._gifResumeListener.onGifResume();
        } else {
            Log.i((String)TAG, (String)"Gif Resumed but but no listeners found. If you want to receive thecall backs, Please set the handler before you call resume method");
        }
    }

    public void gifCompleted() {
        if (this._gifCompletionListener != null) {
            this._gifCompletionListener.onGifCompletion();
        }
    }

    private long getGifPlayingTime(long hello) {
        int i = 10;
        if (this._state == 101) {
            i = (int)((float)i * this._animationMultiplier);
        }
        this._resumedAt = hello + (long)i;
        return this._resumedAt;
    }

    public void addOnStartListener(GifStartListener gifStartListener) {
        this._gifStartListener = gifStartListener;
    }

    public void addOnStopListener(GifStopListener gifStopListener) {
        this._gifStopListener = gifStopListener;
    }

    public void addOnPauseListener(GifPauseListener gifPauseListener) {
        this._gifPauseListener = gifPauseListener;
    }

    public void addOnResumeListener(GifResumeListener gifResumeListener) {
        this._gifResumeListener = gifResumeListener;
    }

    public void addOnCompletionListener(GifCompletionListener gifCompletionListener) {
        this._gifCompletionListener = gifCompletionListener;
    }

    public static interface GifCompletionListener {
        public void onGifCompletion();
    }

    public static interface GifResumeListener {
        public void onGifResume();
    }

    public static interface GifPauseListener {
        public void onGifPause();
    }

    public static interface GifStopListener {
        public void onGifStopped();
    }

    public static interface GifStartListener {
        public void onGifStarted();
    }
}

