/*
 * Decompiled with CFR 0.152.
 */
package com.white.progressview;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.ProgressBar;
import com.white.progressview.R;
import com.white.progressview.Utils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class HorizontalProgressView
extends ProgressBar {
    private static final String TAG = HorizontalProgressView.class.getSimpleName();
    public static final int TOP = 1;
    public static final int CENTRE = 0;
    public static final int BOTTOM = -1;
    private static final String STATE = "state";
    private static final String NORMAL_BAR_SIZE = "normal_bar_size";
    private static final String NORMAL_BAR_COLOR = "normal_bar_color";
    private static final String REACH_BAR_SIZE = "reach_bar_size";
    private static final String REACH_BAR_COLOR = "reach_bar_color";
    private static final String TEXT_COLOR = "text_color";
    private static final String TEXT_SIZE = "text_size";
    private static final String TEXT_SUFFIX = "text_suffix";
    private static final String TEXT_PREFIX = "text_prefix";
    private static final String TEXT_OFFSET = "text_offset";
    private static final String TEXT_POSITION = "text_position";
    private static final String TEXT_VISIBLE = "text_visible";
    private static final String TEXT_SKEW_X = "text_skew_x";
    private int mNormalBarSize = Utils.dp2px(this.getContext(), 2);
    private int mNormalBarColor = Color.parseColor((String)"#FFD3D6DA");
    private int mReachBarSize = Utils.dp2px(this.getContext(), 2);
    private int mReachBarColor = Color.parseColor((String)"#108ee9");
    private int mTextSize = Utils.sp2px(this.getContext(), 14);
    private int mTextColor = Color.parseColor((String)"#108ee9");
    private int mTextOffset = Utils.dp2px(this.getContext(), 6);
    private int mProgressPosition = 0;
    private boolean mTextVisible = true;
    private float mTextSkewX;
    private String mTextPrefix = "";
    private String mTextSuffix = "%";
    private Paint mTextPaint;
    private Paint mNormalPaint;
    private Paint mReachPaint;
    private int mDrawWidth;

    public HorizontalProgressView(Context context) {
        this(context, null);
    }

    public HorizontalProgressView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HorizontalProgressView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.obtainAttributes(attrs);
        this.initPaint();
    }

    protected void initPaint() {
        this.mTextPaint = new Paint();
        this.mTextPaint.setColor(this.mTextColor);
        this.mTextPaint.setStyle(Paint.Style.FILL);
        this.mTextPaint.setTextSize((float)this.mTextSize);
        this.mTextPaint.setTextSkewX(this.mTextSkewX);
        this.mTextPaint.setAntiAlias(true);
        this.mNormalPaint = new Paint();
        this.mNormalPaint.setColor(this.mNormalBarColor);
        this.mNormalPaint.setStyle(Paint.Style.FILL);
        this.mNormalPaint.setAntiAlias(true);
        this.mNormalPaint.setStrokeWidth((float)this.mNormalBarSize);
        this.mReachPaint = new Paint();
        this.mReachPaint.setColor(this.mReachBarColor);
        this.mReachPaint.setStyle(Paint.Style.FILL);
        this.mReachPaint.setAntiAlias(true);
        this.mReachPaint.setStrokeWidth((float)this.mReachBarSize);
    }

    protected void obtainAttributes(AttributeSet attrs) {
        TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.HorizontalProgressView);
        this.mNormalBarSize = (int)ta.getDimension(R.styleable.HorizontalProgressView_progressNormalSize, (float)this.mNormalBarSize);
        this.mNormalBarColor = ta.getColor(R.styleable.HorizontalProgressView_progressNormalColor, this.mNormalBarColor);
        this.mReachBarSize = (int)ta.getDimension(R.styleable.HorizontalProgressView_progressReachSize, (float)this.mReachBarSize);
        this.mReachBarColor = ta.getColor(R.styleable.HorizontalProgressView_progressReachColor, this.mReachBarColor);
        this.mTextSize = (int)ta.getDimension(R.styleable.HorizontalProgressView_progressTextSize, (float)this.mTextSize);
        this.mTextColor = ta.getColor(R.styleable.HorizontalProgressView_progressTextColor, this.mTextColor);
        this.mTextSkewX = ta.getDimension(R.styleable.HorizontalProgressView_progressTextSkewX, 0.0f);
        if (ta.hasValue(R.styleable.HorizontalProgressView_progressTextSuffix)) {
            this.mTextSuffix = ta.getString(R.styleable.HorizontalProgressView_progressTextSuffix);
        }
        if (ta.hasValue(R.styleable.HorizontalProgressView_progressTextPrefix)) {
            this.mTextPrefix = ta.getString(R.styleable.HorizontalProgressView_progressTextPrefix);
        }
        this.mTextOffset = (int)ta.getDimension(R.styleable.HorizontalProgressView_progressTextOffset, (float)this.mTextOffset);
        this.mProgressPosition = ta.getInt(R.styleable.HorizontalProgressView_progressTextPosition, this.mProgressPosition);
        this.mTextVisible = ta.getBoolean(R.styleable.HorizontalProgressView_progressTextVisible, this.mTextVisible);
        ta.recycle();
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int textHeight = (int)(this.mTextPaint.descent() - this.mTextPaint.ascent());
        int heightSize = Math.max(Math.max(this.mNormalBarSize, this.mReachBarSize), Math.abs(textHeight * 2)) + this.getPaddingTop() + this.getPaddingBottom();
        heightSize = HorizontalProgressView.resolveSize((int)heightSize, (int)heightMeasureSpec);
        this.setMeasuredDimension(widthSize, heightSize);
        this.mDrawWidth = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    protected synchronized void onDraw(Canvas canvas) {
        canvas.save();
        this.drawHorizontalProgressView(canvas);
        canvas.restore();
    }

    private void drawHorizontalProgressView(Canvas canvas) {
        float endX;
        canvas.translate((float)this.getPaddingLeft(), (float)(this.getHeight() / 2));
        boolean needDrawUnReachArea = true;
        float textWidth = 0.0f;
        String text = this.mTextPrefix + this.getProgress() + this.mTextSuffix;
        if (this.mTextVisible) {
            textWidth = this.mTextPaint.measureText(text);
        } else {
            this.mTextOffset = 0;
        }
        float textHeight = (this.mTextPaint.descent() + this.mTextPaint.ascent()) / 2.0f;
        float radio = (float)this.getProgress() * 1.0f / (float)this.getMax();
        float progressPosX = (float)((int)((float)this.mDrawWidth - textWidth)) * radio;
        if (progressPosX + textWidth >= (float)this.mDrawWidth) {
            progressPosX = (float)this.mDrawWidth - textWidth;
            needDrawUnReachArea = false;
        }
        if ((endX = progressPosX - (float)(this.mTextOffset / 2)) > 0.0f) {
            canvas.drawLine(0.0f, 0.0f, endX, 0.0f, this.mReachPaint);
        }
        if (needDrawUnReachArea) {
            float start = progressPosX + (float)(this.mTextOffset / 2) + textWidth;
            canvas.drawLine(start, 0.0f, (float)this.mDrawWidth, 0.0f, this.mNormalPaint);
        }
        if (!this.mTextVisible) {
            return;
        }
        switch (this.mProgressPosition) {
            case -1: {
                canvas.drawText(text, progressPosX, -textHeight * 2.0f + (float)this.mTextOffset, this.mTextPaint);
                break;
            }
            case 1: {
                canvas.drawText(text, progressPosX, (float)(0 - this.mTextOffset), this.mTextPaint);
                break;
            }
            default: {
                canvas.drawText(text, progressPosX, -textHeight, this.mTextPaint);
            }
        }
    }

    public int getNormalBarSize() {
        return this.mNormalBarSize;
    }

    public void setNormalBarSize(int normalBarSize) {
        this.mNormalBarSize = Utils.dp2px(this.getContext(), normalBarSize);
        this.invalidate();
    }

    public int getNormalBarColor() {
        return this.mNormalBarColor;
    }

    public void setNormalBarColor(int normalBarColor) {
        this.mNormalBarColor = normalBarColor;
        this.invalidate();
    }

    public int getReachBarSize() {
        return this.mReachBarSize;
    }

    public void setReachBarSize(int reachBarSize) {
        this.mReachBarSize = Utils.dp2px(this.getContext(), reachBarSize);
        this.invalidate();
    }

    public int getReachBarColor() {
        return this.mReachBarColor;
    }

    public void setReachBarColor(int reachBarColor) {
        this.mReachBarColor = reachBarColor;
        this.invalidate();
    }

    public int getTextSize() {
        return this.mTextSize;
    }

    public void setTextSize(int textSize) {
        this.mTextSize = Utils.sp2px(this.getContext(), textSize);
        this.invalidate();
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public void setTextColor(int textColor) {
        this.mTextColor = textColor;
        this.invalidate();
    }

    public int getTextOffset() {
        return this.mTextOffset;
    }

    public void setTextOffset(int textOffset) {
        this.mTextOffset = Utils.dp2px(this.getContext(), textOffset);
        this.invalidate();
    }

    public int getProgressPosition() {
        return this.mProgressPosition;
    }

    public void setProgressPosition(int progressPosition) {
        this.mProgressPosition = progressPosition > 1 || progressPosition < -1 ? 0 : progressPosition;
        this.invalidate();
    }

    public boolean isTextVisible() {
        return this.mTextVisible;
    }

    public void setTextVisible(boolean textVisible) {
        this.mTextVisible = textVisible;
        this.invalidate();
    }

    public float getTextSkewX() {
        return this.mTextSkewX;
    }

    public void setTextSkewX(float textSkewX) {
        this.mTextSkewX = textSkewX;
        this.invalidate();
    }

    public String getTextPrefix() {
        return this.mTextPrefix;
    }

    public void setTextPrefix(String textPrefix) {
        this.mTextPrefix = textPrefix;
        this.invalidate();
    }

    public String getTextSuffix() {
        return this.mTextSuffix;
    }

    public void setTextSuffix(String textSuffix) {
        this.mTextSuffix = textSuffix;
        this.invalidate();
    }

    public void runProgressAnim(long duration) {
        this.setProgressInTime(0, duration);
    }

    public void setProgressInTime(int progress, long duration) {
        this.setProgressInTime(progress, this.getProgress(), duration);
    }

    public void setProgressInTime(int startProgress, int progress, long duration) {
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{startProgress, progress});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                int currentValue = (Integer)animator.getAnimatedValue();
                HorizontalProgressView.this.setProgress(currentValue);
            }
        });
        AccelerateDecelerateInterpolator interpolator = new AccelerateDecelerateInterpolator();
        valueAnimator.setInterpolator((TimeInterpolator)interpolator);
        valueAnimator.setDuration(duration);
        valueAnimator.start();
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(STATE, super.onSaveInstanceState());
        bundle.putInt(TEXT_COLOR, this.getTextColor());
        bundle.putInt(TEXT_SIZE, this.getTextSize());
        bundle.putInt(TEXT_OFFSET, this.getTextOffset());
        bundle.putInt(TEXT_POSITION, this.getProgressPosition());
        bundle.putFloat(TEXT_SKEW_X, this.getTextSkewX());
        bundle.putBoolean(TEXT_VISIBLE, this.isTextVisible());
        bundle.putString(TEXT_SUFFIX, this.getTextSuffix());
        bundle.putString(TEXT_PREFIX, this.getTextPrefix());
        bundle.putInt(REACH_BAR_COLOR, this.getReachBarColor());
        bundle.putInt(REACH_BAR_SIZE, this.getReachBarSize());
        bundle.putInt(NORMAL_BAR_COLOR, this.getNormalBarColor());
        bundle.putInt(NORMAL_BAR_SIZE, this.getNormalBarSize());
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mTextColor = bundle.getInt(TEXT_COLOR);
            this.mTextSize = bundle.getInt(TEXT_SIZE);
            this.mTextOffset = bundle.getInt(TEXT_OFFSET);
            this.mProgressPosition = bundle.getInt(TEXT_POSITION);
            this.mTextSkewX = bundle.getFloat(TEXT_SKEW_X);
            this.mTextVisible = bundle.getBoolean(TEXT_VISIBLE);
            this.mTextSuffix = bundle.getString(TEXT_SUFFIX);
            this.mTextPrefix = bundle.getString(TEXT_PREFIX);
            this.mReachBarColor = bundle.getInt(REACH_BAR_COLOR);
            this.mReachBarSize = bundle.getInt(REACH_BAR_SIZE);
            this.mNormalBarColor = bundle.getInt(NORMAL_BAR_COLOR);
            this.mNormalBarSize = bundle.getInt(NORMAL_BAR_SIZE);
            this.initPaint();
            super.onRestoreInstanceState(bundle.getParcelable(STATE));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    public void invalidate() {
        this.initPaint();
        super.invalidate();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Position {
    }
}

