/*
 * Decompiled with CFR 0.152.
 */
package com.white.progressview;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.ProgressBar;
import com.white.progressview.R;
import com.white.progressview.Utils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class CircleProgressView
extends ProgressBar {
    private static final int PROGRESS_STYLE_NORMAL = 0;
    private static final int PROGRESS_STYLE_FILL_IN = 1;
    private static final int PROGRESS_STYLE_FILL_IN_ARC = 2;
    private static final int PROGRESS_STYLE_WAVE = 3;
    private int mReachBarSize = Utils.dp2px(this.getContext(), 2);
    private int mNormalBarSize = Utils.dp2px(this.getContext(), 2);
    private int mReachBarColor = Color.parseColor((String)"#108ee9");
    private int mNormalBarColor = Color.parseColor((String)"#FFD3D6DA");
    private int mTextSize = Utils.sp2px(this.getContext(), 14);
    private int mTextColor = Color.parseColor((String)"#108ee9");
    private float mTextSkewX;
    private String mTextSuffix = "%";
    private String mTextPrefix = "";
    private boolean mTextVisible = true;
    private boolean mReachCapRound;
    private int mRadius = Utils.dp2px(this.getContext(), 20);
    private int mStartArc;
    private int mInnerBackgroundColor;
    private int mProgressStyle = 0;
    private int mInnerPadding = Utils.dp2px(this.getContext(), 1);
    private int mOuterColor;
    private boolean needDrawInnerBackground;
    private RectF rectF;
    private RectF rectInner;
    private int mOuterSize = Utils.dp2px(this.getContext(), 1);
    private Paint mTextPaint;
    private Paint mNormalPaint;
    private Paint mReachPaint;
    private Paint mInnerBackgroundPaint;
    private Paint mOutPaint;
    private int mRealWidth;
    private int mRealHeight;

    public CircleProgressView(Context context) {
        this(context, null);
    }

    public CircleProgressView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleProgressView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.obtainAttributes(attrs);
        this.initPaint();
    }

    private void initPaint() {
        this.mTextPaint = new Paint();
        this.mTextPaint.setColor(this.mTextColor);
        this.mTextPaint.setStyle(Paint.Style.FILL);
        this.mTextPaint.setTextSize((float)this.mTextSize);
        this.mTextPaint.setTextSkewX(this.mTextSkewX);
        this.mTextPaint.setAntiAlias(true);
        this.mNormalPaint = new Paint();
        this.mNormalPaint.setColor(this.mNormalBarColor);
        this.mNormalPaint.setStyle(this.mProgressStyle == 2 ? Paint.Style.FILL : Paint.Style.STROKE);
        this.mNormalPaint.setAntiAlias(true);
        this.mNormalPaint.setStrokeWidth((float)this.mNormalBarSize);
        this.mReachPaint = new Paint();
        this.mReachPaint.setColor(this.mReachBarColor);
        this.mReachPaint.setStyle(this.mProgressStyle == 2 ? Paint.Style.FILL : Paint.Style.STROKE);
        this.mReachPaint.setAntiAlias(true);
        this.mReachPaint.setStrokeCap(this.mReachCapRound ? Paint.Cap.ROUND : Paint.Cap.BUTT);
        this.mReachPaint.setStrokeWidth((float)this.mReachBarSize);
        if (this.needDrawInnerBackground) {
            this.mInnerBackgroundPaint = new Paint();
            this.mInnerBackgroundPaint.setStyle(Paint.Style.FILL);
            this.mInnerBackgroundPaint.setAntiAlias(true);
            this.mInnerBackgroundPaint.setColor(this.mInnerBackgroundColor);
        }
        if (this.mProgressStyle == 2) {
            this.mOutPaint = new Paint();
            this.mOutPaint.setStyle(Paint.Style.STROKE);
            this.mOutPaint.setColor(this.mOuterColor);
            this.mOutPaint.setStrokeWidth((float)this.mOuterSize);
            this.mOutPaint.setAntiAlias(true);
        }
    }

    private void obtainAttributes(AttributeSet attrs) {
        TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.CircleProgressView);
        this.mProgressStyle = ta.getInt(R.styleable.CircleProgressView_progressStyle, 0);
        this.mNormalBarSize = (int)ta.getDimension(R.styleable.CircleProgressView_progressNormalSize, (float)this.mNormalBarSize);
        this.mNormalBarColor = ta.getColor(R.styleable.CircleProgressView_progressNormalColor, this.mNormalBarColor);
        this.mReachBarSize = (int)ta.getDimension(R.styleable.CircleProgressView_progressReachSize, (float)this.mReachBarSize);
        this.mReachBarColor = ta.getColor(R.styleable.CircleProgressView_progressReachColor, this.mReachBarColor);
        this.mTextSize = (int)ta.getDimension(R.styleable.CircleProgressView_progressTextSize, (float)this.mTextSize);
        this.mTextColor = ta.getColor(R.styleable.CircleProgressView_progressTextColor, this.mTextColor);
        this.mTextSkewX = ta.getDimension(R.styleable.CircleProgressView_progressTextSkewX, 0.0f);
        if (ta.hasValue(R.styleable.CircleProgressView_progressTextSuffix)) {
            this.mTextSuffix = ta.getString(R.styleable.CircleProgressView_progressTextSuffix);
        }
        if (ta.hasValue(R.styleable.CircleProgressView_progressTextPrefix)) {
            this.mTextPrefix = ta.getString(R.styleable.CircleProgressView_progressTextPrefix);
        }
        this.mTextVisible = ta.getBoolean(R.styleable.CircleProgressView_progressTextVisible, this.mTextVisible);
        this.mRadius = (int)ta.getDimension(R.styleable.CircleProgressView_radius, (float)this.mRadius);
        this.rectF = new RectF((float)(-this.mRadius), (float)(-this.mRadius), (float)this.mRadius, (float)this.mRadius);
        switch (this.mProgressStyle) {
            case 1: {
                this.mReachBarSize = 0;
                this.mNormalBarSize = 0;
                this.mOuterSize = 0;
                break;
            }
            case 2: {
                this.mStartArc = ta.getInt(R.styleable.CircleProgressView_progressStartArc, 0) + 270;
                this.mInnerPadding = (int)ta.getDimension(R.styleable.CircleProgressView_innerPadding, (float)this.mInnerPadding);
                this.mOuterColor = ta.getColor(R.styleable.CircleProgressView_outerColor, this.mReachBarColor);
                this.mOuterSize = (int)ta.getDimension(R.styleable.CircleProgressView_outerSize, (float)this.mOuterSize);
                this.mReachBarSize = 0;
                this.mNormalBarSize = 0;
                if (!ta.hasValue(R.styleable.CircleProgressView_progressNormalColor)) {
                    this.mNormalBarColor = 0;
                }
                int mInnerRadius = this.mRadius - this.mOuterSize / 2 - this.mInnerPadding;
                this.rectInner = new RectF((float)(-mInnerRadius), (float)(-mInnerRadius), (float)mInnerRadius, (float)mInnerRadius);
                break;
            }
            case 0: {
                this.mReachCapRound = ta.getBoolean(R.styleable.CircleProgressView_reachCapRound, true);
                this.mStartArc = ta.getInt(R.styleable.CircleProgressView_progressStartArc, 0) + 270;
                if (!ta.hasValue(R.styleable.CircleProgressView_innerBackgroundColor)) break;
                this.mInnerBackgroundColor = ta.getColor(R.styleable.CircleProgressView_innerBackgroundColor, Color.argb((int)0, (int)0, (int)0, (int)0));
                this.needDrawInnerBackground = true;
            }
        }
        ta.recycle();
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int maxBarPaintWidth = Math.max(this.mReachBarSize, this.mNormalBarSize);
        int maxPaintWidth = Math.max(maxBarPaintWidth, this.mOuterSize);
        int height = 0;
        int width = 0;
        switch (this.mProgressStyle) {
            case 1: {
                height = this.getPaddingTop() + this.getPaddingBottom() + Math.abs(this.mRadius * 2);
                width = this.getPaddingLeft() + this.getPaddingRight() + Math.abs(this.mRadius * 2);
                break;
            }
            case 2: {
                height = this.getPaddingTop() + this.getPaddingBottom() + Math.abs(this.mRadius * 2) + maxPaintWidth;
                width = this.getPaddingLeft() + this.getPaddingRight() + Math.abs(this.mRadius * 2) + maxPaintWidth;
                break;
            }
            case 0: {
                height = this.getPaddingTop() + this.getPaddingBottom() + Math.abs(this.mRadius * 2) + maxBarPaintWidth;
                width = this.getPaddingLeft() + this.getPaddingRight() + Math.abs(this.mRadius * 2) + maxBarPaintWidth;
            }
        }
        this.mRealWidth = CircleProgressView.resolveSize((int)width, (int)widthMeasureSpec);
        this.mRealHeight = CircleProgressView.resolveSize((int)height, (int)heightMeasureSpec);
        this.setMeasuredDimension(this.mRealWidth, this.mRealHeight);
    }

    protected synchronized void onDraw(Canvas canvas) {
        switch (this.mProgressStyle) {
            case 0: {
                this.drawNormalCircle(canvas);
                break;
            }
            case 1: {
                this.drawFillInCircle(canvas);
                break;
            }
            case 2: {
                this.drawFillInArcCircle(canvas);
            }
        }
    }

    private void drawFillInArcCircle(Canvas canvas) {
        canvas.save();
        canvas.translate((float)(this.mRealWidth / 2), (float)(this.mRealHeight / 2));
        canvas.drawArc(this.rectF, 0.0f, 360.0f, false, this.mOutPaint);
        float reachArc = (float)this.getProgress() * 1.0f / (float)this.getMax() * 360.0f;
        canvas.drawArc(this.rectInner, (float)this.mStartArc, reachArc, true, this.mReachPaint);
        if (reachArc != 360.0f) {
            canvas.drawArc(this.rectInner, reachArc + (float)this.mStartArc, 360.0f - reachArc, true, this.mNormalPaint);
        }
        canvas.restore();
    }

    private void drawFillInCircle(Canvas canvas) {
        canvas.save();
        canvas.translate((float)(this.mRealWidth / 2), (float)(this.mRealHeight / 2));
        float progressY = (float)this.getProgress() * 1.0f / (float)this.getMax() * (float)(this.mRadius * 2);
        float angle = (float)(Math.acos(((float)this.mRadius - progressY) / (float)this.mRadius) * 180.0 / Math.PI);
        float startAngle = 90.0f + angle;
        float sweepAngle = 360.0f - angle * 2.0f;
        this.rectF = new RectF((float)(-this.mRadius), (float)(-this.mRadius), (float)this.mRadius, (float)this.mRadius);
        this.mNormalPaint.setStyle(Paint.Style.FILL);
        canvas.drawArc(this.rectF, startAngle, sweepAngle, false, this.mNormalPaint);
        canvas.rotate(180.0f);
        this.mReachPaint.setStyle(Paint.Style.FILL);
        canvas.drawArc(this.rectF, 270.0f - angle, angle * 2.0f, false, this.mReachPaint);
        canvas.rotate(180.0f);
        if (this.mTextVisible) {
            String text = this.mTextPrefix + this.getProgress() + this.mTextSuffix;
            float textWidth = this.mTextPaint.measureText(text);
            float textHeight = this.mTextPaint.descent() + this.mTextPaint.ascent();
            canvas.drawText(text, -textWidth / 2.0f, -textHeight / 2.0f, this.mTextPaint);
        }
    }

    private void drawNormalCircle(Canvas canvas) {
        float reachArc;
        canvas.save();
        canvas.translate((float)(this.mRealWidth / 2), (float)(this.mRealHeight / 2));
        if (this.needDrawInnerBackground) {
            canvas.drawCircle(0.0f, 0.0f, (float)(this.mRadius - Math.min(this.mReachBarSize, this.mNormalBarSize) / 2), this.mInnerBackgroundPaint);
        }
        if (this.mTextVisible) {
            String text = this.mTextPrefix + this.getProgress() + this.mTextSuffix;
            float textWidth = this.mTextPaint.measureText(text);
            float textHeight = this.mTextPaint.descent() + this.mTextPaint.ascent();
            canvas.drawText(text, -textWidth / 2.0f, -textHeight / 2.0f, this.mTextPaint);
        }
        if ((reachArc = (float)this.getProgress() * 1.0f / (float)this.getMax() * 360.0f) != 360.0f) {
            canvas.drawArc(this.rectF, reachArc + (float)this.mStartArc, 360.0f - reachArc, false, this.mNormalPaint);
        }
        canvas.drawArc(this.rectF, (float)this.mStartArc, reachArc, false, this.mReachPaint);
        canvas.restore();
    }

    public void runProgressAnim(long duration) {
        this.setProgressInTime(0, duration);
    }

    public void setProgressInTime(int progress, long duration) {
        this.setProgressInTime(progress, this.getProgress(), duration);
    }

    public void setProgressInTime(int startProgress, int progress, long duration) {
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{startProgress, progress});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                int currentValue = (Integer)animator.getAnimatedValue();
                CircleProgressView.this.setProgress(currentValue);
            }
        });
        AccelerateDecelerateInterpolator interpolator = new AccelerateDecelerateInterpolator();
        valueAnimator.setInterpolator((TimeInterpolator)interpolator);
        valueAnimator.setDuration(duration);
        valueAnimator.start();
    }

    public int getReachBarSize() {
        return this.mReachBarSize;
    }

    public void setReachBarSize(int reachBarSize) {
        this.mReachBarSize = Utils.dp2px(this.getContext(), reachBarSize);
        this.invalidate();
    }

    public int getNormalBarSize() {
        return this.mNormalBarSize;
    }

    public void setNormalBarSize(int normalBarSize) {
        this.mNormalBarSize = Utils.dp2px(this.getContext(), normalBarSize);
        this.invalidate();
    }

    public int getReachBarColor() {
        return this.mReachBarColor;
    }

    public void setReachBarColor(int reachBarColor) {
        this.mReachBarColor = reachBarColor;
        this.invalidate();
    }

    public int getNormalBarColor() {
        return this.mNormalBarColor;
    }

    public void setNormalBarColor(int normalBarColor) {
        this.mNormalBarColor = normalBarColor;
        this.invalidate();
    }

    public int getTextSize() {
        return this.mTextSize;
    }

    public void setTextSize(int textSize) {
        this.mTextSize = Utils.sp2px(this.getContext(), textSize);
        this.invalidate();
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public void setTextColor(int textColor) {
        this.mTextColor = textColor;
        this.invalidate();
    }

    public float getTextSkewX() {
        return this.mTextSkewX;
    }

    public void setTextSkewX(float textSkewX) {
        this.mTextSkewX = textSkewX;
        this.invalidate();
    }

    public String getTextSuffix() {
        return this.mTextSuffix;
    }

    public void setTextSuffix(String textSuffix) {
        this.mTextSuffix = textSuffix;
        this.invalidate();
    }

    public String getTextPrefix() {
        return this.mTextPrefix;
    }

    public void setTextPrefix(String textPrefix) {
        this.mTextPrefix = textPrefix;
        this.invalidate();
    }

    public boolean isTextVisible() {
        return this.mTextVisible;
    }

    public void setTextVisible(boolean textVisible) {
        this.mTextVisible = textVisible;
        this.invalidate();
    }

    public boolean isReachCapRound() {
        return this.mReachCapRound;
    }

    public void setReachCapRound(boolean reachCapRound) {
        this.mReachCapRound = reachCapRound;
        this.invalidate();
    }

    public int getRadius() {
        return this.mRadius;
    }

    public void setRadius(int radius) {
        this.mRadius = Utils.dp2px(this.getContext(), radius);
        this.invalidate();
    }

    public int getStartArc() {
        return this.mStartArc;
    }

    public void setStartArc(int startArc) {
        this.mStartArc = startArc;
        this.invalidate();
    }

    public int getInnerBackgroundColor() {
        return this.mInnerBackgroundColor;
    }

    public void setInnerBackgroundColor(int innerBackgroundColor) {
        this.mInnerBackgroundColor = innerBackgroundColor;
        this.invalidate();
    }

    public int getProgressStyle() {
        return this.mProgressStyle;
    }

    public void setProgressStyle(int progressStyle) {
        this.mProgressStyle = progressStyle;
        this.invalidate();
    }

    public int getInnerPadding() {
        return this.mInnerPadding;
    }

    public void setInnerPadding(int innerPadding) {
        this.mInnerPadding = Utils.dp2px(this.getContext(), innerPadding);
        this.invalidate();
    }

    public int getOuterColor() {
        return this.mOuterColor;
    }

    public void setOuterColor(int outerColor) {
        this.mOuterColor = outerColor;
        this.invalidate();
    }

    public int getOuterSize() {
        return this.mOuterSize;
    }

    public void setOuterSize(int outerSize) {
        this.mOuterSize = Utils.dp2px(this.getContext(), outerSize);
        this.invalidate();
    }

    public void invalidate() {
        this.initPaint();
        super.invalidate();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProgressStyle {
    }
}

