/*
 * Decompiled with CFR 0.152.
 */
package com.whirlycott.cache.policy;

import com.whirlycott.cache.CacheConfiguration;
import com.whirlycott.cache.CacheMaintenancePolicy;
import com.whirlycott.cache.ManagedCache;
import com.whirlycott.cache.Messages;
import com.whirlycott.cache.policy.UsedComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LRUMaintenancePolicy
implements CacheMaintenancePolicy {
    private static final Log log = LogFactory.getLog(LRUMaintenancePolicy.class);
    protected ManagedCache managedCache = null;
    protected int maxSize;

    public void performMaintenance() {
        log.debug((Object)Messages.getString("LRUMaintenancePolicy.performing_lru_maintenance"));
        Object[] args = new Object[]{new Integer(this.maxSize), new Integer(this.managedCache.size())};
        log.debug((Object)Messages.getCompoundString("CacheMaintenancePolicy.report_items", args));
        ArrayList entries = new ArrayList(this.managedCache.entrySet());
        int currentSize = this.managedCache.size();
        if (this.maxSize < currentSize) {
            Object[] args1 = new Object[]{new Integer(currentSize - this.maxSize)};
            log.debug((Object)Messages.getCompoundString("CacheMaintenancePolicy.clearing_approximately", args1));
            Collections.sort(entries, new UsedComparator());
            List removeThese = entries.subList(0, currentSize - this.maxSize);
            for (Map.Entry entry : removeThese) {
                if (entry == null) continue;
                this.managedCache.remove(entry.getKey());
            }
            log.debug((Object)(Messages.getString("LRUMaintenancePolicy.new_size") + this.managedCache.size()));
        }
    }

    public void setCache(ManagedCache _cache) {
        this.managedCache = _cache;
    }

    public void setConfiguration(CacheConfiguration _configuration) {
        this.maxSize = _configuration.getMaxSize();
    }
}

