/*
 * Decompiled with CFR 0.152.
 */
package com.whirlycott.cache.policy;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import com.whirlycott.cache.CacheConfiguration;
import com.whirlycott.cache.CacheMaintenancePolicy;
import com.whirlycott.cache.ManagedCache;
import com.whirlycott.cache.Messages;
import com.whirlycott.cache.policy.CountComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LFUMaintenancePolicy
implements CacheMaintenancePolicy {
    private static final Log log = LogFactory.getLog(LFUMaintenancePolicy.class);
    protected ManagedCache managedCache = null;
    protected int maxSize;

    public void performMaintenance() {
        int currentSize;
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getString("LFUMaintenancePolicy.performing_lfu_maintenance"));
            Object[] args = new Object[]{new Integer(this.maxSize), new Integer(this.managedCache.size())};
            log.debug((Object)Messages.getCompoundString("CacheMaintenancePolicy.report_items", args));
        }
        if (this.maxSize < (currentSize = this.managedCache.size())) {
            if (log.isDebugEnabled()) {
                Object[] args1 = new Object[]{new Integer(currentSize - this.maxSize)};
                log.debug((Object)Messages.getCompoundString("CacheMaintenancePolicy.clearing_approximately", args1));
            }
            ArrayList entries = new ArrayList(new ConcurrentHashMap((Map)this.managedCache).entrySet());
            Collections.sort(entries, new CountComparator());
            List removeThese = entries.subList(0, currentSize - this.maxSize);
            for (Map.Entry entry : removeThese) {
                if (entry == null) continue;
                this.managedCache.remove(entry.getKey());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(Messages.getString("LFUMaintenancePolicy.new_size") + this.managedCache.size()));
            }
        }
    }

    public void setCache(ManagedCache _cache) {
        this.managedCache = _cache;
    }

    public void setConfiguration(CacheConfiguration _configuration) {
        this.maxSize = _configuration.getMaxSize();
    }
}

