/*
 * Decompiled with CFR 0.152.
 */
package com.whirlycott.cache.policy;

import com.whirlycott.cache.Item;
import java.util.Map;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExpirationTimePredicate
implements Predicate {
    private static final Log log = LogFactory.getLog(ExpirationTimePredicate.class);
    private final long currentTime;

    public ExpirationTimePredicate(long currentTime) {
        this.currentTime = currentTime;
    }

    public boolean evaluate(Object obj) {
        Item item;
        boolean retval = false;
        if (obj instanceof Map.Entry && ((Map.Entry)obj).getValue() instanceof Item && (item = (Item)((Map.Entry)obj).getValue()).getExpiresAfter() > 0L) {
            retval = item.getExpiresAfter() + item.getAdded() < this.currentTime;
        }
        return retval;
    }
}

