/*
 * Decompiled with CFR 0.152.
 */
package com.whirlycott.cache.hibernate;

import com.whirlycott.cache.Cache;
import com.whirlycott.cache.CacheException;
import com.whirlycott.cache.CacheManager;
import com.whirlycott.cache.Messages;
import net.sf.hibernate.cache.Timestamper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WhirlycachePlugin
implements net.sf.hibernate.cache.Cache {
    private static final Log log = LogFactory.getLog(WhirlycachePlugin.class);
    private static final int MS_PER_MINUTE = 60000;
    private Cache cache;
    private final String cacheName;

    public WhirlycachePlugin(String _name) throws net.sf.hibernate.cache.CacheException {
        if (_name == null) {
            throw new IllegalArgumentException(Messages.getString("WhirlycachePlugin.cannot_lookup_cache_with_null_name"));
        }
        this.cacheName = _name;
        try {
            this.cache = CacheManager.getInstance().getCache(_name);
        }
        catch (CacheException e) {
            throw new net.sf.hibernate.cache.CacheException(e.getMessage());
        }
    }

    public void clear() throws net.sf.hibernate.cache.CacheException {
        this.cache.clear();
    }

    public void destroy() throws net.sf.hibernate.cache.CacheException {
        try {
            CacheManager.getInstance().destroy(this.cacheName);
        }
        catch (CacheException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public Object get(Object _key) throws net.sf.hibernate.cache.CacheException {
        return this.cache.retrieve(_key);
    }

    public int getTimeout() {
        return 245760000;
    }

    public void lock(Object arg0) throws net.sf.hibernate.cache.CacheException {
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public void put(Object _key, Object _val) throws net.sf.hibernate.cache.CacheException {
        this.cache.store(_key, _val);
    }

    public void remove(Object _key) throws net.sf.hibernate.cache.CacheException {
        this.cache.remove(_key);
    }

    public void unlock(Object arg0) throws net.sf.hibernate.cache.CacheException {
    }
}

