/*
 * Decompiled with CFR 0.152.
 */
package com.whirlycott.cache.component.store;

import com.whirlycott.cache.Cache;
import com.whirlycott.cache.CacheConfiguration;
import com.whirlycott.cache.CacheDecorator;
import com.whirlycott.cache.CacheMaintenancePolicy;
import com.whirlycott.cache.ManagedCache;
import com.whirlycott.cache.Messages;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.store.Store;

public class WhirlycacheStore
implements Store,
ThreadSafe,
Configurable,
Initializable,
Disposable {
    private Cache cache;
    private CacheConfiguration cacheConfiguration;
    private Class cacheMaintenancePolicyClass;
    private Class managedCacheClass;
    static /* synthetic */ Class class$com$whirlycott$cache$CacheMaintenancePolicy;
    static /* synthetic */ Class class$com$whirlycott$cache$ManagedCache;

    public void clear() {
        this.cache.clear();
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration configuration2 = configuration.getChild("backend");
        Configuration configuration3 = configuration.getChild("policy");
        this.cacheConfiguration = new CacheConfiguration();
        this.cacheConfiguration.setName(configuration.getChild("name").getValue(this.toString()));
        this.cacheConfiguration.setBackend(configuration2.getValue());
        this.cacheConfiguration.setMaxSize(configuration.getChild("maxsize").getValueAsInteger());
        this.cacheConfiguration.setPolicy(configuration3.getValue());
        this.cacheConfiguration.setTunerSleepTime(configuration.getChild("tuner-sleeptime").getValueAsInteger());
        this.managedCacheClass = this.loadManagedCacheClass(configuration2.getLocation());
        this.cacheMaintenancePolicyClass = this.loadCacheMaintenancePolicyClass(configuration3.getLocation());
    }

    public boolean containsKey(Object object) {
        boolean bl = false;
        if (this.cache.retrieve(object) != null) {
            bl = true;
        }
        return bl;
    }

    private CacheMaintenancePolicy[] createCacheMaintenancePolicies(ManagedCache managedCache) throws IllegalAccessException, InstantiationException {
        CacheMaintenancePolicy cacheMaintenancePolicy = (CacheMaintenancePolicy)this.cacheMaintenancePolicyClass.newInstance();
        cacheMaintenancePolicy.setCache(managedCache);
        cacheMaintenancePolicy.setConfiguration(this.cacheConfiguration);
        return new CacheMaintenancePolicy[]{cacheMaintenancePolicy};
    }

    public void dispose() {
        this.cache.clear();
        ((CacheDecorator)this.cache).shutdown();
    }

    public void free() {
    }

    public Object get(Object object) {
        return this.cache.retrieve(object);
    }

    public void initialize() throws Exception {
        ManagedCache managedCache = (ManagedCache)this.managedCacheClass.newInstance();
        this.cache = new CacheDecorator(managedCache, this.cacheConfiguration, this.createCacheMaintenancePolicies(managedCache));
    }

    public Enumeration keys() {
        throw new UnsupportedOperationException();
    }

    private Class loadCacheMaintenancePolicyClass(String string) throws ConfigurationException {
        String string2 = this.cacheConfiguration.getPolicy();
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string2);
            if (!(class$com$whirlycott$cache$CacheMaintenancePolicy == null ? (class$com$whirlycott$cache$CacheMaintenancePolicy = WhirlycacheStore.class$("com.whirlycott.cache.CacheMaintenancePolicy")) : class$com$whirlycott$cache$CacheMaintenancePolicy).isAssignableFrom(clazz)) {
                Object[] objectArray = new Object[]{string2, string};
                throw new ConfigurationException(Messages.getCompoundString("WhirlycacheStore.not_cache_maintenance_policy", objectArray));
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray = new Object[]{string2, string};
            throw new ConfigurationException(Messages.getCompoundString("WhirlycacheStore.cannot_load_policy", objectArray), (Throwable)classNotFoundException);
        }
    }

    private Class loadManagedCacheClass(String string) throws ConfigurationException {
        String string2 = this.cacheConfiguration.getBackend();
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string2);
            if (!(class$com$whirlycott$cache$ManagedCache == null ? (class$com$whirlycott$cache$ManagedCache = WhirlycacheStore.class$("com.whirlycott.cache.ManagedCache")) : class$com$whirlycott$cache$ManagedCache).isAssignableFrom(clazz)) {
                Object[] objectArray = new Object[]{string2, string};
                throw new ConfigurationException(Messages.getCompoundString("WhirlycacheStore.not_managed_cache", objectArray));
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray = new Object[]{string2, string};
            throw new ConfigurationException(Messages.getCompoundString("WhirlycacheStore.cannot_load_backend", objectArray), (Throwable)classNotFoundException);
        }
    }

    public void remove(Object object) {
        this.cache.remove(object);
    }

    public int size() {
        return this.cache.size();
    }

    public void store(Object object, Object object2) throws IOException {
        this.cache.store(object, object2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

