/*
 * Decompiled with CFR 0.152.
 */
package com.whirlycott.cache;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import com.whirlycott.cache.Cache;
import com.whirlycott.cache.CacheConfiguration;
import com.whirlycott.cache.CacheMaintenancePolicy;
import com.whirlycott.cache.Cacheable;
import com.whirlycott.cache.Item;
import com.whirlycott.cache.ManagedCache;
import com.whirlycott.cache.Messages;
import com.whirlycott.cache.RecordKeeper;
import com.whirlycott.cache.policy.ExpirationTimePredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheDecorator
implements Runnable,
Cache {
    private static final Log log = LogFactory.getLog((Class)(class$com$whirlycott$cache$CacheDecorator == null ? (class$com$whirlycott$cache$CacheDecorator = CacheDecorator.class$("com.whirlycott.cache.CacheDecorator")) : class$com$whirlycott$cache$CacheDecorator));
    protected int adaptiveMemorySize = 5000;
    protected final int adaptiveMemorySizeOverflow = 512;
    protected volatile int adaptiveResultCounter = 0;
    protected volatile long currentTime = System.currentTimeMillis();
    protected volatile int[] adaptiveResults;
    protected volatile ManagedCache managedCache;
    protected int maxSize;
    protected final String name;
    private final CacheMaintenancePolicy policy;
    protected final RecordKeeper recordKeeper = new RecordKeeper();
    protected boolean shutdown = false;
    protected long sleepTime = 10000L;
    static /* synthetic */ Class class$com$whirlycott$cache$CacheDecorator;

    public CacheDecorator(ManagedCache managedCache, CacheConfiguration cacheConfiguration, CacheMaintenancePolicy[] cacheMaintenancePolicyArray) {
        this.name = cacheConfiguration.getName();
        if (null == this.name) {
            throw new IllegalArgumentException(Messages.getString("CacheDecorator.cache_config_cannot_be_null"));
        }
        if (null == cacheMaintenancePolicyArray) {
            throw new IllegalArgumentException(Messages.getString("CacheDecorator.policies_cannot_be_null"));
        }
        if (1 != cacheMaintenancePolicyArray.length) {
            throw new IllegalArgumentException(Messages.getString("CacheDecorator.must_provide_single_policy"));
        }
        this.policy = cacheMaintenancePolicyArray[0];
        this.adaptiveResults = new int[this.adaptiveMemorySize + 512];
        this.managedCache = managedCache;
        this.configure(cacheConfiguration);
        Thread thread = new Thread(this);
        Object[] objectArray = new Object[]{this.name};
        thread.setName(Messages.getCompoundString("CacheDecorator.whirlycache_tuner", objectArray));
        thread.setDaemon(true);
        thread.start();
    }

    public void clear() {
        log.info((Object)Messages.getString("CacheDecorator.clearing_cache"));
        this.managedCache.clear();
        Arrays.fill(this.adaptiveResults, 0);
    }

    protected void configure(CacheConfiguration cacheConfiguration) {
        this.setMaxSize(cacheConfiguration.getMaxSize());
        this.setSleepTime((long)cacheConfiguration.getTunerSleepTime() * 1000L);
    }

    protected void doAdaptiveAccounting(int n) {
        int n2;
        if ((n2 = this.adaptiveResultCounter++) >= this.adaptiveMemorySize) {
            this.adaptiveResultCounter = 0;
            this.adaptiveResults[0] = n;
        } else {
            this.adaptiveResults[n2] = n;
        }
    }

    protected int getAdaptiveMemorySize() {
        return this.adaptiveMemorySize;
    }

    public float getAdaptiveRatio() {
        int[] nArray = new int[this.adaptiveMemorySize];
        System.arraycopy(this.adaptiveResults, 0, nArray, 0, this.adaptiveMemorySize);
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != 1) continue;
            ++n;
        }
        return new Float(n).floatValue() / new Float(this.adaptiveMemorySize).floatValue();
    }

    public String getEfficiencyReport() {
        Object[] objectArray = new Object[]{new Integer(this.managedCache.size()), new Long(this.recordKeeper.getTotalOperations()), new Long(this.recordKeeper.getHits()), new Float(this.getAdaptiveRatio()), new Float(this.getTotalHitrate())};
        return Messages.getCompoundString("CacheDecorator.efficiency_report", objectArray);
    }

    protected int getMaxSize() {
        return this.maxSize;
    }

    protected CacheMaintenancePolicy getPolicy() {
        return this.policy;
    }

    protected long getSleepTime() {
        return this.sleepTime;
    }

    protected float getTotalHitrate() {
        return new Long(this.recordKeeper.getHits()).floatValue() / new Long(this.recordKeeper.getTotalOperations()).floatValue();
    }

    public Object remove(Cacheable cacheable) {
        Object object = this.internalRemove(cacheable);
        cacheable.onRemove(object);
        return object;
    }

    public Object remove(Object object) {
        return this.internalRemove(object);
    }

    protected Object internalRemove(Object object) {
        this.recordKeeper.incrementTotalOperations();
        if (object != null) {
            Item item = (Item)this.managedCache.remove(object);
            this.doAdaptiveAccounting(0);
            return null == item ? null : item.getItem();
        }
        return null;
    }

    public Object retrieve(Cacheable cacheable) {
        Object object = this.internalRetrieve(cacheable);
        cacheable.onRetrieve(object);
        return object;
    }

    protected Object internalRetrieve(Object object) {
        this.doAdaptiveAccounting(1);
        this.recordKeeper.incrementTotalOperations();
        Item item = (Item)this.managedCache.get(object);
        if (item != null) {
            item.setUsed(this.recordKeeper.getTotalOperations());
            item.incrementCount();
            Object object2 = item.getItem();
            if (object2 != null) {
                this.recordKeeper.incrementHits();
            }
            return object2;
        }
        return null;
    }

    public Object retrieve(Object object) {
        return this.internalRetrieve(object);
    }

    public void run() {
        log.debug((Object)Messages.getString("CacheDecorator.tuning_thread_started"));
        try {
            while (!this.shutdown) {
                this.currentTime = System.currentTimeMillis();
                long l = this.recordKeeper.getTotalOperations();
                this.tuneCache();
                this.expireItems();
                this.policy.performMaintenance();
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    log.error((Object)interruptedException.getMessage(), (Throwable)interruptedException);
                }
                long l2 = this.recordKeeper.getTotalOperations();
                if (this.sleepTime > 0L && log.isDebugEnabled()) {
                    Object[] objectArray = new Object[]{new Long((l2 - l) / (this.sleepTime / 1000L))};
                    log.debug((Object)Messages.getCompoundString("CacheDecorator.query_rate", objectArray));
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)this.getEfficiencyReport());
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)Messages.getString("CacheDecorator.cache_tuning_complete"));
            }
        }
        catch (RuntimeException runtimeException) {
            log.fatal((Object)Messages.getString("CacheDecorator.unexpected_shutdown"), (Throwable)runtimeException);
        }
        log.debug((Object)Messages.getString("CacheDecorator.shutting_down"));
    }

    protected void setAdaptiveMemorySize(int n) {
        this.adaptiveMemorySize = n;
    }

    protected void setManagedCache(ManagedCache managedCache) {
        this.managedCache = managedCache;
        log.debug((Object)(Messages.getString("CacheDecorator.managing_cache_with_type") + managedCache.getClass()));
    }

    protected void setMaxSize(int n) {
        this.maxSize = n;
    }

    public void setMostlyRead(boolean bl) {
        this.recordKeeper.incrementTotalOperations();
        this.managedCache.setMostlyRead(bl);
    }

    protected void setSleepTime(long l) {
        this.sleepTime = l;
    }

    public void shutdown() {
        log.debug((Object)(Messages.getString("CacheDecorator.shutting_down_cache") + this.name));
        this.shutdown = true;
        log.info((Object)this.getEfficiencyReport());
        this.recordKeeper.reset();
    }

    public int size() {
        this.recordKeeper.incrementTotalOperations();
        return this.managedCache.size();
    }

    public void store(Cacheable cacheable, Object object) {
        this.internalStore(cacheable, object, -1L);
        cacheable.onStore(object);
    }

    public void store(Cacheable cacheable, Object object, long l) {
        this.internalStore(cacheable, object, l);
        cacheable.onStore(object);
    }

    public void store(Object object, Object object2) {
        this.internalStore(object, object2, -1L);
    }

    public void store(Object object, Object object2, long l) {
        this.internalStore(object, object2, l);
    }

    protected void internalStore(Object object, Object object2, long l) {
        this.recordKeeper.incrementTotalOperations();
        if (object != null && object2 != null) {
            Item item = new Item(object2, this.currentTime, l);
            this.managedCache.put(object, item);
            this.doAdaptiveAccounting(0);
        }
    }

    protected void tuneCache() {
        float f = this.getAdaptiveRatio();
        if (f > 0.5f) {
            log.debug((Object)(Messages.getString("CacheDecorator.read_optimizations_on") + f));
            this.managedCache.setMostlyRead(true);
        } else {
            log.debug((Object)(Messages.getString("CacheDecorator.read_optimizations_off") + f));
            this.managedCache.setMostlyRead(false);
        }
    }

    protected void expireItems() {
        ArrayList arrayList = new ArrayList(new ConcurrentHashMap((Map)this.managedCache).entrySet());
        CollectionUtils.filter(arrayList, (Predicate)new ExpirationTimePredicate(this.currentTime));
        Object[] objectArray = new Object[]{new Integer(arrayList.size())};
        log.debug((Object)Messages.getCompoundString("CacheDecorator.expiration_count", objectArray));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (entry == null) continue;
            this.managedCache.remove(entry.getKey());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

