/*
 * Decompiled with CFR 0.152.
 */
package com.whinc.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.whinc.widget.R;

public class RatingBar
extends FrameLayout
implements View.OnClickListener {
    private static final String TAG = RatingBar.class.getSimpleName();
    private static final int MAX_COUNT = 5;
    private int mMaxCount = 5;
    private int mCount = 0;
    private Drawable mFillDrawable = null;
    private Drawable mEmptyDrawable = null;
    private OnCountChangeListener mCountChangeListener = null;
    private ImageView[] mImageViews = null;

    public void setOnCountChangeListener(@Nullable OnCountChangeListener countChangeListener) {
        this.mCountChangeListener = countChangeListener;
    }

    public RatingBar(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public RatingBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public RatingBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public RatingBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    public int getMaxCount() {
        return this.mMaxCount;
    }

    public int getCount() {
        return this.mCount;
    }

    public void setCount(int count) {
        int oldCount = this.mCount;
        this.mCount = Math.max(0, Math.min(count, this.mMaxCount));
        this.update();
        if (this.mCountChangeListener != null) {
            this.mCountChangeListener.onChange(oldCount, this.mCount);
        }
    }

    private void init(Context context, AttributeSet attrs) {
        if (this.isInEditMode()) {
            // empty if block
        }
        if (attrs == null) {
            this.mMaxCount = 5;
            this.mCount = 0;
            if (Build.VERSION.SDK_INT >= 21) {
                this.mFillDrawable = context.getDrawable(R.drawable.fill);
                this.mEmptyDrawable = context.getDrawable(R.drawable.empty);
            } else {
                this.mFillDrawable = context.getResources().getDrawable(R.drawable.fill);
                this.mEmptyDrawable = context.getResources().getDrawable(R.drawable.empty);
            }
        } else {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RatingBar);
            this.mMaxCount = typedArray.getInteger(R.styleable.RatingBar_rb_max_count, 5);
            this.mCount = typedArray.getInteger(R.styleable.RatingBar_rb_count, 0);
            this.mFillDrawable = typedArray.getDrawable(R.styleable.RatingBar_rb_fill);
            this.mEmptyDrawable = typedArray.getDrawable(R.styleable.RatingBar_rb_empty);
            typedArray.recycle();
            if (this.mFillDrawable == null) {
                this.mFillDrawable = Build.VERSION.SDK_INT >= 21 ? context.getDrawable(R.drawable.fill) : context.getResources().getDrawable(R.drawable.fill);
            }
            if (this.mEmptyDrawable == null) {
                this.mEmptyDrawable = Build.VERSION.SDK_INT >= 21 ? context.getDrawable(R.drawable.empty) : context.getResources().getDrawable(R.drawable.empty);
            }
            this.mMaxCount = Math.max(0, this.mMaxCount);
            this.mCount = Math.max(0, Math.min(this.mCount, this.mMaxCount));
        }
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        LinearLayout rootLayout = (LinearLayout)inflater.inflate(R.layout.ratingbar, null);
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
        this.addView((View)rootLayout, lp);
        this.mImageViews = new ImageView[this.mMaxCount];
        for (int i = 0; i < this.mMaxCount; ++i) {
            View view = inflater.inflate(R.layout.include_item, (ViewGroup)rootLayout, false);
            rootLayout.addView(view);
            this.mImageViews[i] = (ImageView)view.findViewById(R.id.star_imageView);
            this.mImageViews[i].setImageDrawable(i < this.mCount ? this.mFillDrawable : this.mEmptyDrawable);
            this.mImageViews[i].setOnClickListener((View.OnClickListener)this);
            this.mImageViews[i].setTag((Object)i);
        }
    }

    private void update() {
        for (int i = 0; i < this.mMaxCount; ++i) {
            this.mImageViews[i].setImageDrawable(i < this.mCount ? this.mFillDrawable : this.mEmptyDrawable);
        }
    }

    public void onClick(View v) {
        Integer index = (Integer)v.getTag();
        this.setCount(index + 1);
    }

    public static interface OnCountChangeListener {
        public void onChange(int var1, int var2);
    }
}

