/*
 * Decompiled with CFR 0.152.
 */
package com.whaley.core.image;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.orhanobut.logger.Logger;
import com.whaley.core.appcontext.AppContextProvider;
import com.whaley.core.image.ImageRequest;
import com.whaley.core.image.OnLoadFailCallback;

public class ResourceGetterTarget
extends SimpleTarget<Bitmap> {
    private ImageRequest request;
    private OnLoadFailCallback onLoadFailCallback;

    public ResourceGetterTarget(ImageRequest request, int witdh, int height) {
        super(witdh, height);
        this.request = request;
    }

    public void setOnLoadFailCallback(OnLoadFailCallback onLoadFailCallback) {
        this.onLoadFailCallback = onLoadFailCallback;
    }

    public void onLoadFailed(Exception e, Drawable errorDrawable) {
        super.onLoadFailed(e, errorDrawable);
        if (this.onLoadFailCallback != null) {
            this.onLoadFailCallback.onLoadFail(e);
        }
        Logger.e((Throwable)e, (String)"loadImage", (Object[])new Object[0]);
    }

    public void onResourceReady(Bitmap resource, GlideAnimation glideAnimation) {
        if (resource.isRecycled()) {
            this.onLoadFailed(new Exception("Bitmap is recycled"), AppContextProvider.getInstance().getContext().getResources().getDrawable(this.request.getErrorResId()));
            return;
        }
        if (this.request.getOnResourceLoadCallback() != null) {
            this.request.getOnResourceLoadCallback().onResourceLoaded(resource);
        }
    }
}

