/*
 * Decompiled with CFR 0.152.
 */
package com.whaley.core.image;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawableFactory;
import android.widget.ImageView;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.BitmapImageViewTarget;
import com.bumptech.glide.request.target.SizeReadyCallback;
import com.orhanobut.logger.Logger;
import com.whaley.core.appcontext.AppContextProvider;
import com.whaley.core.image.GlideImageLoader;
import com.whaley.core.image.ImageLoader;
import com.whaley.core.image.ImageRequest;

public class NormalViewTarget
extends BitmapImageViewTarget {
    final ImageRequest request;

    public NormalViewTarget(ImageRequest imageRequest) {
        super(imageRequest.getImageView());
        this.request = imageRequest;
    }

    public void getSize(SizeReadyCallback cb) {
        if (this.request.getWidth() > 0 && this.request.getHeight() > 0) {
            cb.onSizeReady(this.request.getWidth(), this.request.getHeight());
        } else {
            super.getSize(cb);
        }
    }

    public void onResourceReady(Bitmap resource, GlideAnimation<? super Bitmap> glideAnimation) {
        if (!resource.isRecycled()) {
            super.onResourceReady((Object)resource, glideAnimation);
        }
    }

    public void setDrawable(Drawable drawable) {
        super.setDrawable(drawable);
    }

    public void onLoadCleared(Drawable placeholder) {
        if (this.request.isInitBefore()) {
            super.onLoadCleared(placeholder);
        }
    }

    public void onLoadStarted(Drawable placeholder) {
        if (this.request.isInitBefore()) {
            super.onLoadStarted(placeholder);
        }
    }

    public void onLoadFailed(Exception e, Drawable errorDrawable) {
        try {
            String[] str = this.request.getUrl().split("/zoom/");
            if (str.length > 1) {
                GlideImageLoader.failedCache.put((Object)this.request.getUrl(), (Object)str[0]);
                ImageLoader.loadImage(new ImageRequest(str[0], this.request.getResId(), this.request.getHeight(), this.request.getWidth(), this.request.getScaleType(), this.request.getImageView(), this.request.getProgressBar(), this.request.getTag(), this.request.getPlaceholderResId(), this.request.getErrorResId(), this.request.getCallback(), this.request.getTransformation(), this.request.getAnimator(), this.request.isInitBefore(), this.request.getDiskcacheStrategy(), this.request.isCacheMemory(), this.request.isGetResouce(), this.request.getOnResourceLoadCallback(), this.request.getOnLoadFailCallback(), this.request.isCircle(), this.request.getAngle(), this.request.isMaxSize(), this.request.isArgb8888(), this.request.getCookie()));
            } else {
                super.onLoadFailed(e, errorDrawable);
            }
        }
        catch (Exception ex) {
            super.onLoadFailed(e, errorDrawable);
        }
        Logger.e((Throwable)e, (String)("onLoadFailed url=" + this.request.getUrl()), (Object[])new Object[0]);
    }

    protected void setResource(Bitmap resource) {
        if (resource.isRecycled()) {
            this.onLoadFailed(new Exception("Bitmap is recycled"), AppContextProvider.getInstance().getContext().getResources().getDrawable(this.request.getErrorResId()));
            return;
        }
        if (this.request.isCircle()) {
            RoundedBitmapDrawable circularBitmapDrawable = RoundedBitmapDrawableFactory.create((Resources)AppContextProvider.getInstance().getContext().getResources(), (Bitmap)resource);
            circularBitmapDrawable.setCircular(true);
            ((ImageView)this.view).setImageDrawable((Drawable)circularBitmapDrawable);
        } else if (this.request.getAngle() > 0.0f) {
            RoundedBitmapDrawable circularBitmapDrawable = RoundedBitmapDrawableFactory.create((Resources)AppContextProvider.getInstance().getContext().getResources(), (Bitmap)resource);
            circularBitmapDrawable.setCornerRadius(this.request.getAngle());
            circularBitmapDrawable.setAntiAlias(true);
            ((ImageView)this.view).setImageDrawable((Drawable)circularBitmapDrawable);
        } else {
            super.setResource(resource);
        }
    }
}

