/*
 * Decompiled with CFR 0.152.
 */
package com.whaley.core.image;

import android.graphics.Bitmap;
import android.view.View;
import android.widget.ImageView;
import com.whaley.core.image.Animator;
import com.whaley.core.image.ImageLoader;
import com.whaley.core.image.ImageLoaderCallback;
import com.whaley.core.image.ImageSize;
import com.whaley.core.image.OnLoadFailCallback;
import com.whaley.core.image.OnResourceLoadCallback;
import com.whaley.core.image.Transformation;
import com.whaley.core.utils.DisplayUtil;
import java.util.HashMap;
import java.util.Map;

public class ImageRequest {
    public static int DEFUALT_PLACEHOLDER_RESID;
    public static int DEFUALT_ERRPR_RESID;
    public static ImageSizeGetter DEFAULT_IMAGE_SIZE_GETTER;
    public static final int DISK_ALL = 0;
    public static final int DISK_RESULT = 1;
    public static final int DISK_SOURCE = 2;
    public static final int DISK_NULL = 3;
    private final Map<String, HashMap<String, String>> cookie;
    private final String url;
    private final int resId;
    private final int height;
    private final int width;
    private final ImageView.ScaleType scaleType;
    private final ImageView imageView;
    private final View progressBar;
    private final Object tag;
    private final int placeholderResId;
    private final int errorResId;
    private final ImageLoaderCallback callback;
    private final Transformation transformation;
    private final Animator animator;
    private final boolean isInitBefore;
    private final int diskcacheStrategy;
    private final boolean isCacheMemory;
    private final boolean isGetResouce;
    private final OnResourceLoadCallback onResourceLoadCallback;
    private final OnLoadFailCallback onLoadFailCallback;
    private final boolean isCircle;
    private final float angle;
    private final boolean isMaxSize;
    private final boolean isArgb8888;

    public ImageRequest(String url, int resId, int height, int width, ImageView.ScaleType scaleType, ImageView imageView, View progressBar, Object tag, int placeholderResId, int errorResId, ImageLoaderCallback callback, Transformation transformation, Animator animator, boolean isInitBefore, int diskcacheStrategy, boolean isCacheMemory, boolean isGetResouce, OnResourceLoadCallback onResourceLoadCallback, OnLoadFailCallback onLoadFailCallback, boolean isCircle, float angle, boolean isMaxSize, boolean isArgb8888, Map<String, HashMap<String, String>> cookie) {
        this.cookie = cookie;
        this.url = url;
        this.resId = resId;
        if (width <= 0 && height <= 0 && imageView != null && imageView.getLayoutParams() != null && imageView.getLayoutParams().width > 0 && imageView.getLayoutParams().height > 0) {
            this.width = imageView.getLayoutParams().width;
            this.height = imageView.getLayoutParams().height;
        } else {
            this.width = width;
            this.height = height;
        }
        this.scaleType = scaleType;
        this.imageView = imageView;
        this.progressBar = progressBar;
        this.tag = tag;
        this.placeholderResId = placeholderResId == -1 ? DEFUALT_PLACEHOLDER_RESID : placeholderResId;
        this.errorResId = errorResId == -1 ? DEFUALT_ERRPR_RESID : errorResId;
        this.callback = callback;
        this.transformation = transformation;
        this.animator = animator;
        this.isInitBefore = isInitBefore;
        this.isCacheMemory = isCacheMemory;
        this.diskcacheStrategy = diskcacheStrategy;
        this.isGetResouce = isGetResouce;
        this.onResourceLoadCallback = onResourceLoadCallback;
        this.onLoadFailCallback = onLoadFailCallback;
        this.isCircle = isCircle;
        this.angle = angle;
        this.isMaxSize = isMaxSize;
        this.isArgb8888 = isArgb8888;
    }

    public Map<String, HashMap<String, String>> getCookie() {
        return this.cookie;
    }

    public int getDiskcacheStrategy() {
        return this.diskcacheStrategy;
    }

    public boolean isCacheMemory() {
        return this.isCacheMemory;
    }

    public boolean isInitBefore() {
        return this.isInitBefore;
    }

    public Animator getAnimator() {
        return this.animator;
    }

    public Transformation getTransformation() {
        return this.transformation;
    }

    public ImageLoaderCallback getCallback() {
        return this.callback;
    }

    public String getUrl() {
        return this.url;
    }

    public int getResId() {
        return this.resId;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public ImageView.ScaleType getScaleType() {
        return this.scaleType;
    }

    public ImageView getImageView() {
        return this.imageView;
    }

    public View getProgressBar() {
        return this.progressBar;
    }

    public Object getTag() {
        return this.tag;
    }

    public int getPlaceholderResId() {
        return this.placeholderResId;
    }

    public int getErrorResId() {
        return this.errorResId;
    }

    public boolean isGetResouce() {
        return this.isGetResouce;
    }

    public boolean isCircle() {
        return this.isCircle;
    }

    public float getAngle() {
        return this.angle;
    }

    public boolean isMaxSize() {
        return this.isMaxSize;
    }

    public OnResourceLoadCallback getOnResourceLoadCallback() {
        return this.onResourceLoadCallback;
    }

    public OnLoadFailCallback getOnLoadFailCallback() {
        return this.onLoadFailCallback;
    }

    public boolean isArgb8888() {
        return this.isArgb8888;
    }

    public static interface ImageSizeGetter {
        public ImageSize getImageSize(String var1, int var2);
    }

    public static class Builder {
        private String url;
        private int resId;
        private int height;
        private int width;
        private ImageView.ScaleType scaleType = ImageView.ScaleType.CENTER_CROP;
        private ImageView imageView;
        private View progressBar;
        private Object tag;
        private int placeholderResId = -1;
        private int errorResId = -1;
        private ImageLoaderCallback callback;
        private Transformation transformation;
        private Animator animator;
        private Map<String, HashMap<String, String>> cookie;
        private boolean isInitBefore = true;
        private int diskcacheStrategy = 0;
        private boolean isCacheMemory = true;
        private boolean isGetResouce;
        private OnResourceLoadCallback onResourceLoadCallback;
        private boolean isCircle;
        private float angle;
        private OnLoadFailCallback onLoadFailCallback;
        private boolean isMaxSize;
        private boolean isArgb8888;

        public Builder tag(Object tag) {
            this.tag = tag;
            return this;
        }

        public Builder argb8888() {
            this.isArgb8888 = true;
            return this;
        }

        public Builder maxSize(int maxSize) {
            String url = this.url;
            if (DEFAULT_IMAGE_SIZE_GETTER != null) {
                ImageSize imageSize = DEFAULT_IMAGE_SIZE_GETTER.getImageSize(url, maxSize);
                this.width = imageSize.getWidth();
                this.height = imageSize.getHeight();
                this.url = imageSize.getUrl();
                this.isMaxSize = imageSize.isMax();
            } else {
                this.width = maxSize;
                this.height = maxSize;
                this.isMaxSize = true;
            }
            return this;
        }

        public Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            this.isMaxSize = false;
            return this;
        }

        public Builder small() {
            return this.maxSize((int)(1.0f * (float)DisplayUtil.screenW / 4.0f));
        }

        public Builder medium() {
            return this.maxSize((int)(1.0f * (float)DisplayUtil.screenW / 2.0f));
        }

        public Builder big() {
            return this.maxSize(DisplayUtil.screenW);
        }

        public Builder circle() {
            this.isCircle = true;
            return this;
        }

        public Builder corner(float angle) {
            this.angle = angle;
            return this;
        }

        public Builder load(Object object) {
            if (object instanceof String) {
                return this.load((String)object);
            }
            if (object instanceof Integer) {
                return this.load((Integer)object);
            }
            throw new IllegalArgumentException("load(Object) object must be String or Integer");
        }

        public Builder load(String url) {
            this.url = url;
            this.resId = -1;
            return this;
        }

        public Builder load(int resId) {
            this.resId = resId;
            this.url = null;
            return this;
        }

        public Builder cookie(Map<String, HashMap<String, String>> cookie) {
            this.cookie = cookie;
            return this;
        }

        public Builder placeholder(int placeholderResId) {
            this.placeholderResId = placeholderResId;
            return this;
        }

        public Builder error(int errorResId) {
            this.errorResId = errorResId;
            return this;
        }

        public Builder centerCrop() {
            this.scaleType = ImageView.ScaleType.CENTER_CROP;
            return this;
        }

        public Builder fitCenter() {
            this.scaleType = ImageView.ScaleType.FIT_CENTER;
            return this;
        }

        public Builder fitXY() {
            this.scaleType = ImageView.ScaleType.FIT_XY;
            return this;
        }

        public Builder setScaleType(ImageView.ScaleType scaleType) {
            this.scaleType = scaleType;
            return this;
        }

        public Builder transform(Transformation transformation) {
            this.transformation = transformation;
            return this;
        }

        public Builder animate(Animator animator) {
            this.animator = animator;
            return this;
        }

        public Builder notInitBefore() {
            this.isInitBefore = false;
            return this;
        }

        public Builder diskCacheStrategy(int diskcacheStrategy) {
            this.diskcacheStrategy = diskcacheStrategy;
            if (diskcacheStrategy < 0 || diskcacheStrategy > 3) {
                this.diskcacheStrategy = 0;
            }
            return this;
        }

        public Builder skipMemoryCache(boolean skip) {
            this.isCacheMemory = !skip;
            return this;
        }

        public Builder onLoadFail(OnLoadFailCallback onLoadFailCallback) {
            this.onLoadFailCallback = onLoadFailCallback;
            return this;
        }

        public void into(ImageView imageView, View progressBar, ImageLoaderCallback callback) {
            this.progressBar = progressBar;
            this.imageView = imageView;
            this.callback = callback;
            this.load();
        }

        public void into(ImageView imageView, View progressBar) {
            this.progressBar = progressBar;
            this.imageView = imageView;
            this.load();
        }

        public void into(ImageView imageView) {
            this.imageView = imageView;
            this.load();
        }

        public void get(OnResourceLoadCallback<Bitmap> callback) {
            this.isGetResouce = true;
            this.onResourceLoadCallback = callback;
            this.load();
        }

        private void load() {
            ImageLoader.loadImage(new ImageRequest(this.url, this.resId, this.height, this.width, this.scaleType, this.imageView, this.progressBar, this.tag, this.placeholderResId, this.errorResId, this.callback, this.transformation, this.animator, this.isInitBefore, this.diskcacheStrategy, this.isCacheMemory, this.isGetResouce, this.onResourceLoadCallback, this.onLoadFailCallback, this.isCircle, this.angle, this.isMaxSize, this.isArgb8888, this.cookie));
        }
    }

    public static class RequestManager {
        private Object tag;

        public RequestManager tag(Object tag) {
            this.tag = tag;
            return this;
        }

        public Builder load(Object object) {
            Builder builder = new Builder();
            if (object == null) {
                object = "";
            }
            builder.tag(this.tag);
            builder.load(object);
            return builder;
        }
    }
}

