/*
 * Decompiled with CFR 0.152.
 */
package com.whaley.core.image;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.v4.app.FragmentActivity;
import android.support.v4.util.LruCache;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import com.bumptech.glide.BitmapTypeRequest;
import com.bumptech.glide.DrawableTypeRequest;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.load.model.Headers;
import com.bumptech.glide.load.model.LazyHeaders;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.animation.ViewPropertyAnimation;
import com.bumptech.glide.request.target.Target;
import com.orhanobut.logger.Logger;
import com.whaley.core.appcontext.AppContextProvider;
import com.whaley.core.image.Animator;
import com.whaley.core.image.ImageLoaderCallback;
import com.whaley.core.image.ImageRequest;
import com.whaley.core.image.NormalViewTarget;
import com.whaley.core.image.OnLoadFailCallback;
import com.whaley.core.image.ResourceGetterTarget;
import com.whaley.core.image.Transformation;
import com.whaley.core.utils.StrUtil;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class GlideImageLoader {
    static boolean isLoadNetwork;
    public static LruCache<String, String> failedCache;
    public static long lastTime;

    public static ImageRequest.RequestManager with(Object tag) {
        ImageRequest.RequestManager requestManager = new ImageRequest.RequestManager();
        requestManager.tag(tag);
        return requestManager;
    }

    public static void LogTime(String tag) {
        long time = System.currentTimeMillis();
        Logger.v((String)"ImageLoader", (Object[])new Object[]{"loadImage time " + tag + (time - lastTime)});
        lastTime = time;
    }

    public static void loadImage(final ImageRequest request) {
        block20: {
            try {
                Animator animator;
                DiskCacheStrategy diskCacheStrategy;
                String failedUrl;
                final String url = !StrUtil.isEmpty((String)request.getUrl()) ? (!StrUtil.isEmpty((String)(failedUrl = (String)failedCache.get((Object)request.getUrl()))) ? failedUrl : request.getUrl()) : null;
                BitmapTypeRequest drawableTypeRequest = GlideImageLoader.getRequest(request);
                if (drawableTypeRequest == null) {
                    return;
                }
                if (request.isArgb8888()) {
                    drawableTypeRequest.format(DecodeFormat.ALWAYS_ARGB_8888);
                }
                OnLoadFailCallback onLoadFailCallback = request.getOnLoadFailCallback();
                ImageView.ScaleType scaleType = request.getScaleType();
                drawableTypeRequest.placeholder(request.getPlaceholderResId());
                drawableTypeRequest.error(request.getErrorResId());
                if (scaleType != null) {
                    if (scaleType == ImageView.ScaleType.CENTER_CROP) {
                        drawableTypeRequest.centerCrop();
                    } else if (scaleType == ImageView.ScaleType.FIT_CENTER) {
                        drawableTypeRequest.fitCenter();
                    }
                }
                drawableTypeRequest.skipMemoryCache(!request.isCacheMemory());
                switch (request.getDiskcacheStrategy()) {
                    case 0: {
                        diskCacheStrategy = DiskCacheStrategy.ALL;
                        break;
                    }
                    case 3: {
                        diskCacheStrategy = DiskCacheStrategy.NONE;
                        break;
                    }
                    case 1: {
                        diskCacheStrategy = DiskCacheStrategy.RESULT;
                        break;
                    }
                    case 2: {
                        diskCacheStrategy = DiskCacheStrategy.SOURCE;
                        break;
                    }
                    default: {
                        diskCacheStrategy = DiskCacheStrategy.SOURCE;
                    }
                }
                drawableTypeRequest.diskCacheStrategy(diskCacheStrategy);
                final Transformation transformation = request.getTransformation();
                if (transformation != null) {
                    drawableTypeRequest.transform(new BitmapTransformation[]{new BitmapTransformation(AppContextProvider.getInstance().getContext()){

                        protected Bitmap transform(BitmapPool pool, Bitmap toTransform, int outWidth, int outHeight) {
                            return transformation.transform(toTransform, outWidth, outHeight);
                        }

                        public String getId() {
                            return transformation.getKey();
                        }
                    }});
                }
                if ((animator = request.getAnimator()) != null) {
                    drawableTypeRequest.animate(new ViewPropertyAnimation.Animator(){

                        public void animate(View view) {
                            animator.animate(view);
                        }
                    });
                } else {
                    drawableTypeRequest.animate(new ViewPropertyAnimation.Animator(){

                        public void animate(View view) {
                        }
                    });
                }
                drawableTypeRequest.listener((RequestListener)new RequestListener<Object, Bitmap>(){

                    public boolean onException(Exception e, Object model, Target<Bitmap> target, boolean isFirstResource) {
                        Logger.e((Throwable)e, (String)("onException url=" + url), (Object[])new Object[0]);
                        ImageLoaderCallback callback = request.getCallback();
                        if (callback != null) {
                            callback.onFailue(e);
                        } else if (request.getProgressBar() != null) {
                            request.getProgressBar().setVisibility(8);
                        }
                        try {
                            File file;
                            if (!TextUtils.isEmpty((CharSequence)url) && (file = new File(url)).exists()) {
                                file.delete();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return false;
                    }

                    public boolean onResourceReady(Bitmap resource, Object model, Target<Bitmap> target, boolean isFromMemoryCache, boolean isFirstResource) {
                        if (resource.isRecycled()) {
                            return false;
                        }
                        ImageLoaderCallback callback = request.getCallback();
                        if (callback != null) {
                            callback.onSuccess(url, resource, null);
                        } else if (request.getProgressBar() != null) {
                            request.getProgressBar().setVisibility(8);
                        }
                        return false;
                    }
                });
                if (request.isGetResouce()) {
                    int width = Integer.MIN_VALUE;
                    int height = Integer.MIN_VALUE;
                    if (request.getWidth() > 0 && request.getHeight() > 0) {
                        width = request.getWidth();
                        height = request.getHeight();
                    }
                    ResourceGetterTarget resourceGetterTarget = new ResourceGetterTarget(request, width, height);
                    resourceGetterTarget.setOnLoadFailCallback(onLoadFailCallback);
                    Target target = drawableTypeRequest.into((Target)resourceGetterTarget);
                } else {
                    NormalViewTarget normalViewTarget = new NormalViewTarget(request);
                    Target target = drawableTypeRequest.into((Target)normalViewTarget);
                }
            }
            catch (Exception e) {
                Logger.e((Throwable)e, (String)"loadImage", (Object[])new Object[0]);
                if (request == null || request.getCallback() == null) break block20;
                request.getCallback().onFailue(e);
            }
        }
    }

    public static void clearView(View view) {
        Glide.clear((View)view);
    }

    public static void onHideChanged(Object tag, boolean isHide) {
    }

    public static void pauseRequests(Object tag) {
        RequestManager requestManager = GlideImageLoader.withTag(tag);
        if (requestManager != null) {
            requestManager.pauseRequests();
        }
    }

    public static void resumeRequests(Object tag) {
        RequestManager requestManager = GlideImageLoader.withTag(tag);
        if (requestManager != null) {
            requestManager.resumeRequests();
        }
    }

    public static void cancelRequests(Object tag) {
        RequestManager requestManager = GlideImageLoader.withTag(tag);
        if (requestManager != null) {
            requestManager.onDestroy();
        }
    }

    public static boolean isPause(Object tag) {
        RequestManager requestManager = GlideImageLoader.withTag(tag);
        if (requestManager != null) {
            return requestManager.isPaused();
        }
        return false;
    }

    public static void onLowMemory() {
        Glide.with((Context)AppContextProvider.getInstance().getContext()).onLowMemory();
    }

    public static void onTrimMemory(int level) {
        Glide.with((Context)AppContextProvider.getInstance().getContext()).onTrimMemory(level);
    }

    private static BitmapTypeRequest getRequest(ImageRequest request) {
        Object tag = request.getTag();
        RequestManager requestManager = GlideImageLoader.withTag(tag);
        if (requestManager == null) {
            return null;
        }
        String url = request.getUrl();
        int resId = request.getResId();
        DrawableTypeRequest drawableTypeRequest = null;
        if (url != null) {
            Map<String, HashMap<String, String>> cookie;
            String failedUrl = (String)failedCache.get((Object)request.getUrl());
            if (!StrUtil.isEmpty((String)failedUrl)) {
                url = failedUrl;
            }
            if ((cookie = request.getCookie()) != null) {
                URL _url;
                try {
                    _url = new URL(url);
                }
                catch (Exception e) {
                    return requestManager.load(url).asBitmap();
                }
                String host = _url.getHost();
                Map cookieMaps = cookie.get(host);
                if (cookieMaps != null && (url.startsWith("http") || url.startsWith("www"))) {
                    LazyHeaders.Builder builder = new LazyHeaders.Builder();
                    StringBuilder sb = new StringBuilder();
                    for (String key : cookieMaps.keySet()) {
                        sb.append(key);
                        sb.append("=");
                        sb.append((String)cookieMaps.get(key));
                        sb.append("; ");
                    }
                    builder.addHeader("Cookie", sb.toString());
                    builder.addHeader("Accept-Encoding", "gzip");
                    GlideUrl glideUrl = new GlideUrl(url, (Headers)builder.build());
                    drawableTypeRequest = requestManager.load((Object)glideUrl);
                } else {
                    drawableTypeRequest = requestManager.load(url);
                }
            } else {
                drawableTypeRequest = requestManager.load(url);
            }
        } else if (resId > 0) {
            drawableTypeRequest = requestManager.load(Integer.valueOf(resId));
        } else {
            throw new NullPointerException("Url or ResId can not be empty,You need to call load() method!");
        }
        return drawableTypeRequest.asBitmap();
    }

    private static RequestManager withTag(Object tag) {
        RequestManager requestManager = null;
        if (tag == null) {
            throw new NullPointerException("Tag can not be empty,You need to call tag() method!");
        }
        if (tag instanceof android.support.v4.app.Fragment) {
            android.support.v4.app.Fragment fragment = (android.support.v4.app.Fragment)tag;
            if (fragment.getActivity() != null) {
                requestManager = Glide.with((android.support.v4.app.Fragment)fragment);
            }
        } else if (tag instanceof Fragment) {
            Fragment fragment = (Fragment)tag;
            if (fragment.getActivity() != null) {
                requestManager = Glide.with((Fragment)fragment);
            }
        } else if (tag instanceof FragmentActivity) {
            FragmentActivity fragmentActivity = (FragmentActivity)tag;
            requestManager = Glide.with((FragmentActivity)fragmentActivity);
        } else if (tag instanceof Activity) {
            Activity activity = (Activity)tag;
            requestManager = Glide.with((Activity)activity);
        } else if (tag instanceof Context) {
            Context context = (Context)tag;
            requestManager = Glide.with((Context)context);
        } else {
            throw new IllegalArgumentException("ImageRequest Tag is error Instance,tag only can Activity,FragmentActivity,Fragment and Context!");
        }
        return requestManager;
    }

    static {
        failedCache = new LruCache(15);
    }
}

