/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.plugin.reader.influxdb2reader;

import com.wgzhao.addax.common.exception.AddaxException;
import com.wgzhao.addax.common.plugin.RecordSender;
import com.wgzhao.addax.common.spi.ErrorCode;
import com.wgzhao.addax.common.spi.Reader;
import com.wgzhao.addax.common.util.Configuration;
import com.wgzhao.addax.plugin.reader.influxdb2reader.InfluxDBReaderErrorCode;
import com.wgzhao.addax.plugin.reader.influxdb2reader.InfluxDBReaderTask;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDBReader
extends Reader {

    public static class Task
    extends Reader.Task {
        private InfluxDBReaderTask influxDBReaderTask;

        public void init() {
            Configuration readerSliceConfig = super.getPluginJobConf();
            this.influxDBReaderTask = new InfluxDBReaderTask(readerSliceConfig);
        }

        public void startRead(RecordSender recordSender) {
            this.influxDBReaderTask.startRead(recordSender, super.getTaskPluginCollector());
        }

        public void post() {
            this.influxDBReaderTask.post();
        }

        public void destroy() {
            this.influxDBReaderTask.destroy();
        }
    }

    public static class Job
    extends Reader.Job {
        private static final Logger LOG = LoggerFactory.getLogger(Job.class);
        private Configuration originalConfig = null;

        public void init() {
            this.originalConfig = super.getPluginJobConf();
        }

        public void preCheck() {
            this.init();
            this.originalConfig.getNecessaryValue("endpoint", (ErrorCode)InfluxDBReaderErrorCode.REQUIRED_VALUE);
            List columns = this.originalConfig.getList("column", String.class);
            String querySql = this.originalConfig.getString("querySql", null);
            String database = this.originalConfig.getString("database", null);
            if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{querySql, database})) {
                throw AddaxException.asAddaxException((ErrorCode)InfluxDBReaderErrorCode.REQUIRED_VALUE, (String)"One of database or querySql must be specified");
            }
            if (columns == null || columns.isEmpty()) {
                throw AddaxException.asAddaxException((ErrorCode)InfluxDBReaderErrorCode.REQUIRED_VALUE, (String)"The parameter [column] is not set.");
            }
        }

        public List<Configuration> split(int adviceNumber) {
            Configuration readerSliceConfig = super.getPluginJobConf();
            ArrayList<Configuration> splitConfigs = new ArrayList<Configuration>();
            splitConfigs.add(readerSliceConfig);
            return splitConfigs;
        }

        public void post() {
        }

        public void destroy() {
        }
    }
}

