/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.plugin.reader.excelreader;

import com.wgzhao.addax.common.element.BoolColumn;
import com.wgzhao.addax.common.element.Column;
import com.wgzhao.addax.common.element.DateColumn;
import com.wgzhao.addax.common.element.DoubleColumn;
import com.wgzhao.addax.common.element.LongColumn;
import com.wgzhao.addax.common.element.Record;
import com.wgzhao.addax.common.element.StringColumn;
import com.wgzhao.addax.common.exception.AddaxException;
import com.wgzhao.addax.common.spi.ErrorCode;
import com.wgzhao.addax.plugin.reader.excelreader.ExcelReaderErrorCode;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelHelper {
    public boolean header;
    public int skipRows;
    FileInputStream file;
    Workbook workbook;
    private FormulaEvaluator evaluator;
    private Iterator<Row> rowIterator;

    public ExcelHelper(boolean header, int skipRows) {
        this.header = header;
        this.skipRows = skipRows;
    }

    public void open(String filePath) {
        try {
            this.file = new FileInputStream(filePath);
            this.workbook = filePath.endsWith(".xlsx") ? new XSSFWorkbook((InputStream)this.file) : new HSSFWorkbook((InputStream)this.file);
            Sheet sheet = this.workbook.getSheetAt(0);
            this.evaluator = this.workbook.getCreationHelper().createFormulaEvaluator();
            this.rowIterator = sheet.iterator();
            if (this.header && this.rowIterator.hasNext()) {
                this.rowIterator.next();
            }
            if (this.skipRows > 0) {
                for (int i = 0; this.rowIterator.hasNext() && i < this.skipRows; ++i) {
                    this.rowIterator.next();
                }
            }
        }
        catch (FileNotFoundException e) {
            throw AddaxException.asAddaxException((ErrorCode)ExcelReaderErrorCode.OPEN_FILE_ERROR, (Throwable)e);
        }
        catch (IOException e) {
            throw AddaxException.asAddaxException((ErrorCode)ExcelReaderErrorCode.OPEN_FILE_ERROR, (String)("IOException occurred when open '" + filePath + "':" + e.getMessage()));
        }
    }

    public void close() {
        try {
            this.workbook.close();
            this.file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Record readLine(Record record) {
        if (this.rowIterator.hasNext()) {
            Row row = this.rowIterator.next();
            Iterator cellIterator = row.cellIterator();
            while (cellIterator.hasNext()) {
                Cell cell = (Cell)cellIterator.next();
                switch (this.evaluator.evaluateInCell(cell).getCellType()) {
                    case NUMERIC: {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            record.addColumn((Column)new DateColumn(cell.getDateCellValue()));
                            break;
                        }
                        double a = cell.getNumericCellValue();
                        if ((double)((long)a) == a) {
                            record.addColumn((Column)new LongColumn(Long.valueOf((long)a)));
                            break;
                        }
                        record.addColumn((Column)new DoubleColumn(Double.valueOf(a)));
                        break;
                    }
                    case STRING: {
                        record.addColumn((Column)new StringColumn(cell.getStringCellValue().trim()));
                        break;
                    }
                    case BOOLEAN: {
                        record.addColumn((Column)new BoolColumn(Boolean.valueOf(cell.getBooleanCellValue())));
                        break;
                    }
                    case FORMULA: 
                    case _NONE: {
                        break;
                    }
                    case ERROR: {
                        record.addColumn((Column)new StringColumn());
                        break;
                    }
                    case BLANK: {
                        record.addColumn((Column)new StringColumn(""));
                    }
                }
            }
            return record;
        }
        return null;
    }
}

