/*
 * Decompiled with CFR 0.152.
 */
package com.wesley.camera2.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.support.v13.app.FragmentCompat;
import android.support.v4.app.ActivityCompat;
import android.util.Size;

public class CameraUtil {
    @TargetApi(value=21)
    public static Size chooseVideoSize(Size[] choices) {
        for (Size size : choices) {
            if (size.getWidth() != size.getHeight() * 4 / 3 || size.getWidth() > 720) continue;
            return size;
        }
        return choices[choices.length - 1];
    }

    public static boolean shouldShowRequestPermissionRationale(Fragment context, String[] permissions) {
        for (String permission : permissions) {
            if (!FragmentCompat.shouldShowRequestPermissionRationale((Fragment)context, (String)permission)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPermissionsGranted(Activity context, String[] permissions) {
        for (String permission : permissions) {
            if (ActivityCompat.checkSelfPermission((Context)context, (String)permission) == 0) continue;
            return false;
        }
        return true;
    }

    public static int getOrientation(int rotation, boolean upsideDown) {
        if (upsideDown) {
            switch (rotation) {
                case 0: {
                    return 270;
                }
                case 1: {
                    return 180;
                }
                case 2: {
                    return 90;
                }
                case 3: {
                    return 0;
                }
            }
        } else {
            switch (rotation) {
                case 0: {
                    return 90;
                }
                case 1: {
                    return 0;
                }
                case 2: {
                    return 270;
                }
                case 3: {
                    return 180;
                }
            }
        }
        return 0;
    }
}

