/*
 * Decompiled with CFR 0.152.
 */
package com.wesley.camera2.fragment;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.MediaRecorder;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.support.v13.app.FragmentCompat;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.wesley.camera2.fragment.Camera2PermissionDialog;
import com.wesley.camera2.util.Camera2Listener;
import com.wesley.camera2.util.CameraUtil;
import com.wesley.camera2.widget.AutoFitTextureView;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

@TargetApi(value=21)
public abstract class Camera2Fragment
extends Fragment
implements Camera2Listener {
    public static final String TAG = "Camera2Fragment";
    private AutoFitTextureView mCameraLayout;
    private CameraDevice mCameraDevice;
    private CameraCaptureSession mPreviewSession;
    private Size mPreviewSize;
    private Size mVideoSize;
    private CaptureRequest.Builder mPreviewBuilder;
    private MediaRecorder mMediaRecorder;
    private boolean isRecording;
    private HandlerThread mBackgroundThread;
    private Handler mBackgroundHandler;
    private Semaphore mCameraOpenCloseLock = new Semaphore(1);
    private boolean upsideDown;
    private int mCameraFacing = 1;
    private File mCurrentFile;
    private Camera2Listener mCamera2Listener;
    private CameraDevice.StateCallback mStateCallback = new CameraDevice.StateCallback(){

        public void onOpened(@NonNull CameraDevice camera) {
            Camera2Fragment.this.mCameraDevice = camera;
            Camera2Fragment.this.startPreview();
            Camera2Fragment.this.mCameraOpenCloseLock.release();
            if (null != Camera2Fragment.this.mCameraLayout) {
                Camera2Fragment.this.configureTransform(Camera2Fragment.this.mCameraLayout.getWidth(), Camera2Fragment.this.mCameraLayout.getHeight());
            }
        }

        public void onDisconnected(@NonNull CameraDevice camera) {
            Camera2Fragment.this.mCameraOpenCloseLock.release();
            camera.close();
            Camera2Fragment.this.mCameraDevice = null;
        }

        public void onError(@NonNull CameraDevice camera, int error) {
            Camera2Fragment.this.mCameraOpenCloseLock.release();
            camera.close();
            Camera2Fragment.this.mCameraDevice = null;
            Activity activity = Camera2Fragment.this.getActivity();
            if (null != activity) {
                activity.finish();
            }
        }
    };
    private CameraCaptureSession.StateCallback mSessionCallback = new CameraCaptureSession.StateCallback(){

        public void onConfigured(@NonNull CameraCaptureSession cameraCaptureSession) {
            Camera2Fragment.this.mPreviewSession = cameraCaptureSession;
            Camera2Fragment.this.updatePreview();
        }

        public void onConfigureFailed(@NonNull CameraCaptureSession cameraCaptureSession) {
            Activity activity = Camera2Fragment.this.getActivity();
            if (null != activity) {
                Camera2Fragment.this.mCamera2Listener.onConfigurationFailed();
                activity.finish();
            }
        }
    };
    private TextureView.SurfaceTextureListener mSurfaceTextureListener = new TextureView.SurfaceTextureListener(){

        public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
            Camera2Fragment.this.openCamera(width, height);
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
            Camera2Fragment.this.configureTransform(width, height);
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        }
    };

    public abstract int getTextureResource();

    public abstract File getVideoFile(Context var1);

    public int getCameraFacing() {
        return this.mCameraFacing;
    }

    public void setCameraFacing(int mCameraFacing) {
        this.mCameraFacing = mCameraFacing;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public void startRecordingVideo() {
        try {
            this.isRecording = true;
            this.mMediaRecorder.start();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public void stopRecordingVideo() {
        this.stopRecordingVideo(false);
    }

    private void stopRecordingVideo(boolean kill) {
        this.isRecording = false;
        this.closeCamera();
        if (!kill) {
            this.openCamera(this.mCameraLayout.getWidth(), this.mCameraLayout.getHeight());
        }
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mCameraLayout = (AutoFitTextureView)view.findViewById(this.getTextureResource());
        this.mCamera2Listener = this;
    }

    public void onResume() {
        super.onResume();
        this.startBackgroundThread();
        if (this.mCameraLayout.isAvailable()) {
            this.openCamera(this.mCameraLayout.getWidth(), this.mCameraLayout.getHeight());
        } else {
            this.mCameraLayout.setSurfaceTextureListener(this.mSurfaceTextureListener);
        }
    }

    public void onPause() {
        if (this.isRecording) {
            this.stopRecordingVideo(true);
        } else {
            this.mMediaRecorder = null;
            this.closeCamera();
        }
        this.stopBackgroundThread();
        if (this.mCurrentFile != null) {
            this.mCurrentFile.delete();
        }
        super.onPause();
    }

    private void startBackgroundThread() {
        this.mBackgroundThread = new HandlerThread("CameraBackground");
        this.mBackgroundThread.start();
        this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
    }

    private void stopBackgroundThread() {
        this.mBackgroundThread.quitSafely();
        try {
            this.mBackgroundThread.join();
            this.mBackgroundThread = null;
            this.mBackgroundHandler = null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.mCamera2Listener.onInterruptedException(e);
        }
    }

    protected void requestVideoPermissions() {
        if (CameraUtil.shouldShowRequestPermissionRationale(this, Camera2PermissionDialog.VIDEO_PERMISSIONS)) {
            Camera2PermissionDialog.newInstance(this.getParentFragment()).show(this.getChildFragmentManager(), "PermissionDialog");
        } else {
            FragmentCompat.requestPermissions((Fragment)this, (String[])Camera2PermissionDialog.VIDEO_PERMISSIONS, (int)1);
        }
    }

    private void openCamera(int width, int height) {
        if (!CameraUtil.hasPermissionsGranted(this.getActivity(), Camera2PermissionDialog.VIDEO_PERMISSIONS)) {
            this.requestVideoPermissions();
            return;
        }
        Activity activity = this.getActivity();
        if (activity == null || activity.isFinishing()) {
            return;
        }
        CameraManager cameraManager = (CameraManager)activity.getSystemService("camera");
        try {
            if (!this.mCameraOpenCloseLock.tryAcquire(2500L, TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Time out waiting to lock camera opening.");
            }
            String cameraId = cameraManager.getCameraIdList()[0];
            for (String id : cameraManager.getCameraIdList()) {
                CameraCharacteristics characteristics = cameraManager.getCameraCharacteristics(id);
                int cameraFacing = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
                if (cameraFacing != this.mCameraFacing) continue;
                cameraId = id;
                break;
            }
            CameraCharacteristics characteristics = cameraManager.getCameraCharacteristics(cameraId);
            StreamConfigurationMap map = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            this.mVideoSize = CameraUtil.chooseVideoSize(map.getOutputSizes(MediaRecorder.class));
            this.mPreviewSize = CameraUtil.chooseVideoSize(map.getOutputSizes(SurfaceTexture.class));
            int orientation = this.getResources().getConfiguration().orientation;
            if (orientation == 2) {
                this.mCameraLayout.setAspectRatio(this.mPreviewSize.getWidth(), this.mPreviewSize.getHeight());
            } else {
                this.mCameraLayout.setAspectRatio(this.mPreviewSize.getHeight(), this.mPreviewSize.getWidth());
            }
            int sensorOrientation = (Integer)characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
            if (sensorOrientation == 270) {
                this.upsideDown = true;
            }
            this.configureTransform(width, height);
            this.mMediaRecorder = new MediaRecorder();
            cameraManager.openCamera(cameraId, this.mStateCallback, null);
        }
        catch (CameraAccessException cae) {
            cae.printStackTrace();
            this.mCamera2Listener.onCameraException(cae);
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            this.mCamera2Listener.onNullPointerException(npe);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
            this.mCamera2Listener.onInterruptedException(ie);
            throw new RuntimeException("Interrupted while trying to lock camera opening.");
        }
        catch (SecurityException se) {
            this.requestVideoPermissions();
        }
    }

    private void closeCamera() {
        try {
            this.mCameraOpenCloseLock.acquire();
            if (this.mPreviewSession != null) {
                this.mPreviewSession.close();
                this.mPreviewSession = null;
            }
            if (this.mCameraDevice != null) {
                this.mCameraDevice.close();
                this.mCameraDevice = null;
            }
            if (this.mMediaRecorder != null) {
                this.mMediaRecorder.stop();
                this.mMediaRecorder.release();
                this.mMediaRecorder = null;
            }
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
            this.mCamera2Listener.onInterruptedException(ie);
            throw new RuntimeException("Interrupted while trying to lock camera closing.");
        }
        finally {
            this.mCameraOpenCloseLock.release();
        }
    }

    private void startPreview() {
        if (this.mCameraDevice == null || !this.mCameraLayout.isAvailable() || this.mPreviewSize == null) {
            return;
        }
        try {
            this.setUpMediaRecorder();
            this.mCameraDevice.createCaptureSession(this.getSurfaces(), this.mSessionCallback, this.mBackgroundHandler);
        }
        catch (CameraAccessException cae) {
            cae.printStackTrace();
            this.mCamera2Listener.onCameraException(cae);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.mCamera2Listener.onIOException(ioe);
        }
    }

    private List<Surface> getSurfaces() {
        ArrayList<Surface> surfaces = new ArrayList<Surface>();
        try {
            SurfaceTexture texture = this.mCameraLayout.getSurfaceTexture();
            assert (texture != null);
            texture.setDefaultBufferSize(this.mPreviewSize.getWidth(), this.mPreviewSize.getHeight());
            this.mPreviewBuilder = this.mCameraDevice.createCaptureRequest(3);
            Surface previewSurface = new Surface(texture);
            surfaces.add(previewSurface);
            this.mPreviewBuilder.addTarget(previewSurface);
            Surface recorderSurface = this.mMediaRecorder.getSurface();
            surfaces.add(recorderSurface);
            this.mPreviewBuilder.addTarget(recorderSurface);
        }
        catch (CameraAccessException cae) {
            cae.printStackTrace();
            this.mCamera2Listener.onCameraException(cae);
        }
        return surfaces;
    }

    private void updatePreview() {
        if (this.mCameraDevice == null) {
            return;
        }
        try {
            this.setUpCaptureRequestBuilder(this.mPreviewBuilder);
            HandlerThread thread = new HandlerThread("CameraPreview");
            thread.start();
            this.mPreviewSession.setRepeatingRequest(this.mPreviewBuilder.build(), null, this.mBackgroundHandler);
        }
        catch (CameraAccessException cae) {
            cae.printStackTrace();
            this.mCamera2Listener.onCameraException(cae);
        }
    }

    protected void setUpCaptureRequestBuilder(CaptureRequest.Builder builder) {
        builder.set(CaptureRequest.CONTROL_MODE, (Object)1);
    }

    private void configureTransform(int viewWidth, int viewHeight) {
        Activity activity = this.getActivity();
        if (this.mCameraLayout == null || this.mPreviewSize == null || activity == null) {
            return;
        }
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        Matrix matrix = new Matrix();
        RectF viewRect = new RectF(0.0f, 0.0f, (float)viewWidth, (float)viewHeight);
        RectF bufferRect = new RectF(0.0f, 0.0f, (float)this.mPreviewSize.getHeight(), (float)this.mPreviewSize.getWidth());
        float centerX = viewRect.centerX();
        float centerY = viewRect.centerY();
        if (rotation == 1 || rotation == 3) {
            bufferRect.offset(centerX - bufferRect.centerX(), centerY - bufferRect.centerY());
            matrix.setRectToRect(viewRect, bufferRect, Matrix.ScaleToFit.FILL);
            float scale = Math.max((float)viewHeight / (float)this.mPreviewSize.getHeight(), (float)viewWidth / (float)this.mPreviewSize.getWidth());
            matrix.postScale(scale, scale, centerX, centerY);
            matrix.postRotate((float)(90 * (rotation - 2)), centerX, centerY);
        }
        this.mCameraLayout.setTransform(matrix);
    }

    protected File getCurrentFile() {
        return this.mCurrentFile;
    }

    protected void setUpMediaRecorder() throws IOException {
        File file;
        Activity activity = this.getActivity();
        if (null == activity) {
            return;
        }
        this.mCurrentFile = file = this.getVideoFile((Context)activity);
        this.mMediaRecorder.setAudioSource(5);
        this.mMediaRecorder.setVideoSource(2);
        this.mMediaRecorder.setOutputFormat(2);
        this.mMediaRecorder.setOutputFile(file.getAbsolutePath());
        this.mMediaRecorder.setVideoEncodingBitRate(1600000);
        this.mMediaRecorder.setVideoFrameRate(30);
        this.mMediaRecorder.setVideoSize(this.mVideoSize.getWidth(), this.mVideoSize.getHeight());
        this.mMediaRecorder.setVideoEncoder(2);
        this.mMediaRecorder.setAudioEncoder(3);
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        int orientation = CameraUtil.getOrientation(rotation, this.upsideDown);
        this.mMediaRecorder.setOrientationHint(orientation);
        this.mMediaRecorder.prepare();
    }

    @Override
    public void onCameraException(CameraAccessException cae) {
        cae.printStackTrace();
    }

    @Override
    public void onNullPointerException(NullPointerException npe) {
        npe.printStackTrace();
    }

    @Override
    public void onInterruptedException(InterruptedException ie) {
        ie.printStackTrace();
    }

    @Override
    public void onIOException(IOException ioe) {
        ioe.printStackTrace();
    }

    @Override
    public void onConfigurationFailed() {
        Log.e((String)TAG, (String)"Failed to configure camera");
    }
}

