/*
 * Decompiled with CFR 0.152.
 */
package com.wenhui.shimmerimageview;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.view.ViewCompat;
import com.wenhui.shimmerimageview.MaskSpecs;
import com.wenhui.shimmerimageview.ShimmerImageView$startAnimation$;
import com.wenhui.shimmerimageview.ShimmerImageViewKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wenhui.com.library.R;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010.\u001a\u0004\u0018\u00010\u00142\u0006\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u0007H\u0002J\u0012\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u00104\u001a\u000202H\u0002J\u0012\u00105\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\u0017H\u0002J\b\u00106\u001a\u000207H\u0002J\b\u00108\u001a\u000209H\u0002J\n\u0010:\u001a\u0004\u0018\u00010\u0014H\u0002J\b\u0010;\u001a\u000202H\u0014J0\u0010<\u001a\u0002022\u0006\u0010=\u001a\u00020\u00102\u0006\u0010>\u001a\u00020\u00072\u0006\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u00072\u0006\u0010A\u001a\u00020\u0007H\u0014J\b\u0010B\u001a\u000202H\u0002J\u0019\u0010C\u001a\u0002022\u000e\b\u0004\u0010D\u001a\b\u0012\u0004\u0012\u0002020EH\u0082\bJ\u0006\u0010F\u001a\u000202J\u0006\u0010G\u001a\u000202J\n\u0010H\u001a\u0004\u0018\u00010\u0014H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"R/\u0010%\u001a\u0004\u0018\u00010\u00142\b\u0010\u000f\u001a\u0004\u0018\u00010\u00148B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0014\u0010,\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u000e\u00a8\u0006I"}, d2={"Lcom/wenhui/shimmerimageview/ShimmerImageView;", "Landroidx/appcompat/widget/AppCompatImageView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "animation", "Landroid/animation/ValueAnimator;", "heightFloat", "", "getHeightFloat", "()F", "<set-?>", "", "isAnimationRunning", "()Z", "maskBitmap", "Landroid/graphics/Bitmap;", "maskOffsetX", "maskRenderCanvas", "Landroid/graphics/Canvas;", "value", "Lcom/wenhui/shimmerimageview/MaskSpecs;", "maskSpecs", "getMaskSpecs", "()Lcom/wenhui/shimmerimageview/MaskSpecs;", "setMaskSpecs", "(Lcom/wenhui/shimmerimageview/MaskSpecs;)V", "paint", "Landroid/graphics/Paint;", "getPaint", "()Landroid/graphics/Paint;", "paint$delegate", "Lkotlin/Lazy;", "renderMaskBitmap", "getRenderMaskBitmap", "()Landroid/graphics/Bitmap;", "setRenderMaskBitmap", "(Landroid/graphics/Bitmap;)V", "renderMaskBitmap$delegate", "Lkotlin/properties/ReadWriteProperty;", "widthFloat", "getWidthFloat", "createBitmap", "width", "height", "draw", "", "canvas", "drawMaskToBitmap", "drawMaskUsingBitmap", "getGradientColors", "", "getGradientPositions", "", "getMaskBitmap", "onDetachedFromWindow", "onLayout", "changed", "left", "top", "right", "bottom", "resetAnimation", "runAfterLaidOut", "block", "Lkotlin/Function0;", "startAnimation", "stopAnimation", "tryObtainRenderMaskBitmap", "shimmer-imageview_release"})
public final class ShimmerImageView
extends AppCompatImageView {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private Bitmap maskBitmap;
    private Canvas maskRenderCanvas;
    private final ReadWriteProperty renderMaskBitmap$delegate;
    private ValueAnimator animation;
    private float maskOffsetX;
    private final Lazy paint$delegate;
    @NotNull
    private MaskSpecs maskSpecs;
    private boolean isAnimationRunning;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ShimmerImageView.class), "renderMaskBitmap", "getRenderMaskBitmap()Landroid/graphics/Bitmap;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ShimmerImageView.class), "paint", "getPaint()Landroid/graphics/Paint;"))};
    }

    private final Bitmap getRenderMaskBitmap() {
        return (Bitmap)this.renderMaskBitmap$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setRenderMaskBitmap(Bitmap bitmap) {
        this.renderMaskBitmap$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bitmap);
    }

    private final float getWidthFloat() {
        return this.getWidth();
    }

    private final float getHeightFloat() {
        return this.getHeight();
    }

    private final Paint getPaint() {
        Lazy lazy = this.paint$delegate;
        ShimmerImageView shimmerImageView = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (Paint)lazy.getValue();
    }

    @NotNull
    public final MaskSpecs getMaskSpecs() {
        return this.maskSpecs;
    }

    public final void setMaskSpecs(@NotNull MaskSpecs value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.maskSpecs = value;
        this.resetAnimation();
    }

    public final boolean isAnimationRunning() {
        return this.isAnimationRunning;
    }

    public final void startAnimation() {
        if (this.isAnimationRunning) {
            return;
        }
        if (this.getDrawable() == null) {
            this.isAnimationRunning = false;
            return;
        }
        this.isAnimationRunning = true;
        ShimmerImageView this_$iv = this;
        boolean $i$f$runAfterLaidOut = false;
        if (ViewCompat.isLaidOut((View)((View)this_$iv))) {
            boolean bl = false;
            if (this.isAnimationRunning()) {
                int startWidth = this.getWidth() + (int)((float)this.getMaskSpecs().getStartDelayed() / (float)this.getMaskSpecs().getAnimationDuration());
                ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{-(startWidth + this.getWidth()), this.getWidth()});
                ShimmerImageView shimmerImageView = this;
                ValueAnimator $receiver = valueAnimator;
                boolean bl2 = false;
                $receiver.setDuration(this.getMaskSpecs().getAnimationDuration() + this.getMaskSpecs().getStartDelayed());
                $receiver.setRepeatCount(-1);
                $receiver.setRepeatMode(1);
                $receiver.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                $receiver.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
                    final /* synthetic */ ShimmerImageView this$0;
                    {
                        this.this$0 = shimmerImageView;
                    }

                    public final void onAnimationUpdate(ValueAnimator it) {
                        ValueAnimator valueAnimator = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"it");
                        Object object = valueAnimator.getAnimatedValue();
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                        }
                        ShimmerImageView.access$setMaskOffsetX$p(this.this$0, ((Integer)object).intValue());
                        this.this$0.invalidate();
                    }
                });
                $receiver.start();
                ValueAnimator valueAnimator2 = valueAnimator;
                shimmerImageView.animation = valueAnimator2;
            }
        } else {
            this_$iv.addOnLayoutChangeListener(new View.OnLayoutChangeListener(this_$iv, this){
                final /* synthetic */ ShimmerImageView this$0$inline_fun;
                final /* synthetic */ ShimmerImageView this$0;
                {
                    this.this$0$inline_fun = $outer;
                    this.this$0 = shimmerImageView;
                }

                public void onLayoutChange(@Nullable View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    this.this$0$inline_fun.removeOnLayoutChangeListener(this);
                    boolean bl = false;
                    if (this.this$0.isAnimationRunning()) {
                        int startWidth = this.this$0.getWidth() + (int)((float)this.this$0.getMaskSpecs().getStartDelayed() / (float)this.this$0.getMaskSpecs().getAnimationDuration());
                        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{-(startWidth + this.this$0.getWidth()), this.this$0.getWidth()});
                        ShimmerImageView shimmerImageView = this.this$0;
                        ValueAnimator $receiver = valueAnimator;
                        boolean bl2 = false;
                        $receiver.setDuration(this.this$0.getMaskSpecs().getAnimationDuration() + this.this$0.getMaskSpecs().getStartDelayed());
                        $receiver.setRepeatCount(-1);
                        $receiver.setRepeatMode(1);
                        $receiver.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                        $receiver.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
                            final /* synthetic */ startAnimation$$inlined$runAfterLaidOut$1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final void onAnimationUpdate(ValueAnimator it) {
                                ShimmerImageView shimmerImageView = this.this$0.this$0;
                                ValueAnimator valueAnimator = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"it");
                                Object object = valueAnimator.getAnimatedValue();
                                if (object == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                                }
                                ShimmerImageView.access$setMaskOffsetX$p(shimmerImageView, ((Integer)object).intValue());
                                this.this$0.this$0.invalidate();
                            }
                        });
                        $receiver.start();
                        ValueAnimator valueAnimator2 = valueAnimator;
                        ShimmerImageView.access$setAnimation$p(shimmerImageView, valueAnimator2);
                    }
                }
            });
        }
    }

    private final void runAfterLaidOut(Function0<Unit> block) {
        int $i$f$runAfterLaidOut = 0;
        if (ViewCompat.isLaidOut((View)((View)this))) {
            block.invoke();
            return;
        }
        this.addOnLayoutChangeListener(new View.OnLayoutChangeListener(this, block){
            final /* synthetic */ ShimmerImageView this$0;
            final /* synthetic */ Function0 $block;

            public void onLayoutChange(@Nullable View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                this.this$0.removeOnLayoutChangeListener(this);
                this.$block.invoke();
            }
            {
                this.this$0 = $outer;
                this.$block = $captured_local_variable$1;
            }
        });
    }

    public final void stopAnimation() {
        ValueAnimator valueAnimator = this.animation;
        if (valueAnimator != null) {
            valueAnimator.cancel();
        }
        this.animation = null;
        this.isAnimationRunning = false;
        this.maskOffsetX = 0.0f;
        this.maskBitmap = null;
        this.setRenderMaskBitmap(null);
        this.invalidate();
    }

    private final void resetAnimation() {
        boolean animationStarted = this.isAnimationRunning;
        this.stopAnimation();
        this.getPaint().setXfermode((Xfermode)new PorterDuffXfermode(this.maskSpecs.getMaskMode()));
        if (animationStarted) {
            this.startAnimation();
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            this.resetAnimation();
        }
    }

    public void draw(@Nullable Canvas canvas) {
        super.draw(canvas);
        this.drawMaskUsingBitmap(canvas);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopAnimation();
    }

    private final void drawMaskUsingBitmap(Canvas canvas) {
        block2: {
            Bitmap bitmap;
            if (!this.isAnimationRunning) {
                return;
            }
            Bitmap bitmap2 = this.tryObtainRenderMaskBitmap();
            if (bitmap2 == null) break block2;
            Bitmap it = bitmap = bitmap2;
            boolean bl = false;
            this.drawMaskToBitmap();
            Canvas canvas2 = canvas;
            if (canvas2 != null) {
                canvas2.drawBitmap(it, 0.0f, 0.0f, null);
            }
        }
    }

    private final Bitmap tryObtainRenderMaskBitmap() {
        Bitmap bitmap = this.getRenderMaskBitmap();
        if (bitmap == null) {
            Bitmap bitmap2 = this.createBitmap(this.getWidth(), this.getHeight());
            if (bitmap2 != null) {
                Bitmap bitmap3;
                Bitmap $receiver = bitmap3 = bitmap2;
                boolean bl = false;
                this.setRenderMaskBitmap($receiver);
                bitmap = bitmap3;
            } else {
                bitmap = null;
            }
        }
        return bitmap;
    }

    private final void drawMaskToBitmap() {
        block1: {
            Canvas canvas;
            Bitmap bitmap = this.getMaskBitmap();
            if (bitmap == null) {
                return;
            }
            Bitmap bitmap2 = bitmap;
            Canvas canvas2 = this.maskRenderCanvas;
            if (canvas2 == null) break block1;
            Canvas $receiver = canvas = canvas2;
            boolean bl = false;
            $receiver.save();
            $receiver.clipRect(this.maskOffsetX, 0.0f, this.maskOffsetX + (float)bitmap2.getWidth(), (float)bitmap2.getHeight());
            super.draw($receiver);
            $receiver.drawBitmap(bitmap2, this.maskOffsetX, 0.0f, this.getPaint());
            $receiver.restore();
        }
    }

    private final Bitmap getMaskBitmap() {
        Bitmap bitmap = this.maskBitmap;
        if (bitmap == null) {
            Bitmap bitmap2 = this.createBitmap(this.getWidth(), this.getHeight());
            if (bitmap2 != null) {
                Paint paint2;
                Bitmap bitmap3;
                Bitmap $receiver = bitmap3 = bitmap2;
                boolean bl = false;
                this.maskBitmap = $receiver;
                Canvas canvas = new Canvas($receiver);
                Paint $receiver2 = paint2 = new Paint();
                boolean bl2 = false;
                $receiver2.setAntiAlias(true);
                $receiver2.setShader((Shader)new LinearGradient(this.getWidthFloat(), 0.0f, 0.0f, 0.0f, this.getGradientColors(), this.getGradientPositions(), Shader.TileMode.CLAMP));
                $receiver2.setColorFilter((ColorFilter)new PorterDuffColorFilter(this.maskSpecs.getMaskColor(), PorterDuff.Mode.SRC_IN));
                Paint paint3 = paint2;
                canvas.drawRect(0.0f, 0.0f, this.getWidthFloat(), this.getHeightFloat(), paint3);
                bitmap = bitmap3;
            } else {
                bitmap = null;
            }
        }
        return bitmap;
    }

    private final int[] getGradientColors() {
        return new int[]{0, -16777216, -16777216, 0};
    }

    private final float[] getGradientPositions() {
        return new float[]{Math.max(0.0f, this.maskSpecs.getDropOff()), 0.5f - this.maskSpecs.getIntensity() / 2.0f, 0.5f + this.maskSpecs.getIntensity() / 2.0f, Math.min(1.0f, 1.0f - this.maskSpecs.getDropOff())};
    }

    private final Bitmap createBitmap(int width, int height) {
        Bitmap bitmap;
        try {
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (OutOfMemoryError ome) {
            bitmap = null;
        }
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public ShimmerImageView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        block1: {
            void initialValue$iv;
            ReadWriteProperty readWriteProperty;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            super(context, attrs, defStyleAttr);
            Delegates delegates = Delegates.INSTANCE;
            Object var5_5 = null;
            ShimmerImageView shimmerImageView = this;
            shimmerImageView.renderMaskBitmap$delegate = readWriteProperty = (ReadWriteProperty)new ObservableProperty<Bitmap>((Object)initialValue$iv, (Object)initialValue$iv, this){
                final /* synthetic */ Object $initialValue;
                final /* synthetic */ ShimmerImageView this$0;
                {
                    this.$initialValue = $captured_local_variable$1;
                    this.this$0 = shimmerImageView;
                    super($super_call_param$2);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                    Canvas canvas;
                    void newValue2;
                    Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
                    Bitmap bitmap = (Bitmap)newValue;
                    Bitmap bitmap2 = (Bitmap)oldValue;
                    KProperty $noName_0 = property;
                    boolean bl = false;
                    ShimmerImageView shimmerImageView = this.this$0;
                    void v1 = newValue2;
                    if (v1 != null) {
                        Canvas canvas2;
                        void var8_8 = v1;
                        ShimmerImageView shimmerImageView2 = shimmerImageView;
                        void it = var8_8;
                        boolean bl2 = false;
                        Canvas $receiver = canvas2 = new Canvas();
                        boolean bl3 = false;
                        $receiver.setBitmap((Bitmap)newValue2);
                        Canvas canvas3 = canvas2;
                        shimmerImageView = shimmerImageView2;
                        canvas = canvas3;
                    } else {
                        canvas = null;
                    }
                    ShimmerImageView.access$setMaskRenderCanvas$p(shimmerImageView, canvas);
                }
            };
            this.paint$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Paint>(this){
                final /* synthetic */ ShimmerImageView this$0;

                @NotNull
                public final Paint invoke() {
                    Paint paint2;
                    Paint $receiver = paint2 = new Paint();
                    boolean bl = false;
                    $receiver.setAntiAlias(true);
                    $receiver.setXfermode((Xfermode)new PorterDuffXfermode(this.this$0.getMaskSpecs().getMaskMode()));
                    return paint2;
                }
                {
                    this.this$0 = shimmerImageView;
                    super(0);
                }
            }));
            this.maskSpecs = new MaskSpecs(0, 0.0f, 0.0f, null, 0L, 0L, 63, null);
            AttributeSet attributeSet = attrs;
            if (attributeSet == null) break block1;
            Delegates it = delegates = attributeSet;
            boolean bl = false;
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ShimmerImageView);
            int maskColor = a.getColor(R.styleable.ShimmerImageView_maskSpecs_maskColor, -2236963);
            float intensity = a.getFloat(R.styleable.ShimmerImageView_maskSpecs_intensity, 0.0f);
            float dropOff = a.getFloat(R.styleable.ShimmerImageView_maskSpecs_dropOff, 0.3f);
            PorterDuff.Mode maskMode = ShimmerImageViewKt.access$parseMaskMode(a.getInt(R.styleable.ShimmerImageView_maskSpecs_maskMode, -1));
            int animationDuration = a.getInt(R.styleable.ShimmerImageView_maskSpecs_animationDuration, 1200);
            int startDelayed = a.getInt(R.styleable.ShimmerImageView_maskSpecs_startDelayed, 0);
            boolean startAnimation = a.getBoolean(R.styleable.ShimmerImageView_startAnimation, false);
            a.recycle();
            this.setMaskSpecs(new MaskSpecs(maskColor, intensity, dropOff, maskMode, animationDuration, startDelayed));
            if (startAnimation) {
                this.startAnimation();
            }
        }
    }

    @JvmOverloads
    public /* synthetic */ ShimmerImageView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public ShimmerImageView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ShimmerImageView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ boolean access$isAnimationRunning$p(ShimmerImageView $this) {
        return $this.isAnimationRunning;
    }

    public static final /* synthetic */ void access$setAnimationRunning$p(ShimmerImageView $this, boolean bl) {
        $this.isAnimationRunning = bl;
    }

    public static final /* synthetic */ ValueAnimator access$getAnimation$p(ShimmerImageView $this) {
        return $this.animation;
    }

    public static final /* synthetic */ float access$getMaskOffsetX$p(ShimmerImageView $this) {
        return $this.maskOffsetX;
    }

    public static final /* synthetic */ void access$setMaskOffsetX$p(ShimmerImageView $this, float f) {
        $this.maskOffsetX = f;
    }

    public static final /* synthetic */ Canvas access$getMaskRenderCanvas$p(ShimmerImageView $this) {
        return $this.maskRenderCanvas;
    }

    public static final /* synthetic */ void access$setMaskRenderCanvas$p(ShimmerImageView $this, Canvas canvas) {
        $this.maskRenderCanvas = canvas;
    }
}

