/*
 * Decompiled with CFR 0.152.
 */
package com.wenhui.shimmerimageview;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.DecelerateInterpolator;
import com.wenhui.shimmerimageview.MaskSpecs;
import com.wenhui.shimmerimageview.ShimmerImageView$startAnimation$;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010+\u001a\u0004\u0018\u00010\u00102\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007H\u0002J\u0012\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u00101\u001a\u00020/H\u0002J\u0012\u00102\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u00010\u0013H\u0002J\b\u00103\u001a\u000204H\u0002J\b\u00105\u001a\u000206H\u0002J\n\u00107\u001a\u0004\u0018\u00010\u0010H\u0002J\u0006\u00108\u001a\u000209J\b\u0010:\u001a\u00020/H\u0014J0\u0010;\u001a\u00020/2\u0006\u0010<\u001a\u0002092\u0006\u0010=\u001a\u00020\u00072\u0006\u0010>\u001a\u00020\u00072\u0006\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u0007H\u0014J\b\u0010A\u001a\u00020/H\u0002J\u0019\u0010B\u001a\u00020/2\u000e\b\u0004\u0010C\u001a\b\u0012\u0004\u0012\u00020/0DH\u0082\bJ\u0006\u0010E\u001a\u00020/J\u0006\u0010F\u001a\u00020/J\n\u0010G\u001a\u0004\u0018\u00010\u0010H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001eR/\u0010\"\u001a\u0004\u0018\u00010\u00102\b\u0010!\u001a\u0004\u0018\u00010\u00108B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b'\u0010(\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0014\u0010)\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u000e\u00a8\u0006H"}, d2={"Lcom/wenhui/shimmerimageview/ShimmerImageView;", "Landroid/support/v7/widget/AppCompatImageView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "animation", "Landroid/animation/ValueAnimator;", "heightFloat", "", "getHeightFloat", "()F", "maskBitmap", "Landroid/graphics/Bitmap;", "maskOffsetX", "maskRenderCanvas", "Landroid/graphics/Canvas;", "value", "Lcom/wenhui/shimmerimageview/MaskSpecs;", "maskSpecs", "getMaskSpecs", "()Lcom/wenhui/shimmerimageview/MaskSpecs;", "setMaskSpecs", "(Lcom/wenhui/shimmerimageview/MaskSpecs;)V", "paint", "Landroid/graphics/Paint;", "getPaint", "()Landroid/graphics/Paint;", "paint$delegate", "Lkotlin/Lazy;", "<set-?>", "renderMaskBitmap", "getRenderMaskBitmap", "()Landroid/graphics/Bitmap;", "setRenderMaskBitmap", "(Landroid/graphics/Bitmap;)V", "renderMaskBitmap$delegate", "Lkotlin/properties/ReadWriteProperty;", "widthFloat", "getWidthFloat", "createBitmap", "width", "height", "draw", "", "canvas", "drawMaskToBitmap", "drawMaskUsingBitmap", "getGradientColors", "", "getGradientPositions", "", "getMaskBitmap", "isAnimationRunning", "", "onDetachedFromWindow", "onLayout", "changed", "left", "top", "right", "bottom", "resetAnimation", "runAfterLaidOut", "block", "Lkotlin/Function0;", "startAnimation", "stopAnimation", "tryObtainRenderMaskBitmap", "shimmer-imageview_release"})
public final class ShimmerImageView
extends AppCompatImageView {
    private Bitmap maskBitmap;
    private Canvas maskRenderCanvas;
    private final ReadWriteProperty renderMaskBitmap$delegate;
    private ValueAnimator animation;
    private float maskOffsetX;
    private final Lazy paint$delegate;
    @NotNull
    private MaskSpecs maskSpecs;
    static final /* synthetic */ KProperty[] $$delegatedProperties;

    private final Bitmap getRenderMaskBitmap() {
        return (Bitmap)this.renderMaskBitmap$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setRenderMaskBitmap(Bitmap bitmap) {
        this.renderMaskBitmap$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bitmap);
    }

    private final float getWidthFloat() {
        return this.getWidth();
    }

    private final float getHeightFloat() {
        return this.getHeight();
    }

    private final Paint getPaint() {
        Lazy lazy = this.paint$delegate;
        ShimmerImageView shimmerImageView = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (Paint)lazy.getValue();
    }

    @NotNull
    public final MaskSpecs getMaskSpecs() {
        return this.maskSpecs;
    }

    public final void setMaskSpecs(@NotNull MaskSpecs value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.maskSpecs = value;
        this.resetAnimation();
    }

    public final void startAnimation() {
        if (this.getDrawable() == null || this.isAnimationRunning()) {
            return;
        }
        ShimmerImageView this_$iv = this;
        if (ViewCompat.isLaidOut((View)((View)this_$iv))) {
            ValueAnimator valueAnimator;
            int startWidth = this.getWidth() + (int)((float)this.getMaskSpecs().getStartDelayed() / (float)this.getMaskSpecs().getAnimationDuration());
            ValueAnimator $receiver = valueAnimator = ValueAnimator.ofInt((int[])new int[]{-(startWidth + this.getWidth()), this.getWidth()});
            this.animation = $receiver;
            $receiver.setDuration(this.getMaskSpecs().getAnimationDuration() + this.getMaskSpecs().getStartDelayed());
            $receiver.setRepeatCount(-1);
            $receiver.setRepeatMode(1);
            $receiver.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            $receiver.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
                final /* synthetic */ ShimmerImageView this$0;
                {
                    this.this$0 = shimmerImageView;
                }

                public final void onAnimationUpdate(ValueAnimator it) {
                    Object object = it.getAnimatedValue();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                    }
                    ShimmerImageView.access$setMaskOffsetX$p(this.this$0, ((Integer)object).intValue());
                    this.this$0.invalidate();
                }
            });
            $receiver.start();
        } else {
            this_$iv.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(this_$iv, this){
                final /* synthetic */ ShimmerImageView this$0$inline_fun;
                final /* synthetic */ ShimmerImageView this$0;
                {
                    this.this$0$inline_fun = $outer;
                    this.this$0 = shimmerImageView;
                }

                public boolean onPreDraw() {
                    ValueAnimator valueAnimator;
                    this.this$0$inline_fun.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    int startWidth = this.this$0.getWidth() + (int)((float)this.this$0.getMaskSpecs().getStartDelayed() / (float)this.this$0.getMaskSpecs().getAnimationDuration());
                    ValueAnimator $receiver = valueAnimator = ValueAnimator.ofInt((int[])new int[]{-(startWidth + this.this$0.getWidth()), this.this$0.getWidth()});
                    ShimmerImageView.access$setAnimation$p(this.this$0, $receiver);
                    $receiver.setDuration(this.this$0.getMaskSpecs().getAnimationDuration() + this.this$0.getMaskSpecs().getStartDelayed());
                    $receiver.setRepeatCount(-1);
                    $receiver.setRepeatMode(1);
                    $receiver.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                    $receiver.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
                        final /* synthetic */ startAnimation$$inlined$runAfterLaidOut$1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void onAnimationUpdate(ValueAnimator it) {
                            Object object = it.getAnimatedValue();
                            if (object == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                            }
                            ShimmerImageView.access$setMaskOffsetX$p(this.this$0.this$0, ((Integer)object).intValue());
                            this.this$0.this$0.invalidate();
                        }
                    });
                    $receiver.start();
                    return false;
                }
            });
        }
    }

    private final void runAfterLaidOut(Function0<Unit> block) {
        if (ViewCompat.isLaidOut((View)((View)this))) {
            block.invoke();
        } else {
            this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(this, block){
                final /* synthetic */ ShimmerImageView this$0;
                final /* synthetic */ Function0 $block;

                public boolean onPreDraw() {
                    this.this$0.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    this.$block.invoke();
                    return false;
                }
                {
                    this.this$0 = $outer;
                    this.$block = $captured_local_variable$1;
                }
            });
        }
    }

    public final void stopAnimation() {
        ValueAnimator valueAnimator = this.animation;
        if (valueAnimator != null) {
            valueAnimator.cancel();
        }
        this.animation = null;
    }

    public final boolean isAnimationRunning() {
        return this.animation != null;
    }

    private final void resetAnimation() {
        boolean animationStarted = this.isAnimationRunning();
        this.stopAnimation();
        this.getPaint().setXfermode((Xfermode)new PorterDuffXfermode(this.maskSpecs.getMaskMode()));
        this.maskBitmap = null;
        this.setRenderMaskBitmap(null);
        if (animationStarted) {
            this.startAnimation();
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.resetAnimation();
    }

    public void draw(@Nullable Canvas canvas) {
        super.draw(canvas);
        this.drawMaskUsingBitmap(canvas);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopAnimation();
    }

    private final void drawMaskUsingBitmap(Canvas canvas) {
        block2: {
            Bitmap bitmap;
            if (!this.isAnimationRunning()) {
                return;
            }
            Bitmap bitmap2 = this.tryObtainRenderMaskBitmap();
            if (bitmap2 == null) break block2;
            Bitmap it = bitmap = bitmap2;
            this.drawMaskToBitmap();
            Canvas canvas2 = canvas;
            if (canvas2 != null) {
                canvas2.drawBitmap(it, 0.0f, 0.0f, null);
            }
        }
    }

    private final Bitmap tryObtainRenderMaskBitmap() {
        Bitmap bitmap = this.getRenderMaskBitmap();
        if (bitmap == null) {
            Bitmap bitmap2 = this.createBitmap(this.getWidth(), this.getHeight());
            if (bitmap2 != null) {
                Bitmap bitmap3;
                Bitmap $receiver = bitmap3 = bitmap2;
                this.setRenderMaskBitmap($receiver);
                bitmap = bitmap3;
            } else {
                bitmap = null;
            }
        }
        return bitmap;
    }

    private final void drawMaskToBitmap() {
        block1: {
            Bitmap bitmap;
            Bitmap bitmap2 = this.getMaskBitmap();
            if (bitmap2 == null) break block1;
            Bitmap it = bitmap = bitmap2;
            Canvas canvas = this.maskRenderCanvas;
            if (canvas != null) {
                Canvas canvas2;
                Canvas $receiver = canvas2 = canvas;
                $receiver.save();
                $receiver.clipRect(this.maskOffsetX, 0.0f, this.maskOffsetX + (float)it.getWidth(), (float)it.getHeight());
                super.draw($receiver);
                $receiver.drawBitmap(it, this.maskOffsetX, 0.0f, this.getPaint());
                $receiver.restore();
            }
        }
    }

    private final Bitmap getMaskBitmap() {
        Bitmap bitmap = this.maskBitmap;
        if (bitmap == null) {
            Bitmap bitmap2 = this.createBitmap(this.getWidth(), this.getHeight());
            if (bitmap2 != null) {
                Paint paint2;
                Bitmap bitmap3;
                Bitmap $receiver;
                this.maskBitmap = $receiver = (bitmap3 = bitmap2);
                Canvas canvas = new Canvas($receiver);
                Paint $receiver2 = paint2 = new Paint();
                $receiver2.setShader((Shader)new LinearGradient(this.getWidthFloat(), 0.0f, 0.0f, 0.0f, this.getGradientColors(), this.getGradientPositions(), Shader.TileMode.CLAMP));
                $receiver2.setColorFilter((ColorFilter)new PorterDuffColorFilter(this.maskSpecs.getMaskColor(), PorterDuff.Mode.SRC_IN));
                Paint paint3 = paint2;
                canvas.drawRect(0.0f, 0.0f, this.getWidthFloat(), this.getHeightFloat(), paint3);
                bitmap = bitmap3;
            } else {
                bitmap = null;
            }
        }
        return bitmap;
    }

    private final int[] getGradientColors() {
        return new int[]{0, -16777216, -16777216, 0};
    }

    private final float[] getGradientPositions() {
        return new float[]{Math.max(0.0f, this.maskSpecs.getDropOff()), 0.5f - this.maskSpecs.getIntensity() / 2.0f, 0.5f + this.maskSpecs.getIntensity() / 2.0f, Math.min(1.0f, 1.0f - this.maskSpecs.getDropOff())};
    }

    private final Bitmap createBitmap(int width, int height) {
        try {
            return Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (OutOfMemoryError ome) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public ShimmerImageView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        void initialValue$iv;
        ReadWriteProperty readWriteProperty;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        Delegates delegates = Delegates.INSTANCE;
        Object var5_5 = null;
        ShimmerImageView shimmerImageView = this;
        shimmerImageView.renderMaskBitmap$delegate = readWriteProperty = (ReadWriteProperty)new ObservableProperty<Bitmap>((Object)initialValue$iv, (Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ ShimmerImageView this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = shimmerImageView;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(KProperty property, Object oldValue, Object newValue) {
                Canvas canvas;
                void newValue2;
                Bitmap bitmap = (Bitmap)newValue;
                Bitmap bitmap2 = (Bitmap)oldValue;
                KProperty property2 = property;
                ShimmerImageView shimmerImageView = this.this$0;
                void v1 = newValue2;
                if (v1 != null) {
                    Canvas canvas2;
                    void var7_7 = v1;
                    ShimmerImageView shimmerImageView2 = shimmerImageView;
                    void it = var7_7;
                    Canvas $receiver = canvas2 = new Canvas();
                    $receiver.setBitmap((Bitmap)newValue2);
                    Canvas canvas3 = canvas2;
                    shimmerImageView = shimmerImageView2;
                    canvas = canvas3;
                } else {
                    canvas = null;
                }
                ShimmerImageView.access$setMaskRenderCanvas$p(shimmerImageView, canvas);
            }
        };
        this.paint$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Paint>(this){
            final /* synthetic */ ShimmerImageView this$0;

            @NotNull
            public final Paint invoke() {
                Paint paint2;
                Paint $receiver = paint2 = new Paint();
                $receiver.setAntiAlias(true);
                $receiver.setXfermode((Xfermode)new PorterDuffXfermode(this.this$0.getMaskSpecs().getMaskMode()));
                return paint2;
            }
            {
                this.this$0 = shimmerImageView;
                super(0);
            }
        }));
        this.maskSpecs = new MaskSpecs(0, 0.0f, 0.0f, null, 0L, 0L, 63, null);
    }

    @JvmOverloads
    public /* synthetic */ ShimmerImageView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public ShimmerImageView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ShimmerImageView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ShimmerImageView.class), "renderMaskBitmap", "getRenderMaskBitmap()Landroid/graphics/Bitmap;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ShimmerImageView.class), "paint", "getPaint()Landroid/graphics/Paint;"))};
    }

    @Nullable
    public static final /* synthetic */ ValueAnimator access$getAnimation$p(ShimmerImageView $this) {
        return $this.animation;
    }

    public static final /* synthetic */ float access$getMaskOffsetX$p(ShimmerImageView $this) {
        return $this.maskOffsetX;
    }

    public static final /* synthetic */ void access$setMaskOffsetX$p(ShimmerImageView $this, float f) {
        $this.maskOffsetX = f;
    }

    @Nullable
    public static final /* synthetic */ Canvas access$getMaskRenderCanvas$p(ShimmerImageView $this) {
        return $this.maskRenderCanvas;
    }

    public static final /* synthetic */ void access$setMaskRenderCanvas$p(ShimmerImageView $this, @Nullable Canvas canvas) {
        $this.maskRenderCanvas = canvas;
    }
}

