/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.zip.base;

import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.io.IOUtil;
import com.weicoder.common.zip.base.BaseZip;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class BaseCompressor
extends BaseZip {
    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] compress0(byte[] b) throws Exception {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            block13: {
                OutputStream os = this.os(bos);
                try {
                    IOUtil.write(os, b);
                    os.flush();
                    byArray = bos.toByteArray();
                    if (os == null) break block13;
                }
                catch (Throwable throwable) {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                os.close();
            }
            return byArray;
        }
        catch (Exception e) {
            return ArrayConstants.BYTES_EMPTY;
        }
    }

    @Override
    protected byte[] extract0(byte[] b) throws Exception {
        byte[] byArray;
        block8: {
            InputStream is = this.is(new ByteArrayInputStream(b));
            try {
                byArray = IOUtil.read(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return ArrayConstants.BYTES_EMPTY;
                }
            }
            is.close();
        }
        return byArray;
    }

    protected abstract InputStream is(ByteArrayInputStream var1) throws Exception;

    protected abstract OutputStream os(ByteArrayOutputStream var1) throws Exception;
}

