/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.util;

import com.weicoder.common.U;
import com.weicoder.common.W;
import com.weicoder.common.log.Logs;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.RegexUtil;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static String getFormat(String date) {
        if (RegexUtil.is("^(\\d{4})(0[1-9]|1[0-2])(0[1-9]|1[0-9]|2[0-9]|3[0-1])$", date)) {
            return "yyyyMMdd";
        }
        if (RegexUtil.is("^(\\d{4})\\-(0[1-9]|1[0-2])\\-(0[1-9]|1[0-9]|2[0-9]|3[0-1])$", date)) {
            return "yyyy-MM-dd";
        }
        if (RegexUtil.is("^(\\d{4})\\-(0[1-9]|1[0-2])\\-(0[1-9]|1[0-9]|2[0-9]|3[0-1]) (0[0-9]|1[0-9]|2[0-4]):([0-5][0-9]):([0-5][0-9])$", date)) {
            return "yyyy-MM-dd HH:mm:ss";
        }
        if (RegexUtil.is("^(\\d{4})\\-(0[1-9]|1[0-2])\\-(0[1-9]|1[0-9]|2[0-9]|3[0-1]) (0[0-9]|1[0-9]|2[0-4]):([0-5][0-9])$", date)) {
            return "yyyy-MM-dd HH:mm";
        }
        if (RegexUtil.is("^(\\d{4})(0[1-9]|1[0-2])(0[1-9]|1[0-9]|2[0-9]|3[0-1]) (0[0-9]|1[0-9]|2[0-4]):([0-5][0-9]):([0-5][0-9])$", date)) {
            return "yyyyMMdd HH:mm:ss";
        }
        if (RegexUtil.is("^(0[0-9]|1[0-9]|2[0-4]):([0-5][0-9]):([0-5][0-9])$", date)) {
            return "HH:mm:ss";
        }
        if (RegexUtil.is("^(\\d{4})(0[1-9]|1[0-2])$", date)) {
            return "yyyyMM";
        }
        return null;
    }

    public static String getDate() {
        return DateUtil.getDate(CommonParams.DATE_FORMAT);
    }

    public static String getLongDate() {
        return DateUtil.getDate("yyyy-MM-dd HH:mm:ss");
    }

    public static String getShortDate() {
        return DateUtil.getDate("yyyy-MM-dd");
    }

    public static String getTinyDate() {
        return DateUtil.getDate("yyyyMMdd");
    }

    public static String getTheDate() {
        return DateUtil.getDate("HH:mm:ss");
    }

    public static String getDate(String format) {
        return DateUtil.toString(DateUtil.getCurrentDate(), format);
    }

    public static Date getCurrentDate() {
        return new Date();
    }

    public static int getTime() {
        return W.C.toInt(DateUtil.now() / 1000L);
    }

    public static int getTime(Date date) {
        return U.E.isEmpty(date) ? 0 : W.C.toInt(date.getTime() / 1000L);
    }

    public static int getTime(String date) {
        return DateUtil.getTime(DateUtil.toDate(date));
    }

    public static int getTime(String date, String format) {
        return DateUtil.getTime(DateUtil.toDate(date, format));
    }

    public static int getTime(int time, int number) {
        return DateUtil.getTime(time, number, CommonParams.DATE_FORMAT);
    }

    public static int getTime(int time, int number, String format) {
        return DateUtil.getTime(DateUtil.getDate(time, number, format));
    }

    public static String toString(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static String toString(Date date) {
        return DateUtil.toString(date, CommonParams.DATE_FORMAT);
    }

    public static String toString(long time) {
        return DateUtil.toString(time, CommonParams.DATE_FORMAT);
    }

    public static String toString(long time, String format) {
        return DateUtil.toString(new Date(time), format);
    }

    public static String toString(int time) {
        return DateUtil.toString(time, CommonParams.DATE_FORMAT);
    }

    public static String toString(int time, String format) {
        return DateUtil.toString(W.C.toLong(time) * 1000L, format);
    }

    public static Date toDate(String dateString) {
        return DateUtil.toDate(dateString, DateUtil.getFormat(dateString));
    }

    public static Date toDate(String dateString, String format) {
        try {
            return (U.E.isEmpty(format) ? new SimpleDateFormat() : new SimpleDateFormat(format)).parse(dateString);
        }
        catch (Exception e) {
            Logs.warn(e);
            return null;
        }
    }

    public static int marginDay(String oneDate, String twoDate) {
        return DateUtil.marginDay(oneDate, twoDate, DateUtil.getFormat(oneDate));
    }

    public static int marginDay(String oneDate, String twoDate, String format) {
        return DateUtil.marginDay(DateUtil.toDate(oneDate, format), DateUtil.toDate(twoDate, format));
    }

    public static int marginDay(Date oneDate, Date twoDate) {
        return W.C.toInt((twoDate.getTime() - oneDate.getTime()) / 86400000L);
    }

    public static int marginMonth(String oneDate, String twoDate) {
        return DateUtil.marginMonth(oneDate, twoDate, DateUtil.getFormat(oneDate));
    }

    public static int marginMonth(String oneDate, String twoDate, String format) {
        return DateUtil.marginMonth(DateUtil.toDate(oneDate, format), DateUtil.toDate(twoDate, format));
    }

    public static int marginMonth(Date oneDate, Date twoDate) {
        int oneYear = DateUtil.getYear(oneDate);
        int oneMonth = DateUtil.getMonth(oneDate);
        int twoYear = DateUtil.getYear(twoDate);
        int twoMonth = DateUtil.getMonth(twoDate);
        if (oneMonth == 0) {
            oneMonth = 12;
            --oneYear;
        }
        if (twoMonth == 0) {
            twoMonth = 12;
            --twoYear;
        }
        return (twoYear - oneYear) * 12 + (twoMonth - oneMonth);
    }

    public static int getDayOfWeek() {
        return DateUtil.getDayOfWeek(DateUtil.getCurrentDate());
    }

    public static int getDayOfWeek(String date) {
        return DateUtil.getDayOfWeek(date, DateUtil.getFormat(date));
    }

    public static int getDayOfWeek(String date, String format) {
        return DateUtil.getDayOfWeek(DateUtil.toDate(date, format));
    }

    public static int getDayOfWeek(Date date) {
        return DateUtil.get(date, 7) - 1;
    }

    public static int getDayOfMonth() {
        return DateUtil.getDayOfMonth(DateUtil.getCurrentDate());
    }

    public static int getDayOfMonth(String date) {
        return DateUtil.getDayOfMonth(date, DateUtil.getFormat(date));
    }

    public static int getDayOfMonth(String date, String format) {
        return DateUtil.getDayOfMonth(DateUtil.toDate(date, format));
    }

    public static int getDayOfMonth(Date date) {
        return DateUtil.get(date, 5);
    }

    public static String[] getDayOfWeeks() {
        return DateUtil.getDayOfWeeks(DateUtil.getDate());
    }

    public static String[] getDayOfWeeks(String date) {
        return DateUtil.getDayOfWeeks(date, DateUtil.getFormat(date));
    }

    public static String[] getDayOfWeeks(String date, String format) {
        return DateUtil.getDayOfWeeks(DateUtil.toDate(date, format), format);
    }

    public static String[] getDayOfWeeks(Date date) {
        return DateUtil.getDayOfWeeks(date, CommonParams.DATE_FORMAT);
    }

    public static String[] getDayOfWeeks(Date date, String format) {
        String[] weekInfo = new String[7];
        int week = DateUtil.getDayOfWeek(date);
        for (int i = 1; i < 8; ++i) {
            weekInfo[i - 1] = DateUtil.getDate(date, -(week - i), format);
        }
        return weekInfo;
    }

    public static String[] getDayOfNaturalWeeks(String date) {
        String[] weekInfo = new String[7];
        int week = DateUtil.getDayOfWeek(date);
        week = week == 0 ? 7 : week;
        String format = DateUtil.getFormat(date);
        for (int i = 1; i < 8; ++i) {
            weekInfo[i - 1] = DateUtil.getDate(date, -(week - i), format);
        }
        return weekInfo;
    }

    public static int getWeek() {
        return DateUtil.getWeek(DateUtil.getCurrentDate());
    }

    public static int getWeek(String date) {
        return DateUtil.getWeek(date, DateUtil.getFormat(date));
    }

    public static int getWeek(String date, String format) {
        return DateUtil.getWeek(DateUtil.toDate(date, format));
    }

    public static int getWeek(Date date) {
        return DateUtil.get(date, 3);
    }

    public static int getDayOfYear() {
        return DateUtil.getDayOfYear(DateUtil.getCurrentDate());
    }

    public static int getDayOfYear(String date) {
        return DateUtil.getDayOfYear(date, DateUtil.getFormat(date));
    }

    public static int getDayOfYear(String date, String format) {
        return DateUtil.getDayOfYear(DateUtil.toDate(date, format));
    }

    public static int getDayOfYear(Date date) {
        return DateUtil.get(date, 6);
    }

    public static String getDate(int number) {
        return DateUtil.getDate(number, CommonParams.DATE_FORMAT);
    }

    public static String getDate(int number, String format) {
        return DateUtil.getDate(DateUtil.getCurrentDate(), number, format);
    }

    public static String getDate(int time, int number) {
        return DateUtil.getDate(time, number, CommonParams.DATE_FORMAT);
    }

    public static String getDate(int time, int number, String format) {
        return DateUtil.getDate(DateUtil.toString(time), number, format);
    }

    public static String getDate(String date, int number) {
        return DateUtil.getDate(date, number, DateUtil.getFormat(date));
    }

    public static String getDate(String date, int number, String format) {
        return DateUtil.getDate(DateUtil.toDate(date, format), number, format);
    }

    public static String getDate(Date date, int number) {
        return DateUtil.getDate(date, number, CommonParams.DATE_FORMAT);
    }

    public static String getDate(Date date, int number, String format) {
        return DateUtil.discrepancy(date, number, format, 5);
    }

    public static String getMonth(int number) {
        return DateUtil.getMonth(number, CommonParams.DATE_FORMAT);
    }

    public static String getMonth(int number, String format) {
        return DateUtil.getMonth(DateUtil.getCurrentDate(), number, format);
    }

    public static String getMonth(String date, int number) {
        return DateUtil.getMonth(date, number, CommonParams.DATE_FORMAT);
    }

    public static String getMonth(String date, int number, String format) {
        return DateUtil.getMonth(DateUtil.toDate(date, format), number, format);
    }

    public static String getMonth(Date date, int number) {
        return DateUtil.getMonth(date, number, CommonParams.DATE_FORMAT);
    }

    public static String getMonth(Date date, int number, String format) {
        return DateUtil.discrepancy(date, number, format, 2) + "1";
    }

    public static String[] getMonths() {
        return DateUtil.getMonths(DateUtil.getDate());
    }

    public static String[] getMonths(String date) {
        return DateUtil.getMonths(DateUtil.toDate(date, CommonParams.DATE_FORMAT), CommonParams.DATE_FORMAT);
    }

    public static String[] getMonths(String date, String format) {
        return DateUtil.getMonths(DateUtil.toDate(date, format), format);
    }

    public static String[] getMonths(Date date) {
        return DateUtil.getMonths(date, CommonParams.DATE_FORMAT);
    }

    public static String[] getMonths(Date date, String format) {
        int day = DateUtil.getDay(date);
        int maxDay = DateUtil.getMonthHaveDay(date);
        String[] monthInfo = new String[maxDay];
        for (int i = 1; i <= maxDay; ++i) {
            monthInfo[i - 1] = DateUtil.getDate(date, -(day - i), format);
        }
        return monthInfo;
    }

    public static String getYear(int number) {
        return DateUtil.getYear(number, CommonParams.DATE_FORMAT);
    }

    public static String getYear(int number, String format) {
        return DateUtil.getYear(DateUtil.getCurrentDate(), number, format);
    }

    public static String getYear(String date, int number) {
        return DateUtil.getYear(date, number, CommonParams.DATE_FORMAT);
    }

    public static String getYear(String date, int number, String format) {
        return DateUtil.getYear(DateUtil.toDate(date, format), number, format);
    }

    public static String getYear(Date date, int number) {
        return DateUtil.getYear(date, number, CommonParams.DATE_FORMAT);
    }

    public static String getYear(Date date, int number, String format) {
        return DateUtil.discrepancy(date, number, format, 1);
    }

    public static String format(String src, String srcfmt, String desfmt) {
        return DateUtil.toString(DateUtil.toDate(src, srcfmt), desfmt);
    }

    public static int getYear(Date date) {
        return DateUtil.get(date, 1);
    }

    public static int getMonth(Date date) {
        return DateUtil.get(date, 2) + 1;
    }

    public static int getDay(Date date) {
        return DateUtil.get(date, 5);
    }

    public static int getHour(Date date) {
        return DateUtil.get(date, 10);
    }

    public static int getMinute(Date date) {
        return DateUtil.get(date, 12);
    }

    public static int getSecond(Date date) {
        return DateUtil.get(date, 13);
    }

    public static int getYear() {
        return DateUtil.getYear(DateUtil.getCurrentDate());
    }

    public static int getMonth() {
        return DateUtil.getMonth(DateUtil.getCurrentDate());
    }

    public static int getDay() {
        return DateUtil.getDay(DateUtil.getCurrentDate());
    }

    public static int getHour() {
        return DateUtil.getHour(DateUtil.getCurrentDate());
    }

    public static int getMinute() {
        return DateUtil.getMinute(DateUtil.getCurrentDate());
    }

    public static int getSecond() {
        return DateUtil.getSecond(DateUtil.getCurrentDate());
    }

    public static int getMonthHaveDay() {
        return DateUtil.getMonthHaveDay(0);
    }

    public static int getMonthHaveDay(int month) {
        return LocalDate.now().plusMonths(month).lengthOfMonth();
    }

    public static int getMonthHaveDay(Date date) {
        return DateUtil.getActualMaximum(date, 5);
    }

    public static int getYearHaveDay() {
        return DateUtil.getYearHaveDay(DateUtil.getCurrentDate());
    }

    public static int getYearHaveDay(Date date) {
        return DateUtil.getActualMaximum(date, 6);
    }

    public static long diff(long time) {
        return DateUtil.now() - time;
    }

    public static long dura() {
        long time = DateUtil.now();
        return time - W.C.toLong(U.T.put("time", time), time);
    }

    public static int time() {
        return W.C.toInt(DateUtil.now() / 1000L);
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    public static String secondToTime(int time) {
        StringBuilder timeString = new StringBuilder();
        int hour = 0;
        int minute = 0;
        int second = 0;
        boolean isNegative = false;
        if (time < 0) {
            time *= -1;
            isNegative = true;
        }
        if (time >= 60) {
            minute = time / 60;
            second = time % 60;
            if (minute >= 60) {
                hour = minute / 60;
                minute %= 60;
            }
        } else {
            second = time;
        }
        if (hour < 10) {
            timeString.append("0");
        }
        timeString.append(hour);
        timeString.append(":");
        if (minute < 10) {
            timeString.append("0");
        }
        timeString.append(minute);
        timeString.append(":");
        if (second < 10) {
            timeString.append("0");
        }
        if (isNegative) {
            time *= -1;
            timeString.append("-");
            timeString.append((CharSequence)timeString);
        }
        return timeString.toString();
    }

    private static int get(Date date, int field) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(field);
    }

    private static String discrepancy(Date date, int number, String format, int field) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(field, number);
        return new SimpleDateFormat(format).format(c.getTime());
    }

    private static int getActualMaximum(Date date, int field) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.getActualMaximum(field);
    }
}

