/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.queue;

import com.weicoder.common.U;
import com.weicoder.common.concurrent.ScheduledUtil;
import com.weicoder.common.interfaces.CallbackList;
import com.weicoder.common.lang.Lists;
import com.weicoder.common.log.Log;
import com.weicoder.common.log.LogFactory;
import java.util.Collection;
import java.util.List;
import java.util.Queue;

public class AsynQueueList<E> {
    private static final Log LOG = LogFactory.getLog(AsynQueueList.class);
    private Queue<E> queue;

    public AsynQueueList(Queue<E> queue, CallbackList<E> callback, long time) {
        this.queue = queue;
        ScheduledUtil.delay(() -> {
            if (queue.isEmpty()) {
                return;
            }
            int n = 0;
            long c = System.currentTimeMillis();
            List result = Lists.newList();
            while (U.E.isNotEmpty(queue)) {
                Object e = queue.poll();
                result.add(e);
                LOG.debug("AsynQueueList run i={} obj={}", ++n, e);
            }
            callback.callback(result);
            LOG.info("AsynQueueList run size={} time={}", n, System.currentTimeMillis() - c);
        }, time);
    }

    public boolean add(E e) {
        return this.queue.add(e);
    }

    public boolean addAll(Collection<? extends E> c) {
        return this.queue.addAll(c);
    }
}

