/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.io;

import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.io.BaseIO;
import com.weicoder.common.log.Logs;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.CloseUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class OIO
extends BaseIO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] read(InputStream in, boolean isClose) {
        if (in == null) {
            return ArrayConstants.BYTES_EMPTY;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(CommonParams.IO_BUFFERSIZE * 10);
        try {
            byte[] buffer = new byte[CommonParams.IO_BUFFERSIZE];
            int length = 0;
            while ((length = in.read(buffer)) > 0) {
                out.write(buffer, 0, length);
            }
            if (!isClose) return out.toByteArray();
        }
        catch (IOException e) {
            try {
                Logs.error(e);
                if (!isClose) return out.toByteArray();
            }
            catch (Throwable throwable) {
                if (!isClose) throw throwable;
                CloseUtil.close(in);
                throw throwable;
            }
            CloseUtil.close(in);
            return out.toByteArray();
        }
        CloseUtil.close(in);
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean write(OutputStream out, InputStream in, boolean isClose) {
        boolean bl;
        if (out == null || in == null) {
            return false;
        }
        try {
            byte[] buffer = new byte[CommonParams.IO_BUFFERSIZE];
            int num = 0;
            while ((num = in.read(buffer)) > 0) {
                out.write(buffer, 0, num);
            }
            out.flush();
            bl = true;
            if (!isClose) return bl;
        }
        catch (IOException e) {
            try {
                Logs.error(e);
                if (!isClose) return false;
            }
            catch (Throwable throwable) {
                if (!isClose) throw throwable;
                CloseUtil.close(out, in);
                throw throwable;
            }
            CloseUtil.close(out, in);
            return false;
        }
        CloseUtil.close(out, in);
        return bl;
    }
}

