/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.io;

import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.io.IO;
import com.weicoder.common.io.NIO;
import com.weicoder.common.io.OIO;
import com.weicoder.common.params.CommonParams;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtil {
    private static final IO IO = "io".equalsIgnoreCase(CommonParams.IO_MODE) ? new OIO() : new NIO();

    public static String readString(InputStream in) {
        return in == null ? "" : IO.readString(in);
    }

    public static String readString(InputStream in, String charsetName) {
        return in == null ? "" : IO.readString(in, charsetName);
    }

    public static String readString(InputStream in, String charsetName, boolean isClose) {
        return in == null ? "" : IO.readString(in, charsetName, isClose);
    }

    public static byte[] read(InputStream in) {
        return in == null ? ArrayConstants.BYTES_EMPTY : IO.read(in);
    }

    public static byte[] read(InputStream in, boolean isClose) {
        return in == null ? ArrayConstants.BYTES_EMPTY : IO.read(in, isClose);
    }

    public static boolean write(OutputStream out, String text) {
        return out == null ? false : IO.write(out, text);
    }

    public static boolean write(OutputStream out, String text, String charsetName) {
        return out == null ? false : IO.write(out, text, charsetName);
    }

    public static boolean write(OutputStream out, String text, String charsetName, boolean isClose) {
        return out == null ? false : IO.write(out, text, charsetName, isClose);
    }

    public static boolean write(OutputStream out, byte[] b) {
        return out == null ? false : IO.write(out, b);
    }

    public static boolean write(OutputStream out, byte[] b, boolean isClose) {
        return out == null ? false : IO.write(out, b, isClose);
    }

    public static boolean write(OutputStream out, InputStream in) {
        return out == null ? false : IO.write(out, in);
    }

    public static boolean write(OutputStream out, InputStream in, boolean isClose) {
        return out == null ? false : IO.write(out, in, isClose);
    }
}

