/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.concurrent;

import com.weicoder.common.U;
import com.weicoder.common.concurrent.DaemonThreadFactory;
import com.weicoder.common.concurrent.ExecutorFactory;
import com.weicoder.common.lang.Lists;
import com.weicoder.common.log.Logs;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class ExecutorUtil {
    private static final ExecutorFactory FACTORY = new ExecutorFactory();
    private static final List<Runnable> RUNNABLES = Lists.newList();
    private static final List<Callable<Object>> CALLABLES = Lists.newList();

    public static void newExecute(Runnable command) {
        ExecutorUtil.newSingle().execute(command);
    }

    public static ExecutorService newSingle() {
        return Executors.newSingleThreadExecutor(DaemonThreadFactory.INSTANCE);
    }

    public static ExecutorService newPool(int pool, boolean daemon) {
        return FACTORY.newPool(pool, daemon);
    }

    public static void execute(Runnable command) {
        ExecutorUtil.pool().execute(command);
    }

    public static ExecutorService pool() {
        return ExecutorUtil.pool("");
    }

    public static ExecutorService pool(String name) {
        return (ExecutorService)FACTORY.getInstance(name);
    }

    public static void addR(Runnable task) {
        RUNNABLES.add(task);
    }

    public static void addC(Callable<Object> task) {
        CALLABLES.add(task);
    }

    public static void execute() {
        List<Runnable> tasks = Lists.newList(RUNNABLES);
        RUNNABLES.clear();
        ExecutorUtil.execute(tasks);
    }

    public static List<Object> submit() {
        List calls = Lists.newList(CALLABLES);
        CALLABLES.clear();
        return ExecutorUtil.submit(calls);
    }

    public static void execute(List<Runnable> tasks) {
        List list = Lists.newList(tasks.size());
        tasks.forEach(task -> list.add(ExecutorUtil.pool().submit((Runnable)task)));
        while (ExecutorUtil.pool().isTerminated()) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                if (!((Future)it.next()).isDone()) continue;
                it.remove();
            }
            if (!U.E.isEmpty(list)) continue;
            break;
        }
    }

    public static <T> List<T> submit(List<Callable<T>> tasks) {
        return ExecutorUtil.submit(tasks, 0L);
    }

    public static <T> List<T> submit(List<Callable<T>> tasks, long timeout) {
        int len = tasks.size();
        List list = Lists.newList(len);
        List ls = Lists.newList(len);
        tasks.forEach(task -> list.add(ExecutorUtil.pool().submit(task)));
        list.forEach(f -> {
            try {
                if (timeout > 0L) {
                    ls.add(f.get(timeout, TimeUnit.MILLISECONDS));
                } else {
                    ls.add(f.get());
                }
            }
            catch (Exception e) {
                Logs.warn(e);
            }
        });
        return ls;
    }
}

