/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.binary;

import com.weicoder.common.U;
import com.weicoder.common.binary.ByteArray;
import com.weicoder.common.lang.Bytes;
import com.weicoder.common.params.CommonParams;
import com.weicoder.common.util.StringUtil;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class Buffer
implements ByteArray {
    private byte[] data;
    private int top;
    private int offset;
    private boolean sync;
    private Lock lock;

    public Buffer() {
        this(false);
    }

    public Buffer(boolean sync) {
        this(CommonParams.IO_BUFFERSIZE, sync);
    }

    public Buffer(int capacity, boolean sync) {
        this(new byte[capacity], 0, 0, sync);
    }

    public Buffer(byte[] data) {
        this(data, false);
    }

    public Buffer(byte[] data, boolean sync) {
        this(data, 0, data.length, sync);
    }

    public Buffer(byte[] data, int index, int length, boolean sync) {
        this.data = data;
        this.top = index + length;
        this.offset = index;
        this.sync = sync;
        if (sync) {
            this.lock = new ReentrantLock(true);
        }
    }

    public void capacity(int len) {
        if (len <= this.data.length) {
            return;
        }
        if (this.sync) {
            this.lock.lock();
        }
        byte[] temp = new byte[len < CommonParams.IO_BUFFERSIZE ? CommonParams.IO_BUFFERSIZE : len];
        System.arraycopy(this.data, 0, temp, 0, this.top);
        this.data = temp;
        if (this.sync) {
            this.lock.unlock();
        }
    }

    public int top() {
        return this.top;
    }

    public void top(int top) {
        if (top < this.offset) {
            return;
        }
        if (top > this.length()) {
            this.capacity(top);
        }
        this.top = top;
    }

    public int offset() {
        return this.offset;
    }

    public void offset(int offset) {
        if (offset < 0 || offset > this.top) {
            return;
        }
        this.offset = offset;
    }

    public int remaining() {
        return this.top - this.offset;
    }

    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    public int length() {
        return this.data.length;
    }

    public byte[] read(int len) {
        return this.read(new byte[len]);
    }

    public byte[] read(byte[] data) {
        return this.read(data, 0, data.length);
    }

    public byte[] read(byte[] data, int pos, int len) {
        if (this.sync) {
            this.lock.lock();
        }
        System.arraycopy(this.data, this.offset, data, pos, len);
        this.offset += len;
        if (this.sync) {
            this.lock.unlock();
        }
        return data;
    }

    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public byte readByte() {
        return this.read(1)[0];
    }

    public char readChar() {
        return (char)this.readShort();
    }

    public short readShort() {
        return Bytes.toShort(this.read(2));
    }

    public int readInt() {
        return Bytes.toInt(this.read(4));
    }

    public float readFloat() {
        return Bytes.toFloat(this.read(4));
    }

    public long readLong() {
        return Bytes.toLong(this.read(8));
    }

    public double readDouble() {
        return Bytes.toDouble(this.read(8));
    }

    public String readString(int len) {
        return len == 0 ? "" : new String(this.read(new byte[len], 0, len));
    }

    public String readString() {
        return this.readString(this.readShort());
    }

    public byte[] write(byte[] data) {
        return this.write(data, 0, data.length);
    }

    public byte[] write(byte[] data, int pos, int len) {
        if (data.length < this.top + len) {
            this.capacity(this.top + len);
        }
        if (this.sync) {
            this.lock.lock();
        }
        System.arraycopy(data, pos, this.data, this.top, len);
        this.top += len;
        if (this.sync) {
            this.lock.unlock();
        }
        return data;
    }

    public void writeBoolean(boolean b) {
        this.writeByte((byte)(b ? 1 : 0));
    }

    public void writeByte(byte b) {
        this.write(new byte[]{b});
    }

    public void writeChar(char c) {
        this.write(Bytes.toBytes(c), 0, 2);
    }

    public void writeShort(int i) {
        this.writeShort((short)i);
    }

    public void writeShort(short s) {
        this.writeShort(s, 0);
    }

    public void writeShort(short s, int pos) {
        this.write(Bytes.toBytes(s), pos, pos + 2);
    }

    public void writeInt(int i) {
        this.writeInt(i, 0);
    }

    public void writeInt(int i, int pos) {
        this.write(Bytes.toBytes(i), pos, pos + 4);
    }

    public void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeLong(long l) {
        this.writeLong(l, 0);
    }

    public void writeLong(long l, int pos) {
        this.write(Bytes.toBytes(l), pos, pos + 8);
    }

    public void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeString(String s) {
        if (U.E.isEmpty(s)) {
            this.writeShort(0);
        } else {
            byte[] temp = StringUtil.toBytes(s);
            this.writeShort(temp.length);
            this.write(temp, 0, temp.length);
        }
    }

    public void compact() {
        if (this.offset > 0) {
            if (this.sync) {
                this.lock.lock();
            }
            System.arraycopy(this.data, this.offset, this.data, 0, this.remaining());
            this.top -= this.offset;
            this.offset = 0;
            if (this.sync) {
                this.lock.unlock();
            }
        }
    }

    @Override
    public byte[] array() {
        return Bytes.copy(this.data, 0, this.top);
    }

    public void clear() {
        if (this.length() < CommonParams.IO_BUFFERSIZE) {
            this.data = new byte[CommonParams.IO_BUFFERSIZE];
        }
        this.top = 0;
        this.offset = 0;
    }

    @Override
    public ByteArray array(byte[] b) {
        this.clear();
        this.write(b);
        return this;
    }

    public String toString() {
        return StringUtil.add("(top=", this.top, ",offset=", this.offset, ",len=" + this.length() + ")");
    }
}

