/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.common.bean;

import com.weicoder.common.bean.PageResult;
import com.weicoder.common.params.CommonParams;
import java.util.List;

public final class Pages {
    private int total;
    private int page;
    private int size = CommonParams.PAGE_SIZE;

    public PageResult result(List<?> list) {
        return new PageResult(list, this);
    }

    public int getTotalPage() {
        return this.total < this.size ? 0 : (this.total % this.size == 0 ? this.total / this.size : this.total / this.size + 1);
    }

    public int getStartPage() {
        return this.page - 5 > 0 ? this.page - 5 : 0;
    }

    public int getEndPage() {
        int current = this.getPage();
        int total = this.getTotalPage();
        return current == 1 || current < 6 ? (total > 10 ? 10 : total) : (current + 5 <= total ? current + 5 : total);
    }

    public int getEnd() {
        return (this.getPage() + 1) * this.getSize();
    }

    public int getStart() {
        return this.getPage() * this.getSize();
    }

    public int getTotal() {
        return this.total;
    }

    public int getPage() {
        return this.page;
    }

    public int getSize() {
        return this.size;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pages)) {
            return false;
        }
        Pages other = (Pages)o;
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        return this.getSize() == other.getSize();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotal();
        result = result * 59 + this.getPage();
        result = result * 59 + this.getSize();
        return result;
    }

    public String toString() {
        return "Pages(total=" + this.getTotal() + ", page=" + this.getPage() + ", size=" + this.getSize() + ")";
    }
}

