/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.yar;

import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.protocol.yar.YarProtocolUtil;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.transport.ProviderMessageRouter;
import com.weibo.yar.YarRequest;
import com.weibo.yar.YarResponse;
import java.util.concurrent.ConcurrentHashMap;

public class YarMessageRouter
extends ProviderMessageRouter {
    protected ConcurrentHashMap<String, Provider<?>> providerMap = new ConcurrentHashMap();

    public YarMessageRouter() {
    }

    public YarMessageRouter(URL url) {
        super(url);
    }

    public Object handle(Channel channel, Object message) {
        YarRequest yarRequest = (YarRequest)message;
        String packagerName = yarRequest.getPackagerName();
        Provider<?> provider = this.providerMap.get(yarRequest.getRequestPath());
        if (provider == null) {
            throw new MotanServiceException("can not find service provider. request path:" + yarRequest.getRequestPath());
        }
        Class clazz = provider.getInterface();
        Request request = YarProtocolUtil.convert(yarRequest, clazz);
        Response response = this.call(request, provider);
        YarResponse yarResponse = YarProtocolUtil.convert(response, packagerName);
        return yarResponse;
    }

    public void addProvider(Provider<?> provider) {
        String path = YarProtocolUtil.getYarPath(provider.getInterface(), provider.getUrl());
        Provider<?> old = this.providerMap.putIfAbsent(path, provider);
        if (old != null) {
            throw new MotanFrameworkException("duplicate yar provider");
        }
    }

    public void removeProvider(Provider<?> provider) {
        String path = YarProtocolUtil.getYarPath(provider.getInterface(), provider.getUrl());
        this.providerMap.remove(path);
    }
}

