/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.netty4.yar;

import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.protocol.yar.AttachmentRequest;
import com.weibo.api.motan.protocol.yar.YarMessageRouter;
import com.weibo.api.motan.protocol.yar.YarProtocolUtil;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.transport.MessageHandler;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.yar.YarProtocol;
import com.weibo.yar.YarResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class YarMessageHandlerWarpper
implements MessageHandler {
    private YarMessageRouter orgHandler;

    public YarMessageHandlerWarpper(MessageHandler orgHandler) {
        if (orgHandler == null) {
            throw new MotanFrameworkException("messageHandler is null!");
        }
        if (!(orgHandler instanceof YarMessageRouter)) {
            throw new MotanFrameworkException("YarMessageHandlerWarper can not wrapper " + orgHandler.getClass().getSimpleName());
        }
        this.orgHandler = (YarMessageRouter)orgHandler;
    }

    public Object handle(Channel channel, Object message) {
        byte[] responseBytes;
        FullHttpRequest httpRequest = (FullHttpRequest)message;
        String uri = httpRequest.getUri();
        int index = uri.indexOf("?");
        String requestPath = uri;
        Map<String, String> attachments = null;
        if (index > -1) {
            requestPath = uri.substring(0, index);
            if (index != uri.length() - 1) {
                attachments = this.getAttachMents(uri.substring(index + 1, uri.length()));
            }
        }
        YarResponse yarResponse = null;
        String packagerName = "JSON";
        try {
            ByteBuf buf = httpRequest.content();
            byte[] contentBytes = new byte[buf.readableBytes()];
            buf.getBytes(0, contentBytes);
            AttachmentRequest yarRequest = new AttachmentRequest(YarProtocol.buildRequest((byte[])contentBytes), attachments);
            yarRequest.setRequestPath(requestPath);
            yarResponse = (YarResponse)this.orgHandler.handle(channel, (Object)yarRequest);
        }
        catch (Exception e) {
            LoggerUtil.error((String)"YarMessageHandlerWarpper handle yar request fail.", (Throwable)e);
            yarResponse = YarProtocolUtil.buildDefaultErrorResponse(e.getMessage(), packagerName);
        }
        try {
            responseBytes = YarProtocol.toProtocolBytes((YarResponse)yarResponse);
        }
        catch (IOException e) {
            throw new MotanFrameworkException("convert yar response to bytes fail.", (Throwable)e);
        }
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])responseBytes));
        httpResponse.headers().set("Content-Type", (Object)"application/x-www-form-urlencoded");
        httpResponse.headers().set("Content-Length", (Object)httpResponse.content().readableBytes());
        if (HttpHeaders.isKeepAlive((HttpMessage)httpRequest)) {
            httpResponse.headers().set("Connection", (Object)"keep-alive");
        } else {
            httpResponse.headers().set("Connection", (Object)"close");
        }
        return httpResponse;
    }

    private Map<String, String> getAttachMents(String params) {
        String[] paramArray;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : paramArray = params.split("&")) {
            String[] kv = param.split("=");
            if (kv.length == 2) {
                map.put(kv[0], kv[1]);
                continue;
            }
            LoggerUtil.warn((String)("yar attachment parse fail. uri param:" + param));
        }
        return map;
    }
}

