/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.restful.support;

import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.StringTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.util.Base64;

public class RestfulUtil {
    public static final String ATTACHMENT_HEADER = "X-Attach";
    public static final String EXCEPTION_HEADER = "X-Exception";

    public static boolean isRpcRequest(MultivaluedMap<String, String> headers) {
        return headers != null && headers.containsKey((Object)ATTACHMENT_HEADER);
    }

    public static void encodeAttachments(MultivaluedMap<String, Object> headers, Map<String, String> attachments) {
        if (attachments == null || attachments.isEmpty()) {
            return;
        }
        StringBuilder value = new StringBuilder();
        for (Map.Entry<String, String> entry : attachments.entrySet()) {
            value.append(StringTools.urlEncode((String)entry.getKey())).append("=").append(StringTools.urlEncode((String)entry.getValue())).append(";");
        }
        if (value.length() > 1) {
            value.deleteCharAt(value.length() - 1);
        }
        headers.add((Object)ATTACHMENT_HEADER, (Object)value.toString());
    }

    public static Map<String, String> decodeAttachments(MultivaluedMap<String, String> headers) {
        String value = (String)headers.getFirst((Object)ATTACHMENT_HEADER);
        Map<String, String> result = Collections.emptyMap();
        if (value != null && !value.isEmpty()) {
            result = new HashMap<String, String>();
            for (String kv : value.split(";")) {
                String[] pair = kv.split("=");
                if (pair.length != 2) continue;
                result.put(StringTools.urlDecode((String)pair[0]), StringTools.urlDecode((String)pair[1]));
            }
        }
        return result;
    }

    public static Response serializeError(Exception ex) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(ex);
            oos.flush();
            String info = new String(Base64.encodeBytesToBytes((byte[])baos.toByteArray()), "utf-8");
            return Response.status((Response.Status)Response.Status.EXPECTATION_FAILED).header(EXCEPTION_HEADER, ex.getClass()).entity((Object)info).build();
        }
        catch (IOException e) {
            LoggerUtil.error((String)("serialize " + ex.getClass() + " error"), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("serialization " + ex.getClass() + " error")).build();
        }
    }

    public static Exception getCause(BuiltResponse resp) {
        if (resp == null || resp.getStatus() != Response.Status.EXPECTATION_FAILED.getStatusCode()) {
            return null;
        }
        String exceptionClass = resp.getHeaderString(EXCEPTION_HEADER);
        if (!StringUtils.isBlank((CharSequence)exceptionClass)) {
            String body = (String)resp.readEntity(String.class);
            resp.close();
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode((byte[])body.getBytes("utf-8")));
                ObjectInputStream ois = new ObjectInputStream(bais);
                return (Exception)ois.readObject();
            }
            catch (Exception e) {
                LoggerUtil.error((String)("deserialize " + exceptionClass + " error"), (Throwable)e);
            }
        }
        return null;
    }
}

