/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.restful;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.protocol.AbstractProtocol;
import com.weibo.api.motan.protocol.restful.EndpointFactory;
import com.weibo.api.motan.protocol.restful.RestServer;
import com.weibo.api.motan.protocol.restful.support.ProviderResource;
import com.weibo.api.motan.protocol.restful.support.RestfulClientResponse;
import com.weibo.api.motan.protocol.restful.support.RestfulUtil;
import com.weibo.api.motan.protocol.restful.support.proxy.RestfulClientInvoker;
import com.weibo.api.motan.protocol.restful.support.proxy.RestfulProxyBuilder;
import com.weibo.api.motan.rpc.AbstractExporter;
import com.weibo.api.motan.rpc.AbstractReferer;
import com.weibo.api.motan.rpc.Exporter;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import com.weibo.api.motan.util.ReflectUtil;
import java.lang.reflect.Method;
import java.util.Map;
import javax.ws.rs.client.WebTarget;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;

@SpiMeta(name="restful")
public class RestfulProtocol
extends AbstractProtocol {
    protected <T> Exporter<T> createExporter(Provider<T> provider, URL url) {
        return new RestfulExporter<T>(provider, url);
    }

    protected <T> Referer<T> createReferer(Class<T> clz, URL url, URL serviceUrl) {
        return new RestfulReferer<T>(clz, serviceUrl);
    }

    private static class RestfulReferer<T>
    extends AbstractReferer<T> {
        private ResteasyWebTarget target;
        private EndpointFactory endpointFactory;
        private Map<Method, RestfulClientInvoker> delegate;

        public RestfulReferer(Class<T> clz, URL url) {
            super(clz, url);
            this.endpointFactory = (EndpointFactory)ExtensionLoader.getExtensionLoader(EndpointFactory.class).getExtension(url.getParameter(URLParamType.endpointFactory.getName(), URLParamType.endpointFactory.getValue()));
            this.target = this.endpointFactory.createClient(url);
        }

        public void destroy() {
            this.endpointFactory.safeReleaseResource(this.target, this.url);
            LoggerUtil.info((String)("RestfulReferer destory client: url={}" + this.url));
        }

        protected Response doCall(Request request) {
            RestfulClientResponse response = new RestfulClientResponse(request.getRequestId());
            try {
                Method method = this.getInterface().getMethod(request.getMethodName(), ReflectUtil.forNames((String)request.getParamtersDesc()));
                Object value = this.delegate.get(method).invoke(request.getArguments(), request, response);
                response.setValue(value);
            }
            catch (Exception e) {
                Exception cause = RestfulUtil.getCause(response.getHttpResponse());
                response.setException(cause != null ? cause : e);
            }
            return response;
        }

        protected boolean doInit() {
            this.delegate = RestfulProxyBuilder.builder(this.getInterface(), (WebTarget)this.target).build();
            return true;
        }
    }

    private class RestfulExporter<T>
    extends AbstractExporter<T> {
        private RestServer server;
        private EndpointFactory endpointFactory;

        public RestfulExporter(Provider<T> provider, URL url) {
            super(provider, url);
            this.endpointFactory = (EndpointFactory)ExtensionLoader.getExtensionLoader(EndpointFactory.class).getExtension(url.getParameter(URLParamType.endpointFactory.getName(), URLParamType.endpointFactory.getValue()));
            this.server = this.endpointFactory.createServer(url);
        }

        public void unexport() {
            this.server.getDeployment().getRegistry().removeRegistrations(this.provider.getInterface());
            String protocolKey = MotanFrameworkUtil.getProtocolKey((URL)this.url);
            Exporter exporter = (Exporter)RestfulProtocol.this.exporterMap.remove(protocolKey);
            if (exporter != null) {
                exporter.destroy();
            }
            LoggerUtil.info((String)"RestfulExporter unexport Success: url={}", (Object[])new Object[]{this.url});
        }

        public void destroy() {
            this.endpointFactory.safeReleaseResource(this.server, this.url);
            LoggerUtil.info((String)"RestfulExporter destory Success: url={}", (Object[])new Object[]{this.url});
        }

        protected boolean doInit() {
            this.server.getDeployment().getRegistry().addResourceFactory(new ProviderResource(this.provider));
            return true;
        }
    }
}

