/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.restful.support.proxy;

import com.weibo.api.motan.protocol.restful.support.proxy.RestfulClientInvoker;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.client.jaxrs.ProxyConfig;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.util.IsHttpMethod;

public class RestfulProxyBuilder<T> {
    private final Class<T> iface;
    private final ResteasyWebTarget webTarget;
    private ClassLoader loader = Thread.currentThread().getContextClassLoader();
    private MediaType serverConsumes;
    private MediaType serverProduces;

    public static <T> RestfulProxyBuilder<T> builder(Class<T> iface, WebTarget webTarget) {
        return new RestfulProxyBuilder<T>(iface, (ResteasyWebTarget)webTarget);
    }

    public static Map<Method, RestfulClientInvoker> proxy(Class<?> iface, WebTarget base, ProxyConfig config) {
        Path path;
        if (iface.isAnnotationPresent(Path.class) && !(path = iface.getAnnotation(Path.class)).value().equals("") && !path.value().equals("/")) {
            base = base.path(path.value());
        }
        HashMap<Method, RestfulClientInvoker> methodMap = new HashMap<Method, RestfulClientInvoker>();
        for (Method method : iface.getMethods()) {
            RestfulClientInvoker invoker = RestfulProxyBuilder.createClientInvoker(iface, method, (ResteasyWebTarget)base, config);
            methodMap.put(method, invoker);
        }
        return methodMap;
    }

    private static <T> RestfulClientInvoker createClientInvoker(Class<T> clazz, Method method, ResteasyWebTarget base, ProxyConfig config) {
        Set httpMethods = IsHttpMethod.getHttpMethods((Method)method);
        if (httpMethods == null || httpMethods.size() != 1) {
            throw new RuntimeException("You must use at least one, but no more than one http method annotation on: " + method.toString());
        }
        RestfulClientInvoker invoker = new RestfulClientInvoker(base, clazz, method, config);
        invoker.setHttpMethod((String)httpMethods.iterator().next());
        return invoker;
    }

    private RestfulProxyBuilder(Class<T> iface, ResteasyWebTarget webTarget) {
        this.iface = iface;
        this.webTarget = webTarget;
    }

    public RestfulProxyBuilder<T> classloader(ClassLoader cl) {
        this.loader = cl;
        return this;
    }

    public RestfulProxyBuilder<T> defaultProduces(MediaType type) {
        this.serverProduces = type;
        return this;
    }

    public RestfulProxyBuilder<T> defaultConsumes(MediaType type) {
        this.serverConsumes = type;
        return this;
    }

    public RestfulProxyBuilder<T> defaultProduces(String type) {
        this.serverProduces = MediaType.valueOf((String)type);
        return this;
    }

    public RestfulProxyBuilder<T> defaultConsumes(String type) {
        this.serverConsumes = MediaType.valueOf((String)type);
        return this;
    }

    public Map<Method, RestfulClientInvoker> build() {
        return RestfulProxyBuilder.proxy(this.iface, (WebTarget)this.webTarget, new ProxyConfig(this.loader, this.serverConsumes, this.serverProduces));
    }
}

