/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.grpc.http;

import com.weibo.api.motan.protocol.grpc.http.NettyHttpRequestHandler;
import io.grpc.netty.ProtocolNegotiator;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.AsciiString;

public class HttpProtocolNegotiator
implements ProtocolNegotiator {
    NettyHttpRequestHandler httpHandler;

    public HttpProtocolNegotiator(NettyHttpRequestHandler httpHandler) {
        this.httpHandler = httpHandler;
    }

    public ProtocolNegotiator.Handler newHandler(Http2ConnectionHandler handler) {
        return new HttpAdapter(handler);
    }

    class Http2Validator
    extends HttpRequestDecoder {
        private static final String HTTP2 = "HTTP/2.0";
        private boolean isHttp2 = false;

        Http2Validator() {
        }

        protected HttpMessage createMessage(String[] initialLine) throws Exception {
            if (HTTP2.equals(initialLine[2])) {
                this.isHttp2 = true;
            }
            return super.createMessage(initialLine);
        }

        public boolean isHttp2() {
            return this.isHttp2;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            try {
                super.channelRead(ctx, msg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class HttpAdapter
    extends ChannelInboundHandlerAdapter
    implements ProtocolNegotiator.Handler {
        private Http2ConnectionHandler handler;
        private int maxContentLength = 0x4000000;

        public HttpAdapter(Http2ConnectionHandler handler) {
            this.handler = handler;
        }

        public AsciiString scheme() {
            return AsciiString.of((CharSequence)"http");
        }

        public int getMaxContentLength() {
            return this.maxContentLength;
        }

        public void setMaxContentLength(int maxContentLength) {
            this.maxContentLength = maxContentLength;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            ByteBuf bf = ((ByteBuf)msg).copy();
            Http2Validator validator = new Http2Validator();
            validator.channelRead(null, bf);
            if (validator.isHttp2()) {
                ctx.pipeline().replace((ChannelHandler)this, null, (ChannelHandler)this.handler);
            } else {
                ctx.pipeline().addLast("http-decoder", (ChannelHandler)new HttpRequestDecoder());
                ctx.pipeline().addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator(this.maxContentLength));
                ctx.pipeline().addLast("http-encoder", (ChannelHandler)new HttpResponseEncoder());
                ctx.pipeline().addLast("http-chunked", (ChannelHandler)new ChunkedWriteHandler());
                ctx.pipeline().addLast("serverHandler", (ChannelHandler)HttpProtocolNegotiator.this.httpHandler);
            }
            ctx.fireChannelRead(msg);
        }
    }
}

