/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.grpc;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.DefaultThreadFactory;
import com.weibo.api.motan.core.StandardThreadExecutor;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.protocol.AbstractProtocol;
import com.weibo.api.motan.protocol.grpc.GrpcClient;
import com.weibo.api.motan.protocol.grpc.GrpcServer;
import com.weibo.api.motan.rpc.AbstractExporter;
import com.weibo.api.motan.rpc.AbstractReferer;
import com.weibo.api.motan.rpc.Exporter;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;

@SpiMeta(name="grpc")
public class GrpcProtocol
extends AbstractProtocol {
    protected ConcurrentHashMap<String, GrpcServer> serverMap = new ConcurrentHashMap();

    protected <T> Exporter<T> createExporter(Provider<T> provider, URL url) {
        String ipPort = url.getServerPortStr();
        GrpcServer server = this.serverMap.get(ipPort);
        if (server == null) {
            boolean shareChannel = url.getBooleanParameter(URLParamType.shareChannel.getName(), URLParamType.shareChannel.getBooleanValue());
            int workerQueueSize = url.getIntParameter(URLParamType.workerQueueSize.getName(), URLParamType.workerQueueSize.getIntValue());
            int minWorkerThread = 0;
            int maxWorkerThread = 0;
            if (shareChannel) {
                minWorkerThread = url.getIntParameter(URLParamType.minWorkerThread.getName(), 40);
                maxWorkerThread = url.getIntParameter(URLParamType.maxWorkerThread.getName(), 800);
            } else {
                minWorkerThread = url.getIntParameter(URLParamType.minWorkerThread.getName(), 20);
                maxWorkerThread = url.getIntParameter(URLParamType.maxWorkerThread.getName(), 200);
            }
            StandardThreadExecutor executor = new StandardThreadExecutor(minWorkerThread, maxWorkerThread, workerQueueSize, (ThreadFactory)new DefaultThreadFactory("GrpcServer-" + url.getServerPortStr(), true));
            server = new GrpcServer(url.getPort(), shareChannel, (ExecutorService)executor);
            this.serverMap.putIfAbsent(ipPort, server);
            server = this.serverMap.get(ipPort);
        }
        return new GrpcExporter<T>(provider, url, server);
    }

    protected <T> Referer<T> createReferer(Class<T> clz, URL url, URL serviceUrl) {
        return new GrpcReferer<T>(clz, url, serviceUrl);
    }

    class GrpcReferer<T>
    extends AbstractReferer<T> {
        private GrpcClient client;

        public GrpcReferer(Class<T> clz, URL url, URL serviceUrl) {
            super(clz, url, serviceUrl);
            this.client = new GrpcClient(url, clz);
        }

        public void destroy() {
            this.client.destroy();
            LoggerUtil.info((String)"GrpcReferer destory Success: url={}", (Object[])new Object[]{this.url});
        }

        protected Response doCall(Request request) {
            return this.client.request(request);
        }

        protected boolean doInit() {
            try {
                this.client.init();
                return true;
            }
            catch (Exception e) {
                LoggerUtil.error((String)"grpc client init fail!", (Throwable)e);
                return false;
            }
        }
    }

    class GrpcExporter<T>
    extends AbstractExporter<T> {
        private GrpcServer server;

        public GrpcExporter(Provider<T> provider, URL url, GrpcServer server) {
            super(provider, url);
            this.server = server;
        }

        public void unexport() {
            String protocolKey = MotanFrameworkUtil.getProtocolKey((URL)this.url);
            Exporter exporter = (Exporter)GrpcProtocol.this.exporterMap.remove(protocolKey);
            if (exporter != null) {
                exporter.destroy();
            }
            LoggerUtil.info((String)"GrpcExporter unexport Success: url={}", (Object[])new Object[]{this.url});
        }

        public void destroy() {
            this.server.safeRelease(this.url);
            LoggerUtil.info((String)"GrpcExporter destory Success: url={}", (Object[])new Object[]{this.url});
        }

        protected boolean doInit() {
            try {
                this.server.init();
                this.server.addExporter((Exporter<?>)this);
                return true;
            }
            catch (Exception e) {
                LoggerUtil.error((String)"grpc server init fail!", (Throwable)e);
                return false;
            }
        }
    }
}

