/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.grpc;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.protocol.grpc.GrpcResponseFuture;
import com.weibo.api.motan.protocol.grpc.GrpcUtil;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.ForwardingClientCall;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcClient {
    private URL url;
    private Class<?> interfaceClazz;
    private ManagedChannel channel;
    private CallOptions callOption = CallOptions.DEFAULT;
    private HashMap<String, MethodDescriptor> methodDescMap;

    public GrpcClient(URL url, Class<?> interfaceClazz) {
        this.url = url;
        this.interfaceClazz = interfaceClazz;
    }

    public <ReqT, RespT> Response request(final Request request) {
        MethodDescriptor methodDesc = this.methodDescMap.get(request.getMethodName());
        if (methodDesc == null) {
            throw new MotanServiceException("request method grpc descriptornot found.method:" + request.getMethodName());
        }
        int timeout = this.url.getMethodParameter(request.getMethodName(), request.getParamtersDesc(), URLParamType.requestTimeout.getName(), URLParamType.requestTimeout.getIntValue());
        if (timeout < 0) {
            throw new MotanServiceException("request timeout invalid.method timeout:" + timeout);
        }
        ForwardingClientCall.SimpleForwardingClientCall call = new ForwardingClientCall.SimpleForwardingClientCall(this.channel.newCall(methodDesc, this.callOption.withDeadlineAfter((long)timeout, TimeUnit.MILLISECONDS))){

            public void start(ClientCall.Listener responseListener, Metadata headers) {
                Map attachments = request.getAttachments();
                if (attachments != null && !attachments.isEmpty()) {
                    for (Map.Entry entry : attachments.entrySet()) {
                        headers.put(Metadata.Key.of((String)((String)entry.getKey()), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), entry.getValue());
                    }
                }
                super.start(responseListener, headers);
            }
        };
        GrpcResponseFuture responseFuture = new GrpcResponseFuture(request, timeout, this.url, call);
        MethodDescriptor.MethodType methodType = methodDesc.getType();
        switch (methodType) {
            case UNARY: {
                ClientCalls.asyncUnaryCall((ClientCall)call, (Object)request.getArguments()[0], responseFuture);
                break;
            }
            case SERVER_STREAMING: {
                ClientCalls.asyncServerStreamingCall((ClientCall)call, (Object)request.getArguments()[0], (StreamObserver)((StreamObserver)request.getArguments()[1]));
                responseFuture.onCompleted();
                break;
            }
            case CLIENT_STREAMING: {
                StreamObserver clientObserver = ClientCalls.asyncClientStreamingCall((ClientCall)call, (StreamObserver)((StreamObserver)request.getArguments()[0]));
                responseFuture.onNext(clientObserver);
                responseFuture.onCompleted();
                break;
            }
            case BIDI_STREAMING: {
                StreamObserver biObserver = ClientCalls.asyncBidiStreamingCall((ClientCall)call, (StreamObserver)((StreamObserver)request.getArguments()[0]));
                responseFuture.onNext(biObserver);
                responseFuture.onCompleted();
                break;
            }
            default: {
                throw new MotanServiceException("unknown grpc method type:" + methodType);
            }
        }
        return responseFuture;
    }

    public boolean init() throws Exception {
        this.methodDescMap = GrpcUtil.getMethodDescriptorByAnnotation(this.interfaceClazz, this.url.getParameter(URLParamType.serialize.getName()));
        this.channel = ManagedChannelBuilder.forAddress((String)this.url.getHost(), (int)this.url.getPort()).usePlaintext(true).build();
        return true;
    }

    public void destroy() {
        this.channel.shutdownNow();
    }
}

