/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.grpc;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.protocol.grpc.GrpcUtil;
import com.weibo.api.motan.protocol.grpc.MotanHandlerRegistry;
import com.weibo.api.motan.protocol.grpc.http.HttpProtocolNegotiator;
import com.weibo.api.motan.protocol.grpc.http.NettyHttpRequestHandler;
import com.weibo.api.motan.rpc.Exporter;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.URL;
import io.grpc.HandlerRegistry;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerServiceDefinition;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.ProtocolNegotiator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public class GrpcServer {
    private int port;
    private MotanHandlerRegistry registry;
    private Server server;
    private Map<URL, ServerServiceDefinition> serviceDefinetions;
    private boolean init;
    private boolean shareChannel;
    private ExecutorService executor;
    private NettyHttpRequestHandler httpHandler;

    public GrpcServer(int port) {
        this.port = port;
    }

    public GrpcServer(int port, boolean shareChannel) {
        this.port = port;
        this.shareChannel = shareChannel;
    }

    public GrpcServer(int port, boolean shareChannel, ExecutorService executor) {
        this.port = port;
        this.shareChannel = shareChannel;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        if (!this.init) {
            GrpcServer grpcServer = this;
            synchronized (grpcServer) {
                if (!this.init) {
                    this.registry = new MotanHandlerRegistry();
                    this.serviceDefinetions = new HashMap<URL, ServerServiceDefinition>();
                    ServerBuilder builder = ServerBuilder.forPort((int)this.port);
                    builder.fallbackHandlerRegistry((HandlerRegistry)this.registry);
                    if (this.executor != null) {
                        builder.executor((Executor)this.executor);
                    }
                    if (builder instanceof NettyServerBuilder) {
                        this.httpHandler = new NettyHttpRequestHandler(this.executor);
                        ((NettyServerBuilder)builder).protocolNegotiator((ProtocolNegotiator)new HttpProtocolNegotiator(this.httpHandler));
                    }
                    this.server = builder.build();
                    this.server.start();
                    this.init = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExporter(Exporter<?> exporter) throws Exception {
        Provider provider = exporter.getProvider();
        ServerServiceDefinition serviceDefine = GrpcUtil.getServiceDefByAnnotation(provider.getInterface());
        boolean urlShareChannel = exporter.getUrl().getBooleanParameter(URLParamType.shareChannel.getName(), URLParamType.shareChannel.getBooleanValue());
        Map<URL, ServerServiceDefinition> map = this.serviceDefinetions;
        synchronized (map) {
            if (!(this.shareChannel && urlShareChannel || this.serviceDefinetions.isEmpty())) {
                URL url = this.serviceDefinetions.keySet().iterator().next();
                throw new MotanFrameworkException("url:" + exporter.getUrl() + " cannot share channel with url:" + url);
            }
            this.registry.addService(serviceDefine, provider);
            if (this.httpHandler != null) {
                this.httpHandler.addProvider(provider);
            }
            this.serviceDefinetions.put(exporter.getUrl(), serviceDefine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void safeRelease(URL url) {
        Map<URL, ServerServiceDefinition> map = this.serviceDefinetions;
        synchronized (map) {
            this.registry.removeService(this.serviceDefinetions.remove(url));
            if (this.httpHandler != null) {
                this.httpHandler.removeProvider(url);
            }
            if (this.serviceDefinetions.isEmpty()) {
                this.server.shutdown();
                if (this.executor != null) {
                    this.executor.shutdownNow();
                }
            }
        }
    }
}

