/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.grpc.http;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.protobuf.Message;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.DefaultRequest;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanSwitcherUtil;
import com.weibo.api.motan.util.NetUtils;
import com.weibo.api.motan.util.ReflectUtil;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;

@ChannelHandler.Sharable
public class NettyHttpRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    public static final String BAD_REQUEST = "/bad-request";
    public static final String ROOT_PATH = "/";
    public static final String STATUS_PATH = "/rpcstatus";
    private ExecutorService executor;
    protected String swictherName = "feature.configserver.heartbeat";
    protected ConcurrentHashMap<String, Provider> providerMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, MethodInfo> methodDescMap = new ConcurrentHashMap();

    public NettyHttpRequestHandler(ExecutorService executor) {
        this.executor = executor;
    }

    protected void channelRead0(final ChannelHandlerContext ctx, final FullHttpRequest httpRequest) throws Exception {
        if (BAD_REQUEST.equals(httpRequest.uri())) {
            this.sendResponse(ctx, this.buildDefaultResponse("bad request!", HttpResponseStatus.BAD_REQUEST));
            return;
        }
        if (ROOT_PATH.equals(httpRequest.uri()) || STATUS_PATH.equals(httpRequest.uri())) {
            if (this.isSwitchOpen()) {
                this.sendResponse(ctx, this.buildDefaultResponse("ok!", HttpResponseStatus.OK));
            } else {
                this.sendResponse(ctx, this.buildErrorResponse("service not available!"));
            }
            return;
        }
        httpRequest.content().retain();
        if (this.executor == null) {
            this.processHttpRequest(ctx, httpRequest);
        } else {
            try {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        NettyHttpRequestHandler.this.processHttpRequest(ctx, httpRequest);
                    }
                });
            }
            catch (Exception e) {
                LoggerUtil.error((String)"request is rejected by threadpool!", (Throwable)e);
                httpRequest.content().release();
                this.sendResponse(ctx, this.buildErrorResponse("request is rejected by threadpool!"));
            }
        }
    }

    public void addProvider(Provider provider) {
        Method[] methods;
        this.providerMap.put(provider.getUrl().getPath(), provider);
        for (Method m : methods = provider.getInterface().getMethods()) {
            MethodInfo newMethodInfo = new MethodInfo(m.getName(), ReflectUtil.getMethodParamDesc((Method)m), m);
            if (this.methodDescMap.get(newMethodInfo.getMethodName()) == null) {
                this.methodDescMap.put(newMethodInfo.getMethodName(), newMethodInfo);
                continue;
            }
            MethodInfo old = this.methodDescMap.get(newMethodInfo.getMethodName());
            if (!old.isDuplicate()) {
                this.methodDescMap.put(old.getMethodName() + old.getMethodDesc(), old);
                this.methodDescMap.put(newMethodInfo.getMethodName(), MethodInfo.DUP_METHOD);
            }
            this.methodDescMap.put(newMethodInfo.getMethodName() + newMethodInfo.getMethodDesc(), newMethodInfo);
        }
    }

    public void removeProvider(URL url) {
        this.providerMap.remove(url.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processHttpRequest(ChannelHandlerContext ctx, FullHttpRequest httpRequest) {
        FullHttpResponse httpResponse = null;
        try {
            Provider provider;
            DefaultRequest rpcRequest = this.buildRpcRequest(httpRequest);
            String ip = NetUtils.getHostName((SocketAddress)ctx.channel().remoteAddress());
            if (ip != null) {
                rpcRequest.setAttachment(URLParamType.host.getName(), ip);
            }
            if ((provider = this.providerMap.get(rpcRequest.getInterfaceName())) == null) {
                httpResponse = this.buildErrorResponse("request service not exist. service:" + rpcRequest.getInterfaceName());
            } else {
                Response response = provider.call((Request)rpcRequest);
                httpResponse = this.buildHttpResponse(response, HttpUtil.isKeepAlive((HttpMessage)httpRequest));
            }
        }
        catch (Exception e) {
            LoggerUtil.error((String)"NettyHttpHandler process http request fail.", (Throwable)e);
            httpResponse = this.buildErrorResponse(e.getMessage());
        }
        finally {
            httpRequest.content().release();
        }
        this.sendResponse(ctx, httpResponse);
    }

    protected DefaultRequest buildRpcRequest(FullHttpRequest httpRequest) throws UnsupportedEncodingException {
        String uri = httpRequest.uri();
        String[] uriInfo = uri.split("\\?");
        String[] serviceInfo = uriInfo[0].split(ROOT_PATH);
        if (serviceInfo.length != 4) {
            throw new MotanServiceException("invalid request uri! uri like '/${group}/${service}/${method}'");
        }
        DefaultRequest rpcRequest = new DefaultRequest();
        rpcRequest.setAttachment(URLParamType.group.getName(), serviceInfo[1]);
        rpcRequest.setInterfaceName(serviceInfo[2]);
        rpcRequest.setMethodName(serviceInfo[3]);
        HashMap<String, String> params = new HashMap<String, String>();
        if (uriInfo.length == 2) {
            this.addParams(params, uriInfo[1]);
        }
        ByteBuf buf = httpRequest.content();
        byte[] contentBytes = new byte[buf.readableBytes()];
        buf.getBytes(0, contentBytes);
        String body = new String(contentBytes, "UTF-8");
        this.addParams(params, body);
        MethodInfo mi = this.methodDescMap.get(rpcRequest.getMethodName());
        if (mi != null && mi.isDuplicate()) {
            mi = null;
            String paramDesc = params.get("paramDesc");
            if (StringUtils.isBlank((CharSequence)paramDesc)) {
                throw new MotanServiceException("request method name conflict! paramDesc is required!" + rpcRequest.getMethodName());
            }
            mi = this.methodDescMap.get(rpcRequest.getMethodName() + paramDesc);
        }
        if (mi == null) {
            throw new MotanServiceException("request method name not found" + rpcRequest.getMethodName());
        }
        rpcRequest.setParamtersDesc(mi.getMethodDesc());
        this.addAttachment(rpcRequest, httpRequest.headers());
        rpcRequest.setArguments(this.parseArguments(params.get("params"), mi));
        return rpcRequest;
    }

    private void addAttachment(DefaultRequest rpcRequest, HttpHeaders headers) {
        for (Map.Entry h : headers) {
            rpcRequest.setAttachment((String)h.getKey(), (String)h.getValue());
        }
    }

    private void addParams(Map<String, String> params, String paramStr) throws UnsupportedEncodingException {
        String[] tempArray;
        for (String str : tempArray = paramStr.split("&")) {
            String[] param = str.split("=");
            if (param.length != 2) continue;
            params.put(param[0], URLDecoder.decode(param[1], "UTF-8"));
        }
    }

    protected Object[] parseArguments(String params, MethodInfo methodInfo) {
        if (params == null) {
            return null;
        }
        Class<?>[] paramsType = methodInfo.getMethod().getParameterTypes();
        JsonParser parser = new JsonParser();
        JsonArray jsonArray = (JsonArray)parser.parse(params);
        try {
            Object[] result = new Object[jsonArray.size()];
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonElement element = jsonArray.get(i);
                Message pbMessage = null;
                try {
                    Method method = paramsType[i].getMethod("getDefaultInstance", null);
                    if (method != null) {
                        pbMessage = (Message)method.invoke(null, null);
                    }
                }
                catch (Exception e) {
                    LoggerUtil.warn((String)("parse pb message fail. param type:" + paramsType[i]));
                }
                if (pbMessage == null) continue;
                result[i] = this.parsePB(element.toString(), pbMessage);
            }
            return result;
        }
        catch (Exception e) {
            throw new MotanServiceException("parse arguments fail!" + e.getMessage());
        }
    }

    private Object parsePB(String json, Message pbMessage) throws Exception {
        MethodDescriptor.Marshaller marshaller = ProtoUtils.jsonMarshaller((Message)pbMessage);
        ByteArrayInputStream is = new ByteArrayInputStream(json.getBytes("UTF-8"));
        return marshaller.parse((InputStream)is);
    }

    protected FullHttpResponse buildHttpResponse(Response response, boolean keepAlive) throws Exception {
        Object value = response.getValue();
        byte[] responseBytes = null;
        if (value instanceof Message) {
            MethodDescriptor.Marshaller marshaller = ProtoUtils.jsonMarshaller((Message)((Message)value.getClass().getMethod("getDefaultInstance", null).invoke(null, null)));
            InputStream is = marshaller.stream(value);
            responseBytes = new byte[is.available()];
            is.read(responseBytes);
        }
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer(responseBytes));
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/x-www-form-urlencoded");
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)httpResponse.content().readableBytes());
        if (keepAlive) {
            httpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        } else {
            httpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        }
        return httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(ChannelHandlerContext ctx, FullHttpResponse httpResponse) {
        boolean close = false;
        try {
            ctx.write((Object)httpResponse);
            ctx.flush();
        }
        catch (Exception e) {
            LoggerUtil.error((String)"NettyHttpHandler write response fail.", (Throwable)e);
            close = true;
        }
        finally {
            if (close || httpResponse == null || !HttpHeaderValues.KEEP_ALIVE.equals((Object)httpResponse.headers().get((CharSequence)HttpHeaderNames.CONNECTION))) {
                ctx.close();
            }
        }
    }

    protected FullHttpResponse buildErrorResponse(String errMsg) {
        return this.buildDefaultResponse(errMsg, HttpResponseStatus.SERVICE_UNAVAILABLE);
    }

    protected FullHttpResponse buildDefaultResponse(String msg, HttpResponseStatus status) {
        DefaultFullHttpResponse errorResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.wrappedBuffer((byte[])msg.getBytes()));
        return errorResponse;
    }

    protected boolean isSwitchOpen() {
        return MotanSwitcherUtil.isOpen((String)this.swictherName);
    }

    static class MethodInfo {
        static final String DUPLICATION = "DUP_METHOD";
        public static MethodInfo DUP_METHOD = new MethodInfo("DUP_METHOD", null, null);
        private String methodName;
        private String methodDesc;
        private Method method;

        public MethodInfo(String methodName, String methodDesc, Method method) {
            this.methodName = methodName;
            this.methodDesc = methodDesc;
            this.method = method;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getMethodDesc() {
            return this.methodDesc;
        }

        public Method getMethod() {
            return this.method;
        }

        public boolean isDuplicate() {
            return DUPLICATION.equals(this.methodName);
        }
    }
}

