/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.switcher;

import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.switcher.Switcher;
import com.weibo.api.motan.switcher.SwitcherListener;
import com.weibo.api.motan.switcher.SwitcherService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@SpiMeta(name="localSwitcherService")
public class LocalSwitcherService
implements SwitcherService {
    private static ConcurrentMap<String, Switcher> switchers = new ConcurrentHashMap<String, Switcher>();
    private ConcurrentHashMap<String, List<SwitcherListener>> listenerMap = new ConcurrentHashMap();

    public static Switcher getSwitcherStatic(String name) {
        return (Switcher)switchers.get(name);
    }

    @Override
    public Switcher getSwitcher(String name) {
        return (Switcher)switchers.get(name);
    }

    @Override
    public List<Switcher> getAllSwitchers() {
        return new ArrayList<Switcher>(switchers.values());
    }

    @Override
    public void initSwitcher(String switcherName, boolean initialValue) {
        this.setValue(switcherName, initialValue);
    }

    @Override
    public boolean isOpen(String switcherName) {
        Switcher switcher = (Switcher)switchers.get(switcherName);
        return switcher != null && switcher.isOn();
    }

    @Override
    public boolean isOpen(String switcherName, boolean defaultValue) {
        Switcher switcher = (Switcher)switchers.get(switcherName);
        if (switcher == null) {
            switchers.putIfAbsent(switcherName, new Switcher(switcherName, defaultValue));
            switcher = (Switcher)switchers.get(switcherName);
        }
        return switcher.isOn();
    }

    @Override
    public void setValue(String switcherName, boolean value) {
        Switcher switcher = (Switcher)switchers.get(switcherName);
        if (switcher == null) {
            switchers.putIfAbsent(switcherName, new Switcher(switcherName, value));
            switcher = (Switcher)switchers.get(switcherName);
        }
        switcher.setValue(value);
        List<SwitcherListener> listeners = this.listenerMap.get(switcherName);
        if (listeners != null) {
            for (SwitcherListener listener : listeners) {
                listener.onValueChanged(switcherName, value);
            }
        }
    }

    @Override
    public void registerListener(String switcherName, SwitcherListener listener) {
        List<SwitcherListener> listeners = Collections.synchronizedList(new ArrayList());
        List<SwitcherListener> preListeners = this.listenerMap.putIfAbsent(switcherName, listeners);
        if (preListeners == null) {
            listeners.add(listener);
        } else {
            preListeners.add(listener);
        }
    }

    @Override
    public void unRegisterListener(String switcherName, SwitcherListener listener) {
        List<SwitcherListener> listeners = this.listenerMap.get(switcherName);
        if (listener == null) {
            listeners.clear();
        } else {
            listeners.remove(listener);
        }
    }

    @Override
    public boolean canHoldSwitcher() {
        return true;
    }
}

