/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.serialize;

import com.weibo.api.motan.codec.Serialization;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.protocol.v2motan.GrowableByteBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SpiMeta(name="simple")
public class SimpleSerialization
implements Serialization {
    private static final int DEFAULT_MAP_SIZE = 16;
    private static final int DEFAULT_ARRAY_SIZE = 16;

    public static boolean isStringCollection(Collection<?> obj) {
        if (obj.isEmpty()) {
            return false;
        }
        for (Object v : obj) {
            if (v == null || v instanceof String) continue;
            return false;
        }
        return true;
    }

    public static boolean isStringMap(Map<?, ?> obj) {
        if (obj.isEmpty()) {
            return false;
        }
        for (Map.Entry<?, ?> entry : obj.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || entry.getKey() instanceof String && entry.getValue() instanceof String) continue;
            return false;
        }
        return true;
    }

    @Override
    public byte[] serialize(Object obj) throws IOException {
        GrowableByteBuffer buffer = new GrowableByteBuffer(4096);
        this.serialize(obj, buffer);
        buffer.flip();
        byte[] result = new byte[buffer.remaining()];
        buffer.get(result);
        return result;
    }

    private void serialize(Object obj, GrowableByteBuffer buffer) throws IOException {
        if (obj == null) {
            buffer.put((byte)0);
            return;
        }
        Class<?> clz = obj.getClass();
        if (clz == String.class) {
            this.writeString(buffer, (String)obj);
            return;
        }
        if (clz == Byte.class || clz == Byte.TYPE) {
            this.writeByte(buffer, (Byte)obj);
            return;
        }
        if (clz == Boolean.class || clz == Boolean.TYPE) {
            this.writeBool(buffer, (Boolean)obj);
            return;
        }
        if (clz == Short.class || clz == Short.TYPE) {
            this.writeInt16(buffer, (Short)obj);
            return;
        }
        if (clz == Integer.class || clz == Integer.TYPE) {
            this.writeInt32(buffer, (Integer)obj);
            return;
        }
        if (clz == Long.class || clz == Long.TYPE) {
            this.writeInt64(buffer, (Long)obj);
            return;
        }
        if (clz == Float.class || clz == Float.TYPE) {
            this.writeFloat32(buffer, ((Float)obj).floatValue());
            return;
        }
        if (clz == Double.class || clz == Double.TYPE) {
            this.writeFloat64(buffer, (Double)obj);
            return;
        }
        if (obj instanceof Map) {
            if (SimpleSerialization.isStringMap((Map)obj)) {
                this.writeStringMap(buffer, (Map)obj);
            } else {
                this.writeMap(buffer, (Map)obj);
            }
            return;
        }
        if (clz.isArray()) {
            if (clz.getComponentType() == String.class) {
                this.writeStringArray(buffer, (String[])obj);
            } else if (clz.getComponentType() == Byte.TYPE) {
                this.writeBytes(buffer, (byte[])obj);
            } else {
                this.writeArray(buffer, (Object[])obj);
            }
            return;
        }
        if (obj instanceof List || obj instanceof Set) {
            if (SimpleSerialization.isStringCollection((Collection)obj)) {
                this.writeStringArray(buffer, (Collection)obj);
            } else {
                this.writeArray(buffer, (Collection)obj);
            }
            return;
        }
        throw new MotanServiceException("SimpleSerialization unsupported type: " + clz);
    }

    @Override
    public <T> T deserialize(byte[] bytes, Class<T> clz) throws IOException {
        GrowableByteBuffer buffer = new GrowableByteBuffer(ByteBuffer.wrap(bytes));
        return this.deserialize(buffer, clz);
    }

    private <T> T deserialize(GrowableByteBuffer buffer, Class<T> clz) throws IOException {
        byte type = buffer.get();
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                if (clz != String.class && clz != Object.class) break;
                return (T)this.readString(buffer);
            }
            case 2: {
                if (!clz.isAssignableFrom(HashMap.class)) break;
                return (T)this.readStringMap(buffer);
            }
            case 3: {
                if (clz != byte[].class && clz != Object.class) break;
                return (T)this.readBytes(buffer);
            }
            case 4: {
                if (clz.isArray() && clz.getComponentType() == String.class) {
                    return (T)this.readStringArray(buffer);
                }
                if (clz.isAssignableFrom(ArrayList.class)) {
                    return (T)this.readStringList(buffer);
                }
                if (!clz.isAssignableFrom(HashSet.class)) break;
                return (T)this.readStringSet(buffer);
            }
            case 5: {
                if (clz != Boolean.TYPE && clz != Boolean.class && clz != Object.class) break;
                return (T)this.readBool(buffer);
            }
            case 6: {
                if (clz != Byte.TYPE && clz != Byte.class && clz != Object.class) break;
                return (T)this.readByte(buffer);
            }
            case 7: {
                if (clz != Short.TYPE && clz != Short.class && clz != Object.class) break;
                return (T)this.readInt16(buffer);
            }
            case 8: {
                if (clz != Integer.TYPE && clz != Integer.class && clz != Object.class) break;
                return (T)this.readInt32(buffer);
            }
            case 9: {
                if (clz != Long.TYPE && clz != Long.class && clz != Object.class) break;
                return (T)this.readInt64(buffer);
            }
            case 10: {
                if (clz != Float.TYPE && clz != Float.class && clz != Object.class) break;
                return (T)this.readFloat32(buffer);
            }
            case 11: {
                if (clz != Double.TYPE && clz != Double.class && clz != Object.class) break;
                return (T)this.readFloat64(buffer);
            }
            case 20: {
                if (!clz.isAssignableFrom(HashMap.class)) break;
                return (T)this.readMap(buffer);
            }
            case 21: {
                if (clz.isArray()) {
                    return (T)this.readArray(buffer);
                }
                if (clz.isAssignableFrom(ArrayList.class)) {
                    return (T)this.readList(buffer);
                }
                if (!clz.isAssignableFrom(HashSet.class)) break;
                return (T)this.readSet(buffer);
            }
        }
        throw new MotanServiceException("SimpleSerialization not support " + type + " with receiver type:" + clz);
    }

    @Override
    public byte[] serializeMulti(Object[] data) throws IOException {
        GrowableByteBuffer buffer = new GrowableByteBuffer(4096);
        for (Object o : data) {
            this.serialize(o, buffer);
        }
        buffer.flip();
        byte[] result = new byte[buffer.remaining()];
        buffer.get(result);
        return result;
    }

    @Override
    public Object[] deserializeMulti(byte[] data, Class<?>[] classes) throws IOException {
        GrowableByteBuffer buffer = new GrowableByteBuffer(ByteBuffer.wrap(data));
        Object[] result = new Object[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            result[i] = this.deserialize(buffer, classes[i]);
        }
        return result;
    }

    @Override
    public int getSerializationNumber() {
        return 6;
    }

    private void putString(GrowableByteBuffer buffer, String str) throws IOException {
        byte[] b = str.getBytes("UTF-8");
        buffer.putInt(b.length);
        buffer.put(b);
    }

    private void writeString(GrowableByteBuffer buffer, String str) throws IOException {
        buffer.put((byte)1);
        this.putString(buffer, str);
    }

    private void writeStringMap(GrowableByteBuffer buffer, Map<String, String> value) throws IOException {
        buffer.put((byte)2);
        int pos = buffer.position();
        buffer.position(pos + 4);
        for (Map.Entry<String, String> entry : value.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.putString(buffer, entry.getKey());
            this.putString(buffer, entry.getValue());
        }
        int npos = buffer.position();
        buffer.position(pos);
        buffer.putInt(npos - pos - 4);
        buffer.position(npos);
    }

    private void writeBytes(GrowableByteBuffer buffer, byte[] value) {
        buffer.put((byte)3);
        buffer.putInt(value.length);
        buffer.put(value);
    }

    private void writeStringArray(GrowableByteBuffer buffer, String[] value) throws IOException {
        buffer.put((byte)4);
        int pos = buffer.position();
        buffer.position(pos + 4);
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) continue;
            this.putString(buffer, value[i]);
        }
        int npos = buffer.position();
        buffer.position(pos);
        buffer.putInt(npos - pos - 4);
        buffer.position(npos);
    }

    private void writeStringArray(GrowableByteBuffer buffer, Collection<String> value) throws IOException {
        buffer.put((byte)4);
        int pos = buffer.position();
        buffer.position(pos + 4);
        for (String s : value) {
            if (s == null) continue;
            this.putString(buffer, s);
        }
        int npos = buffer.position();
        buffer.position(pos);
        buffer.putInt(npos - pos - 4);
        buffer.position(npos);
    }

    private void writeBool(GrowableByteBuffer buffer, boolean value) {
        buffer.put((byte)5);
        if (value) {
            buffer.put((byte)1);
        } else {
            buffer.put((byte)0);
        }
    }

    private void writeByte(GrowableByteBuffer buffer, byte value) {
        buffer.put((byte)6);
        buffer.put(value);
    }

    private void writeInt16(GrowableByteBuffer buffer, short value) {
        buffer.put((byte)7);
        buffer.putShort(value);
    }

    private void writeInt32(GrowableByteBuffer buffer, int value) {
        buffer.put((byte)8);
        buffer.putZigzag32(value);
    }

    private void writeInt64(GrowableByteBuffer buffer, long value) {
        buffer.put((byte)9);
        buffer.putZigzag64(value);
    }

    private void writeFloat32(GrowableByteBuffer buffer, float value) {
        buffer.put((byte)10);
        buffer.putFloat(value);
    }

    private void writeFloat64(GrowableByteBuffer buffer, double value) {
        buffer.put((byte)11);
        buffer.putDouble(value);
    }

    private void writeArray(GrowableByteBuffer buffer, Object[] value) throws IOException {
        buffer.put((byte)21);
        int pos = buffer.position();
        buffer.position(pos + 4);
        for (int i = 0; i < value.length; ++i) {
            this.serialize(value[i], buffer);
        }
        int npos = buffer.position();
        buffer.position(pos);
        buffer.putInt(npos - pos - 4);
        buffer.position(npos);
    }

    private void writeArray(GrowableByteBuffer buffer, Collection<?> value) throws IOException {
        buffer.put((byte)21);
        int pos = buffer.position();
        buffer.position(pos + 4);
        for (Object v : value) {
            this.serialize(v, buffer);
        }
        int npos = buffer.position();
        buffer.position(pos);
        buffer.putInt(npos - pos - 4);
        buffer.position(npos);
    }

    private void writeMap(GrowableByteBuffer buffer, Map<?, ?> value) throws IOException {
        buffer.put((byte)20);
        int pos = buffer.position();
        buffer.position(pos + 4);
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            this.serialize(entry.getKey(), buffer);
            this.serialize(entry.getValue(), buffer);
        }
        int npos = buffer.position();
        buffer.position(pos);
        buffer.putInt(npos - pos - 4);
        buffer.position(npos);
    }

    private int getAndCheckSize(GrowableByteBuffer buffer) {
        int size = buffer.getInt();
        if (size > buffer.remaining()) {
            throw new MotanServiceException("SimpleSerialization deserialize fail! buffer not enough!need size:" + size);
        }
        return size;
    }

    private String readString(GrowableByteBuffer buffer) throws IOException {
        return new String(this.readBytes(buffer), "UTF-8");
    }

    private Map<String, String> readStringMap(GrowableByteBuffer buffer) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>(16);
        int size = this.getAndCheckSize(buffer);
        int startPos = buffer.position();
        int endPos = startPos + size;
        while (buffer.position() < endPos) {
            map.put(this.readString(buffer), this.readString(buffer));
        }
        if (buffer.position() != endPos) {
            throw new MotanServiceException("SimpleSerialization deserialize wrong map size, except: " + size + " actual: " + (buffer.position() - startPos));
        }
        return map;
    }

    private byte[] readBytes(GrowableByteBuffer buffer) {
        int size = this.getAndCheckSize(buffer);
        if (size == 0) {
            return new byte[0];
        }
        byte[] b = new byte[size];
        buffer.get(b);
        return b;
    }

    private String[] readStringArray(GrowableByteBuffer buffer) throws IOException {
        List<String> values = this.readStringList(buffer);
        String[] result = new String[values.size()];
        return values.toArray(result);
    }

    private List<String> readStringList(GrowableByteBuffer buffer) throws IOException {
        ArrayList result = new ArrayList(16);
        return this.readStringCollection(buffer, result);
    }

    private Set<String> readStringSet(GrowableByteBuffer buffer) throws IOException {
        HashSet result = new HashSet(16);
        return this.readStringCollection(buffer, result);
    }

    private <T extends Collection> T readStringCollection(GrowableByteBuffer buffer, T collection) throws IOException {
        int size = this.getAndCheckSize(buffer);
        if (size == 0) {
            return collection;
        }
        int startPos = buffer.position();
        int endPos = startPos + size;
        while (buffer.position() < endPos) {
            collection.add((String)this.readString(buffer));
        }
        if (buffer.position() != endPos) {
            throw new MotanServiceException("SimpleSerialization deserialize wrong array size, except: " + size + " actual: " + (buffer.position() - startPos));
        }
        return collection;
    }

    private Boolean readBool(GrowableByteBuffer buffer) {
        return buffer.get() == 1;
    }

    private Byte readByte(GrowableByteBuffer buffer) {
        return buffer.get();
    }

    private Short readInt16(GrowableByteBuffer buffer) {
        return buffer.getShort();
    }

    private Integer readInt32(GrowableByteBuffer buffer) {
        return buffer.getZigZag32();
    }

    private Long readInt64(GrowableByteBuffer buffer) {
        return buffer.getZigZag64();
    }

    private Float readFloat32(GrowableByteBuffer buffer) {
        return Float.valueOf(buffer.getFloat());
    }

    private Double readFloat64(GrowableByteBuffer buffer) {
        return buffer.getDouble();
    }

    private Map readMap(GrowableByteBuffer buffer) throws IOException {
        HashMap<Object, Object> map = new HashMap<Object, Object>(16);
        int size = this.getAndCheckSize(buffer);
        int startPos = buffer.position();
        int endPos = startPos + size;
        while (buffer.position() < endPos) {
            map.put(this.deserialize(buffer, Object.class), this.deserialize(buffer, Object.class));
        }
        if (buffer.position() != endPos) {
            throw new MotanServiceException("SimpleSerialization deserialize wrong map size, except: " + size + " actual: " + (buffer.position() - startPos));
        }
        return map;
    }

    private Object[] readArray(GrowableByteBuffer buffer) throws IOException {
        List<Object> values = this.readList(buffer);
        Object[] result = new Object[values.size()];
        return values.toArray(result);
    }

    private List<Object> readList(GrowableByteBuffer buffer) throws IOException {
        ArrayList result = new ArrayList(16);
        return this.readCollection(buffer, result);
    }

    private Set<Object> readSet(GrowableByteBuffer buffer) throws IOException {
        HashSet result = new HashSet(16);
        return this.readCollection(buffer, result);
    }

    private <T extends Collection> T readCollection(GrowableByteBuffer buffer, T collection) throws IOException {
        int size = this.getAndCheckSize(buffer);
        if (size == 0) {
            return collection;
        }
        int startPos = buffer.position();
        int endPos = startPos + size;
        while (buffer.position() < endPos) {
            collection.add((Object)this.deserialize(buffer, Object.class));
        }
        if (buffer.position() != endPos) {
            throw new MotanServiceException("SimpleSerialization deserialize wrong array size, except: " + size + " actual: " + (buffer.position() - startPos));
        }
        return collection;
    }

    public static final class SimpleType {
        public static final byte NULL = 0;
        public static final byte STRING = 1;
        public static final byte STRING_MAP = 2;
        public static final byte BYTE_ARRAY = 3;
        public static final byte STRING_ARRAY = 4;
        public static final byte BOOL = 5;
        public static final byte BYTE = 6;
        public static final byte INT16 = 7;
        public static final byte INT32 = 8;
        public static final byte INT64 = 9;
        public static final byte FLOAT32 = 10;
        public static final byte FLOAT64 = 11;
        public static final byte MAP = 20;
        public static final byte ARRAY = 21;
    }
}

