/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.serialize;

import com.weibo.api.motan.codec.Serialization;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.breeze.Breeze;
import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.BreezeReader;
import com.weibo.breeze.BreezeWriter;
import com.weibo.breeze.serializer.CommonSerializer;
import com.weibo.breeze.serializer.Serializer;
import com.weibo.breeze.type.Types;
import java.io.IOException;

@SpiMeta(name="breeze")
public class BreezeSerialization
implements Serialization {
    public static int DEFAULT_BUFFER_SIZE = 1024;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] serialize(Object o) throws IOException {
        BreezeBuffer buffer = new BreezeBuffer(DEFAULT_BUFFER_SIZE);
        if (o instanceof Throwable) {
            Serializer serializer = Breeze.getSerializer(o.getClass());
            if (serializer == null) throw new BreezeException("Breeze unsupported type: " + o.getClass());
            if (serializer instanceof CommonSerializer) {
                this.writeException((Throwable)o, buffer);
            } else {
                BreezeWriter.putMessageType((BreezeBuffer)buffer, (String)serializer.getName());
                serializer.writeToBuf(o, buffer);
            }
        } else {
            BreezeWriter.writeObject((BreezeBuffer)buffer, (Object)o);
        }
        buffer.flip();
        return buffer.getBytes();
    }

    @Override
    public <T> T deserialize(byte[] bytes, Class<T> clz) throws IOException {
        Serializer serializer;
        BreezeBuffer buffer = new BreezeBuffer(bytes);
        if (Throwable.class.isAssignableFrom(clz) && (serializer = Breeze.getSerializer(clz)) instanceof CommonSerializer) {
            throw this.readToMotanException(buffer, clz);
        }
        return (T)BreezeReader.readObject((BreezeBuffer)buffer, clz);
    }

    @Override
    public byte[] serializeMulti(Object[] objects) throws IOException {
        BreezeBuffer buffer = new BreezeBuffer(DEFAULT_BUFFER_SIZE);
        for (Object o : objects) {
            BreezeWriter.writeObject((BreezeBuffer)buffer, (Object)o);
        }
        buffer.flip();
        return buffer.getBytes();
    }

    @Override
    public Object[] deserializeMulti(byte[] bytes, Class<?>[] classes) throws IOException {
        Object[] objects = new Object[classes.length];
        BreezeBuffer buffer = new BreezeBuffer(bytes);
        for (int i = 0; i < classes.length; ++i) {
            objects[i] = BreezeReader.readObject((BreezeBuffer)buffer, classes[i]);
        }
        return objects;
    }

    @Override
    public int getSerializationNumber() {
        return 8;
    }

    private void writeException(Throwable obj, BreezeBuffer buffer) throws BreezeException {
        BreezeWriter.putMessageType((BreezeBuffer)buffer, (String)obj.getClass().getName());
        BreezeWriter.writeMessage((BreezeBuffer)buffer, () -> Types.TYPE_STRING.writeMessageField(buffer, 1, (Object)obj.getMessage()));
    }

    private MotanServiceException readToMotanException(BreezeBuffer buffer, Class<?> clz) throws BreezeException {
        byte bType = buffer.get();
        if (bType >= -34 && bType <= -1) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("remote exception class : ").append(BreezeReader.readMessageName((BreezeBuffer)buffer, (byte)bType)).append(", error message : ");
            BreezeReader.readMessage((BreezeBuffer)buffer, index -> {
                switch (index) {
                    case 1: {
                        stringBuilder.append((String)Types.TYPE_STRING.read(buffer));
                        break;
                    }
                    default: {
                        BreezeReader.readObject((BreezeBuffer)buffer, Object.class);
                    }
                }
            });
            return new MotanServiceException(stringBuilder.toString());
        }
        throw new BreezeException("Breeze not support " + bType + " with receiver type:" + clz);
    }
}

