/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.proxy;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.proxy.AbstractRefererHandler;
import com.weibo.api.motan.proxy.CommonClient;
import com.weibo.api.motan.rpc.DefaultRequest;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.transport.MeshClient;
import com.weibo.api.motan.util.MotanClientUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;

public class MeshClientRefererInvocationHandler<T>
extends AbstractRefererHandler<T>
implements InvocationHandler,
CommonClient {
    protected MeshClient meshClient;
    protected URL refUrl;

    public MeshClientRefererInvocationHandler(Class<T> clz, URL refUrl, MeshClient meshClient) {
        this.clz = clz;
        this.refUrl = refUrl;
        this.interfaceName = MotanFrameworkUtil.removeAsyncSuffix(clz.getName());
        this.meshClient = meshClient;
    }

    public MeshClientRefererInvocationHandler(URL refUrl, MeshClient meshClient) {
        this.refUrl = refUrl;
        this.interfaceName = refUrl.getPath();
        this.meshClient = meshClient;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isLocalMethod(method)) {
            if ("toString".equals(method.getName())) {
                return this.innerToString();
            }
            if ("equals".equals(method.getName())) {
                return this.refUrl.equals(args[0]);
            }
            if ("hashCode".equals(method.getName())) {
                return this.refUrl.hashCode();
            }
            throw new MotanServiceException("can not invoke local method:" + method.getName());
        }
        DefaultRequest request = new DefaultRequest();
        boolean async = this.fillDefaultRequest(request, method, args);
        return this.invokeRequest((Request)request, (Class)this.getRealReturnType(async, this.clz, method, request.getMethodName()), async);
    }

    @Override
    Object invokeRequest(Request request, Class returnType, boolean async) throws Throwable {
        this.fillWithContext(request, async);
        this.setDefaultAttachments(request, URLParamType.application.getName(), URLParamType.group.getName(), URLParamType.module.getName(), URLParamType.version.getName());
        String timeout = this.refUrl.getMethodParameter(request.getMethodName(), request.getParamtersDesc(), URLParamType.requestTimeout.getName());
        if (timeout != null) {
            request.setAttachment("M_tmo", timeout);
        }
        return this.call(this.meshClient, this.refUrl, request, returnType, async);
    }

    private void setDefaultAttachments(Request request, String ... keys) {
        for (String key : keys) {
            String value = this.refUrl.getParameter(key);
            if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
            request.setAttachment(key, value);
        }
    }

    private String innerToString() {
        return "referer: " + this.refUrl.toFullStr() + " - mesh client: " + this.meshClient.getUrl().toFullStr();
    }

    public Object call(String methodName, Object[] arguments, Class returnType) throws Throwable {
        return this.invokeRequest(this.buildRequest(methodName, arguments), returnType, false);
    }

    public Object asyncCall(String methodName, Object[] arguments, Class returnType) throws Throwable {
        return this.invokeRequest(this.buildRequest(methodName, arguments), returnType, true);
    }

    public Object call(Request request, Class returnType) throws Throwable {
        return this.invokeRequest(request, returnType, false);
    }

    public Object asyncCall(Request request, Class returnType) throws Throwable {
        return this.invokeRequest(request, returnType, true);
    }

    @Override
    public Request buildRequest(String methodName, Object[] arguments) {
        return this.buildRequest(this.interfaceName, methodName, arguments);
    }

    @Override
    public Request buildRequest(String interfaceName, String methodName, Object[] arguments) {
        return MotanClientUtil.buildRequest(interfaceName, methodName, arguments);
    }
}

