/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.config;

import com.weibo.api.motan.cluster.Cluster;
import com.weibo.api.motan.cluster.group.ClusterGroup;
import com.weibo.api.motan.cluster.group.DefaultClusterGroup;
import com.weibo.api.motan.cluster.support.ClusterSupport;
import com.weibo.api.motan.common.MotanConstants;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.config.AbstractRefererConfig;
import com.weibo.api.motan.config.BasicRefererInterfaceConfig;
import com.weibo.api.motan.config.MethodConfig;
import com.weibo.api.motan.config.ProtocolConfig;
import com.weibo.api.motan.config.annotation.ConfigDesc;
import com.weibo.api.motan.config.handler.ConfigHandler;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.proxy.ProxyFactory;
import com.weibo.api.motan.registry.RegistryService;
import com.weibo.api.motan.rpc.Caller;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.runtime.GlobalRuntime;
import com.weibo.api.motan.util.CollectionUtil;
import com.weibo.api.motan.util.ConcurrentHashSet;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MeshProxyUtil;
import com.weibo.api.motan.util.MotanGlobalConfigUtil;
import com.weibo.api.motan.util.StringTools;
import com.weibo.api.motan.util.UrlUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;

public class RefererConfig<T>
extends AbstractRefererConfig {
    private static final ConcurrentHashSet<String> NONE_EXTRA_GROUP_PROTOCOL_SET = new ConcurrentHashSet();
    private static final ConcurrentHashSet<String> NONE_EXTRA_GROUP_REGISTRY_SET = new ConcurrentHashSet();
    private static final long serialVersionUID = -2299754608229467887L;
    protected static final String MASTER_CLUSTER_KEY = "master-";
    protected static final String SANDBOX_CLUSTER_KEY = "sandbox-";
    protected static final String GREY_CLUSTER_KEY = "grey-";
    protected static final String BACKUP_CLUSTER_KEY = "backup-";
    protected static final String NONE_GROUP_STRING = "none";
    public static String DEFAULT_SANDBOX_GROUPS;
    public static String DEFAULT_GREY_GROUPS;
    private Class<T> interfaceClass;
    private String serviceInterface;
    protected List<MethodConfig> methods;
    private String directUrl;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private T ref;
    private BasicRefererInterfaceConfig basicReferer;
    private Map<String, ClusterSupport<T>> clusterSupports;
    private List<Caller<T>> clusterGroups;

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(String serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public List<MethodConfig> getMethods() {
        return this.methods;
    }

    public void setMethods(List<MethodConfig> methods) {
        this.methods = methods;
    }

    public void setMethods(MethodConfig methods) {
        this.methods = Collections.singletonList(methods);
    }

    public boolean hasMethods() {
        return this.methods != null && !this.methods.isEmpty();
    }

    public T getRef() {
        if (this.ref == null) {
            this.initRef();
        }
        return this.ref;
    }

    public synchronized void initRef() {
        if (this.initialized.get()) {
            return;
        }
        try {
            this.interfaceClass = Class.forName(this.interfaceClass.getName(), true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new MotanFrameworkException("RefererConfig initRef Error: Class not found " + this.interfaceClass.getName(), e, MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
        }
        this.checkInterfaceAndMethods(this.interfaceClass, this.methods);
        if (this.meshClient != null) {
            this.initMeshClientRef();
        } else {
            this.initClusterRef();
        }
        this.initialized.set(true);
    }

    private void initClusterRef() {
        if (CollectionUtil.isEmpty(this.protocols)) {
            throw new MotanFrameworkException(String.format("%s RefererConfig is malformed, for protocol not set correctly!", this.interfaceClass.getName()));
        }
        this.clusterSupports = new HashMap<String, ClusterSupport<T>>();
        this.clusterGroups = new ArrayList<Caller<T>>();
        String proxy = null;
        ConfigHandler configHandler = ExtensionLoader.getExtensionLoader(ConfigHandler.class).getExtension("default");
        this.loadRegistryUrls();
        String localIp = this.getLocalHostAddress();
        for (ProtocolConfig protocol : this.protocols) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(URLParamType.nodeType.getName(), "referer");
            params.put(URLParamType.version.getName(), URLParamType.version.getValue());
            params.put(URLParamType.refreshTimestamp.getName(), String.valueOf(System.currentTimeMillis()));
            RefererConfig.collectConfigParams(params, protocol, this.basicReferer, this.extConfig, this);
            RefererConfig.collectMethodConfigParams(params, this.getMethods());
            String path = StringUtils.isBlank((CharSequence)this.serviceInterface) ? this.interfaceClass.getName() : this.serviceInterface;
            URL refUrl = new URL(protocol.getName(), localIp, 0, path, params);
            ClusterGroup<T> clusterGroup = this.createClusterGroup(configHandler, refUrl);
            this.clusterGroups.add(clusterGroup);
            if (proxy != null) continue;
            proxy = this.getProxyType(refUrl);
        }
        this.ref = configHandler.refer(this.interfaceClass, this.clusterGroups, proxy);
    }

    private void initMeshClientRef() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(URLParamType.nodeType.getName(), "referer");
        RefererConfig.collectConfigParams(params, this.basicReferer, this.extConfig, this);
        String path = StringUtils.isBlank((CharSequence)this.serviceInterface) ? this.interfaceClass.getName() : this.serviceInterface;
        URL refUrl = new URL("motan2", this.getLocalHostAddress(), 0, path, params);
        ProxyFactory proxyFactory = ExtensionLoader.getExtensionLoader(ProxyFactory.class).getExtension(this.getProxyType(refUrl));
        this.ref = proxyFactory.getProxy(this.interfaceClass, refUrl, this.meshClient);
        LoggerUtil.info("init mesh client referer finish. url:" + refUrl.toFullStr());
    }

    private String getProxyType(URL refUrl) {
        String defaultProxy = StringUtils.isBlank((CharSequence)this.serviceInterface) ? URLParamType.proxy.getValue() : "common";
        return refUrl.getParameter(URLParamType.proxy.getName(), defaultProxy);
    }

    private ClusterGroup<T> createClusterGroup(ConfigHandler configHandler, URL refUrl) {
        Cluster<T> masterCluster = this.createInnerCluster(configHandler, refUrl, MASTER_CLUSTER_KEY);
        DefaultClusterGroup<T> clusterGroup = new DefaultClusterGroup<T>(masterCluster);
        if (this.needProcessExtraGroup(refUrl)) {
            try {
                String greyGroups;
                String sandboxGroups = refUrl.getParameter(URLParamType.sandboxGroups.getName(), DEFAULT_SANDBOX_GROUPS);
                if (StringUtils.isNotBlank((CharSequence)sandboxGroups) && !NONE_GROUP_STRING.equals(sandboxGroups)) {
                    clusterGroup.setSandboxClusters(this.createMultiClusters(refUrl, configHandler, sandboxGroups, SANDBOX_CLUSTER_KEY, false, true));
                    LoggerUtil.info("init sandbox clusters success. master cluster url:" + refUrl.toSimpleString() + ", sandbox groups:" + sandboxGroups);
                }
                if (StringUtils.isNotBlank((CharSequence)(greyGroups = refUrl.getParameter(URLParamType.greyGroups.getName(), DEFAULT_GREY_GROUPS))) && !NONE_GROUP_STRING.equals(greyGroups)) {
                    clusterGroup.setGreyClusters(this.createMultiClusters(refUrl, configHandler, greyGroups, GREY_CLUSTER_KEY, false, true));
                    LoggerUtil.info("init grey clusters success. master cluster url:" + refUrl.toSimpleString() + ", grey groups:" + greyGroups);
                }
                if (StringUtils.isNotBlank((CharSequence)refUrl.getParameter(URLParamType.backupGroups.getName()))) {
                    clusterGroup.setBackupClusters(this.createMultiClusters(refUrl, configHandler, refUrl.getParameter(URLParamType.backupGroups.getName()), BACKUP_CLUSTER_KEY, true, false));
                    LoggerUtil.info("init backup clusters success. master cluster url:" + refUrl.toSimpleString() + ", backup groups:" + refUrl.getParameter(URLParamType.backupGroups.getName()));
                }
            }
            catch (Exception e) {
                LoggerUtil.error("init cluster inner group fail. master cluster url:" + refUrl.toFullStr(), e);
            }
        }
        clusterGroup.init();
        return clusterGroup;
    }

    private boolean needProcessExtraGroup(URL refUrl) {
        if (NONE_EXTRA_GROUP_PROTOCOL_SET.contains(refUrl.getProtocol())) {
            LoggerUtil.info("do not process extra groups due to protocol rules. url:" + refUrl.toSimpleString());
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)this.directUrl)) {
            LoggerUtil.info("do not process extra groups due to directUrl rules. url:" + refUrl.toSimpleString());
            return false;
        }
        if (MeshProxyUtil.needProcess(refUrl, false)) {
            LoggerUtil.info("do not process extra groups due to mesh proxy rules. url:" + refUrl.toSimpleString());
            return false;
        }
        if (this.registryUrls != null) {
            for (URL url : this.registryUrls) {
                if (!NONE_EXTRA_GROUP_REGISTRY_SET.contains(url.getProtocol())) continue;
                LoggerUtil.info("do not process extra groups due to registry rules. url:" + refUrl.toSimpleString());
                return false;
            }
        }
        return true;
    }

    private List<Cluster<T>> createMultiClusters(URL baseUrl, ConfigHandler configHandler, String groupString, String prefixKey, boolean lazyInit, boolean emptyNodeNotify) {
        String baseGroup = baseUrl.getGroup();
        ArrayList<Cluster<T>> clusters = new ArrayList<Cluster<T>>();
        Set<String> groupNames = StringTools.splitSet(groupString, ",");
        for (String groupName : groupNames) {
            if (groupName.startsWith("suffix:")) {
                groupName = baseGroup + groupName.substring("suffix:".length());
            }
            if (baseGroup.equals(groupName)) continue;
            URL groupUrl = baseUrl.createCopy();
            groupUrl.addParameter(URLParamType.group.getName(), groupName);
            groupUrl.addParameter(URLParamType.check.getName(), "false");
            if (lazyInit) {
                groupUrl.addParameter(URLParamType.lazyInit.getName(), "true");
            }
            if (emptyNodeNotify) {
                groupUrl.addParameter(URLParamType.clusterEmptyNodeNotify.getName(), "true");
            }
            Cluster<T> cluster = this.createInnerCluster(configHandler, groupUrl, prefixKey);
            clusters.add(cluster);
        }
        if (clusters.isEmpty()) {
            return null;
        }
        return clusters;
    }

    private Cluster<T> createInnerCluster(ConfigHandler configHandler, URL url, String prefixKey) {
        ClusterSupport<T> clusterSupport = this.createClusterSupport(url, configHandler);
        Cluster<T> cluster = clusterSupport.getCluster();
        String key = prefixKey + cluster.getUrl().getIdentity();
        this.clusterSupports.put(key, clusterSupport);
        GlobalRuntime.addCluster(key, cluster);
        return cluster;
    }

    private ClusterSupport<T> createClusterSupport(URL refUrl, ConfigHandler configHandler) {
        LoggerUtil.info("create cluster for refer url :" + refUrl.toFullStr());
        ArrayList<URL> regUrls = new ArrayList<URL>();
        if (StringUtils.isNotBlank((CharSequence)this.directUrl) || "injvm".equals(refUrl.getProtocol())) {
            URL regUrl = new URL("local", "127.0.0.1", 0, RegistryService.class.getName());
            if (StringUtils.isNotBlank((CharSequence)this.directUrl)) {
                String[] dus;
                ArrayList<URL> directUrls = new ArrayList<URL>();
                for (String du : dus = MotanConstants.COMMA_SPLIT_PATTERN.split(this.directUrl)) {
                    if (!du.contains(":")) continue;
                    String[] hostPort = du.split(":");
                    URL durl = refUrl.createCopy();
                    durl.setHost(hostPort[0].trim());
                    durl.setPort(Integer.parseInt(hostPort[1].trim()));
                    durl.addParameter(URLParamType.nodeType.getName(), "service");
                    directUrls.add(durl);
                }
                String directUrlsString = UrlUtils.urlsToString(directUrls);
                if (StringUtils.isNotBlank((CharSequence)directUrlsString)) {
                    regUrl.addParameter(URLParamType.directUrl.getName(), directUrlsString);
                } else {
                    LoggerUtil.warn("parse directUrl string is empty. directUrl:" + this.directUrl);
                }
            }
            regUrls.add(regUrl);
        } else {
            if (this.registryUrls == null || this.registryUrls.isEmpty()) {
                throw new IllegalStateException(String.format("No registry to reference %s on the consumer %s , please config <motan:registry address=\"...\" /> in your spring config.", this.interfaceClass, "127.0.0.1"));
            }
            for (URL url : this.registryUrls) {
                regUrls.add(url.createCopy());
            }
        }
        return configHandler.buildClusterSupport(this.interfaceClass, regUrls, refUrl);
    }

    public synchronized void destroy() {
        if (this.clusterSupports != null) {
            for (Map.Entry entry : this.clusterSupports.entrySet()) {
                try {
                    GlobalRuntime.removeCluster((String)entry.getKey());
                    ((ClusterSupport)entry.getValue()).destroy();
                }
                catch (Exception e) {
                    LoggerUtil.error("destroy cluster error. key: " + (String)entry.getKey() + ", url:" + ((ClusterSupport)entry.getValue()).getUrl().toFullStr(), e);
                }
            }
            this.clusterSupports.clear();
        }
        if (this.clusterGroups != null) {
            for (Caller caller : this.clusterGroups) {
                try {
                    caller.destroy();
                }
                catch (Exception e) {
                    LoggerUtil.error("destroy cluster group error. url:" + caller.getUrl().toFullStr(), e);
                }
            }
            this.clusterGroups.clear();
        }
        this.ref = null;
        this.initialized.set(false);
    }

    public void setInterface(Class<T> interfaceClass) {
        if (interfaceClass != null && !interfaceClass.isInterface()) {
            throw new IllegalStateException("The interface class " + interfaceClass + " is not a interface!");
        }
        this.interfaceClass = interfaceClass;
    }

    public Class<?> getInterface() {
        return this.interfaceClass;
    }

    public String getDirectUrl() {
        return this.directUrl;
    }

    public void setDirectUrl(String directUrl) {
        this.directUrl = directUrl;
    }

    @ConfigDesc(excluded=true)
    public BasicRefererInterfaceConfig getBasicReferer() {
        return this.basicReferer;
    }

    public void setBasicReferer(BasicRefererInterfaceConfig basicReferer) {
        this.basicReferer = basicReferer;
    }

    public Map<String, ClusterSupport<T>> getClusterSupports() {
        return this.clusterSupports;
    }

    public AtomicBoolean getInitialized() {
        return this.initialized;
    }

    static {
        NONE_EXTRA_GROUP_PROTOCOL_SET.add("injvm");
        NONE_EXTRA_GROUP_PROTOCOL_SET.add("memcache");
        NONE_EXTRA_GROUP_PROTOCOL_SET.add("memcacheq");
        NONE_EXTRA_GROUP_PROTOCOL_SET.add("redis");
        NONE_EXTRA_GROUP_REGISTRY_SET.add("direct");
        NONE_EXTRA_GROUP_REGISTRY_SET.add("local");
        NONE_EXTRA_GROUP_REGISTRY_SET.add("weibomesh");
        DEFAULT_SANDBOX_GROUPS = MotanGlobalConfigUtil.getConfig("DEFAULT_SANDBOX_GROUPS", "");
        DEFAULT_GREY_GROUPS = MotanGlobalConfigUtil.getConfig("DEFAULT_GREY_GROUPS", "");
    }
}

