/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.config;

import com.weibo.api.motan.config.AbstractConfig;
import com.weibo.api.motan.config.ExtConfig;
import com.weibo.api.motan.config.MethodConfig;
import com.weibo.api.motan.config.ProtocolConfig;
import com.weibo.api.motan.config.RegistryConfig;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.NetUtils;
import com.weibo.api.motan.util.ReflectUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AbstractInterfaceConfig
extends AbstractConfig {
    private static final long serialVersionUID = 4776516803466933310L;
    protected List<ProtocolConfig> protocols;
    protected List<RegistryConfig> registries;
    protected List<URL> registryUrls = new ArrayList<URL>();
    protected ExtConfig extConfig;
    protected String application;
    protected String module;
    protected String group;
    protected String version;
    protected String proxy;
    protected String filter;
    protected Integer actives;
    protected Boolean async;
    protected String mock;
    protected Boolean shareChannel;
    protected Boolean throwException;
    protected Integer requestTimeout;
    protected Boolean register;
    protected String accessLog;
    protected String check;
    protected Integer retries;
    protected Boolean usegz;
    protected Integer mingzSize;
    protected String codec;
    protected String localServiceAddress;
    protected Integer backupRequestDelayTime;
    protected String backupRequestDelayRatio;
    protected String backupRequestSwitcherName;
    protected String backupRequestMaxRetryRatio;
    protected Boolean transExceptionStack;
    protected Integer slowThreshold;
    protected String mixGroups;
    protected Boolean asyncInitConnection;
    protected Integer fusingThreshold;
    protected Integer connectTimeout;
    protected String sandboxGroups;
    protected String backupGroups;
    protected String greyGroups;

    public String getGreyGroups() {
        return this.greyGroups;
    }

    public void setGreyGroups(String greyGroups) {
        this.greyGroups = greyGroups;
    }

    public String getSandboxGroups() {
        return this.sandboxGroups;
    }

    public void setSandboxGroups(String sandboxGroups) {
        this.sandboxGroups = sandboxGroups;
    }

    public String getBackupGroups() {
        return this.backupGroups;
    }

    public void setBackupGroups(String backupGroups) {
        this.backupGroups = backupGroups;
    }

    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getProxy() {
        return this.proxy;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getAccessLog() {
        return this.accessLog;
    }

    public void setAccessLog(String accessLog) {
        this.accessLog = accessLog;
    }

    public List<RegistryConfig> getRegistries() {
        return this.registries;
    }

    public void setRegistries(List<RegistryConfig> registries) {
        this.registries = registries;
    }

    public ExtConfig getExtConfig() {
        return this.extConfig;
    }

    public void setExtConfig(ExtConfig extConfig) {
        this.extConfig = extConfig;
    }

    public void setRegistry(RegistryConfig registry) {
        this.registries = Collections.singletonList(registry);
    }

    public Integer getActives() {
        return this.actives;
    }

    public void setActives(Integer actives) {
        this.actives = actives;
    }

    public Boolean getAsync() {
        return this.async;
    }

    public void setAsync(Boolean async) {
        this.async = async;
    }

    public String getMock() {
        return this.mock;
    }

    public void setMock(String mock) {
        this.mock = mock;
    }

    public String getCheck() {
        return this.check;
    }

    @Deprecated
    public void setCheck(Boolean check) {
        this.check = String.valueOf(check);
    }

    public void setCheck(String check) {
        this.check = check;
    }

    public Boolean getShareChannel() {
        return this.shareChannel;
    }

    public void setShareChannel(Boolean shareChannel) {
        this.shareChannel = shareChannel;
    }

    public List<ProtocolConfig> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(List<ProtocolConfig> protocols) {
        this.protocols = protocols;
    }

    public void setProtocol(ProtocolConfig protocol) {
        this.protocols = Collections.singletonList(protocol);
    }

    public Boolean getThrowException() {
        return this.throwException;
    }

    public void setThrowException(Boolean throwException) {
        this.throwException = throwException;
    }

    public Integer getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Integer requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public boolean hasProtocol() {
        return this.protocols != null && !this.protocols.isEmpty();
    }

    public Boolean getRegister() {
        return this.register;
    }

    public void setRegister(Boolean register) {
        this.register = register;
    }

    public String getLocalServiceAddress() {
        return this.localServiceAddress;
    }

    public void setLocalServiceAddress(String localServiceAddress) {
        this.localServiceAddress = localServiceAddress;
    }

    public Boolean getUsegz() {
        return this.usegz;
    }

    public void setUsegz(Boolean usegz) {
        this.usegz = usegz;
    }

    public Integer getMingzSize() {
        return this.mingzSize;
    }

    public void setMingzSize(Integer mingzSize) {
        this.mingzSize = mingzSize;
    }

    public String getCodec() {
        return this.codec;
    }

    public void setCodec(String codec) {
        this.codec = codec;
    }

    public Integer getBackupRequestDelayTime() {
        return this.backupRequestDelayTime;
    }

    public void setBackupRequestDelayTime(Integer backupRequestDelayTime) {
        this.backupRequestDelayTime = backupRequestDelayTime;
    }

    public String getBackupRequestDelayRatio() {
        return this.backupRequestDelayRatio;
    }

    public void setBackupRequestDelayRatio(String backupRequestDelayRatio) {
        this.backupRequestDelayRatio = backupRequestDelayRatio;
    }

    public String getBackupRequestSwitcherName() {
        return this.backupRequestSwitcherName;
    }

    public void setBackupRequestSwitcherName(String backupRequestSwitcherName) {
        this.backupRequestSwitcherName = backupRequestSwitcherName;
    }

    public String getBackupRequestMaxRetryRatio() {
        return this.backupRequestMaxRetryRatio;
    }

    public void setBackupRequestMaxRetryRatio(String backupRequestMaxRetryRatio) {
        this.backupRequestMaxRetryRatio = backupRequestMaxRetryRatio;
    }

    public Boolean getTransExceptionStack() {
        return this.transExceptionStack;
    }

    public void setTransExceptionStack(Boolean transExceptionStack) {
        this.transExceptionStack = transExceptionStack;
    }

    public String getMixGroups() {
        return this.mixGroups;
    }

    public void setMixGroups(String mixGroups) {
        this.mixGroups = mixGroups;
    }

    public void setRegistryUrls(List<URL> registryUrls) {
        this.registryUrls = registryUrls;
    }

    public Boolean getAsyncInitConnection() {
        return this.asyncInitConnection;
    }

    public void setAsyncInitConnection(Boolean asyncInitConnection) {
        this.asyncInitConnection = asyncInitConnection;
    }

    public Integer getFusingThreshold() {
        return this.fusingThreshold;
    }

    public void setFusingThreshold(Integer fusingThreshold) {
        this.fusingThreshold = fusingThreshold;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    protected void loadRegistryUrls() {
        this.registryUrls.clear();
        if (this.registries != null && !this.registries.isEmpty()) {
            for (RegistryConfig config : this.registries) {
                List<URL> urls = config.toURLs();
                if (urls == null || urls.isEmpty()) continue;
                this.registryUrls.addAll(urls);
            }
        }
    }

    protected void checkInterfaceAndMethods(Class<?> interfaceClass, List<MethodConfig> methods) {
        if (interfaceClass == null) {
            throw new IllegalStateException("interface not allow null!");
        }
        if (!interfaceClass.isInterface()) {
            throw new IllegalStateException("The interface class " + interfaceClass + " is not a interface!");
        }
        if (methods != null && !methods.isEmpty()) {
            for (MethodConfig methodBean : methods) {
                String methodName = methodBean.getName();
                if (methodName == null || methodName.length() == 0) {
                    throw new IllegalStateException("<motan:method> name attribute is required! Please check: <motan:service interface=\"" + interfaceClass.getName() + "\" ... ><motan:method name=\"\" ... /></<motan:referer>");
                }
                Method hasMethod = null;
                for (Method method : interfaceClass.getMethods()) {
                    if (!method.getName().equals(methodName)) continue;
                    if (methodBean.getArgumentTypes() != null && ReflectUtil.getMethodParamDesc(method).equals(methodBean.getArgumentTypes())) {
                        hasMethod = method;
                        break;
                    }
                    if (methodBean.getArgumentTypes() != null) continue;
                    if (hasMethod != null) {
                        throw new MotanFrameworkException("The interface " + interfaceClass.getName() + " has more than one method " + methodName + " , must set argumentTypes attribute.", MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
                    }
                    hasMethod = method;
                }
                if (hasMethod == null) {
                    throw new MotanFrameworkException("The interface " + interfaceClass.getName() + " not found method " + methodName, MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
                }
                methodBean.setArgumentTypes(ReflectUtil.getMethodParamDesc(hasMethod));
            }
        }
    }

    protected String getLocalHostAddress() {
        HashMap<String, Integer> regHostPorts = new HashMap<String, Integer>();
        for (URL ru : this.registryUrls) {
            if (!StringUtils.isNotBlank((CharSequence)ru.getHost()) || ru.getPort() <= 0) continue;
            regHostPorts.put(ru.getHost(), ru.getPort());
        }
        String localAddress = NetUtils.getLocalIpString(regHostPorts);
        if (NetUtils.isValidLocalHost(localAddress)) {
            return localAddress;
        }
        throw new MotanServiceException("Please config local server hostname with intranet IP first!", MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
    }

    public Integer getSlowThreshold() {
        return this.slowThreshold;
    }

    public void setSlowThreshold(int slowThreshold) {
        this.slowThreshold = slowThreshold;
    }

    public List<URL> getRegistryUrls() {
        return this.registryUrls;
    }
}

