/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.cluster.loadbalance;

import com.weibo.api.motan.cluster.loadbalance.AbstractWeightedLoadBalance;
import com.weibo.api.motan.cluster.loadbalance.Selector;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.CollectionUtil;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

@SpiMeta(name="wrr")
public class WeightRoundRobinLoadBalance<T>
extends AbstractWeightedLoadBalance<T> {
    volatile Selector<T> selector;

    @Override
    public boolean canSelectMulti() {
        return false;
    }

    @Override
    public Referer<T> doSelect(Request request) {
        if (this.selector == null) {
            return null;
        }
        return this.selector.select(request);
    }

    @Override
    synchronized void notifyWeightChange() {
        List tempHolders = this.weightedRefererHolders;
        int[] weights = new int[tempHolders.size()];
        boolean haveSameWeight = true;
        int totalWeight = 0;
        for (int i = 0; i < tempHolders.size(); ++i) {
            weights[i] = ((AbstractWeightedLoadBalance.WeightedRefererHolder)tempHolders.get(i)).getWeight();
            totalWeight += weights[i];
            if (weights[i] == weights[0]) continue;
            haveSameWeight = false;
        }
        if (haveSameWeight) {
            if (this.selector instanceof RoundRobinSelector) {
                ((RoundRobinSelector)this.selector).refresh(tempHolders);
                return;
            }
            this.selector = new RoundRobinSelector(tempHolders);
            LoggerUtil.info("WeightRoundRobinLoadBalance use RoundRobinSelector. url:" + this.getUrlLogInfo());
            return;
        }
        int gcd = MathUtil.findGCD(weights);
        if (gcd > 1) {
            totalWeight = 0;
            for (int i = 0; i < weights.length; ++i) {
                int n = i;
                weights[n] = weights[n] / gcd;
                totalWeight += weights[i];
            }
        }
        if (weights.length <= 256 && totalWeight <= 5120) {
            this.selector = new WeightedRingSelector(tempHolders, totalWeight, weights);
            LoggerUtil.info("WeightRoundRobinLoadBalance use WeightedRingSelector. url:" + this.getUrlLogInfo());
            return;
        }
        this.selector = new SlidingWindowWeightedRoundRobinSelector(tempHolders, weights);
        LoggerUtil.info("WeightRoundRobinLoadBalance use SlidingWindowWeightedRoundRobinSelector. url:" + this.getUrlLogInfo());
    }

    private String getUrlLogInfo() {
        URL url = this.clusterUrl;
        if (url == null && !CollectionUtil.isEmpty(this.weightedRefererHolders)) {
            url = ((AbstractWeightedLoadBalance.WeightedRefererHolder)this.weightedRefererHolders.get((int)0)).referer.getUrl();
        }
        return url == null ? "" : url.toSimpleString();
    }

    private static class SelectorItem<T> {
        final Referer<T> referer;
        int weight;
        AtomicInteger currentWeight = new AtomicInteger(0);

        public SelectorItem(Referer<T> referer, int weight) {
            this.referer = referer;
            this.weight = weight;
        }
    }

    static class SlidingWindowWeightedRoundRobinSelector<T>
    implements Selector<T> {
        static final int DEFAULT_WINDOW_SIZE = 50;
        private final AtomicInteger index = new AtomicInteger(0);
        private int windowSize;
        private final List<SelectorItem<T>> items;

        public SlidingWindowWeightedRoundRobinSelector(List<AbstractWeightedLoadBalance.WeightedRefererHolder<T>> weightedRefererHolders, int[] weights) {
            this.items = new ArrayList<SelectorItem<T>>(weightedRefererHolders.size());
            this.init(weightedRefererHolders, weights);
        }

        private void init(List<AbstractWeightedLoadBalance.WeightedRefererHolder<T>> weightedRefererHolders, int[] weights) {
            this.windowSize = weights.length;
            if (this.windowSize > 50) {
                this.windowSize = 50;
                while (weights.length % this.windowSize == 0) {
                    --this.windowSize;
                }
            }
            for (int i = 0; i < weights.length; ++i) {
                this.items.add(new SelectorItem(weightedRefererHolders.get((int)i).referer, weights[i]));
            }
        }

        @Override
        public Referer<T> select(Request request) {
            SelectorItem<T> item;
            int windowStartIndex = MathUtil.getNonNegative(this.index.getAndAdd(this.windowSize));
            int totalWeight = 0;
            int maxWeight = 0;
            int maxWeightIndex = 0;
            for (int i = 0; i < this.windowSize; ++i) {
                int idx = (windowStartIndex + i) % this.items.size();
                item = this.items.get(idx);
                if (!item.referer.isAvailable()) continue;
                int currentWeight = item.currentWeight.addAndGet(item.weight);
                totalWeight += item.weight;
                if (currentWeight <= maxWeight) continue;
                maxWeight = currentWeight;
                maxWeightIndex = idx;
            }
            if (maxWeight > 0) {
                SelectorItem<T> item2 = this.items.get(maxWeightIndex);
                item2.currentWeight.addAndGet(-totalWeight);
                if (item2.referer.isAvailable()) {
                    return item2.referer;
                }
            }
            int idx = windowStartIndex + ThreadLocalRandom.current().nextInt(this.windowSize);
            for (int i = 1; i < this.items.size(); ++i) {
                item = this.items.get((idx + i) % this.items.size());
                if (!item.referer.isAvailable()) continue;
                return item.referer;
            }
            return null;
        }
    }

    static class WeightedRingSelector<T>
    implements Selector<T> {
        static final int MAX_REFERER_SIZE = 256;
        static final int MAX_TOTAL_WEIGHT = 5120;
        private final List<AbstractWeightedLoadBalance.WeightedRefererHolder<T>> holders;
        private final AtomicInteger ringIndex = new AtomicInteger(0);
        private final int[] weights;
        private final byte[] weightRing;

        public WeightedRingSelector(List<AbstractWeightedLoadBalance.WeightedRefererHolder<T>> holders, int totalWeight, int[] weights) {
            this.holders = holders;
            this.weightRing = new byte[totalWeight];
            this.weights = weights;
            this.initWeightRing();
        }

        private void initWeightRing() {
            int ringIndex = 0;
            for (int i = 0; i < this.weights.length; ++i) {
                for (int j = 0; j < this.weights[i]; ++j) {
                    this.weightRing[ringIndex++] = (byte)i;
                }
            }
            if (ringIndex != this.weightRing.length) {
                LoggerUtil.error("WeightedRingSelector initWeightRing with wrong totalWeight. expect:" + this.weightRing.length + ", actual:" + ringIndex);
            }
            CollectionUtil.shuffleByteArray(this.weightRing);
        }

        @Override
        public Referer<T> select(Request request) {
            Referer<T> ref = this.holders.get(this.getHolderIndex(MathUtil.getNonNegative(this.ringIndex.getAndIncrement()))).getReferer();
            if (ref.isAvailable()) {
                return ref;
            }
            int start = ThreadLocalRandom.current().nextInt(this.weightRing.length);
            for (int i = 0; i < this.weightRing.length; ++i) {
                Referer<T> referer = this.holders.get(this.getHolderIndex(start + i)).getReferer();
                if (!referer.isAvailable()) continue;
                return referer;
            }
            return null;
        }

        private int getHolderIndex(int ringIndex) {
            int holderIndex = this.weightRing[ringIndex % this.weightRing.length];
            if (holderIndex < 0) {
                holderIndex += 256;
            }
            return holderIndex;
        }
    }

    static class RoundRobinSelector<T>
    implements Selector<T> {
        private volatile List<AbstractWeightedLoadBalance.WeightedRefererHolder<T>> holders;
        private final AtomicInteger idx = new AtomicInteger(0);

        public RoundRobinSelector(List<AbstractWeightedLoadBalance.WeightedRefererHolder<T>> holders) {
            this.holders = holders;
        }

        @Override
        public Referer<T> select(Request request) {
            List<AbstractWeightedLoadBalance.WeightedRefererHolder<T>> tempHolders = this.holders;
            if (CollectionUtil.isEmpty(tempHolders)) {
                return null;
            }
            Referer ref = tempHolders.get((int)(MathUtil.getNonNegative((int)this.idx.incrementAndGet()) % tempHolders.size())).referer;
            if (ref.isAvailable()) {
                return ref;
            }
            int start = ThreadLocalRandom.current().nextInt(tempHolders.size());
            for (int i = 0; i < tempHolders.size(); ++i) {
                ref = tempHolders.get((int)((start + i) % tempHolders.size())).referer;
                if (!ref.isAvailable()) continue;
                return ref;
            }
            return null;
        }

        public void refresh(List<AbstractWeightedLoadBalance.WeightedRefererHolder<T>> holders) {
            this.holders = holders;
        }
    }
}

