/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.cluster.loadbalance;

import com.weibo.api.motan.cluster.loadbalance.AbstractLoadBalance;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.DefaultThreadFactory;
import com.weibo.api.motan.core.StandardThreadExecutor;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.CollectionUtil;
import com.weibo.api.motan.util.ConcurrentHashSet;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MathUtil;
import com.weibo.api.motan.util.MetaUtil;
import com.weibo.api.motan.util.MotanGlobalConfigUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractWeightedLoadBalance<T>
extends AbstractLoadBalance<T> {
    static final ConcurrentHashSet<AbstractWeightedLoadBalance<?>> dynamicWeightedLoadBalances = new ConcurrentHashSet();
    private static final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(1);
    private static final ThreadPoolExecutor taskExecutor;
    public static final String WEIGHT_META_SUFFIX_KEY = "WEIGHT";
    public static final int MIN_WEIGHT = 1;
    public static final int MAX_WEIGHT = 500;
    protected static final int DEFAULT_WEIGHT = 10;
    protected boolean supportDynamicWeight = true;
    protected volatile List<WeightedRefererHolder<T>> weightedRefererHolders;

    private static void refreshAll() {
        for (AbstractWeightedLoadBalance<?> loadBalance : dynamicWeightedLoadBalances) {
            if (!loadBalance.supportDynamicWeight) continue;
            taskExecutor.execute(loadBalance::refreshHoldersDynamicWeightTask);
        }
    }

    @Override
    public void destroy() {
        if (this.supportDynamicWeight) {
            dynamicWeightedLoadBalances.remove(this);
        }
    }

    @Override
    public void init(URL clusterUrl) {
        super.init(clusterUrl);
        this.supportDynamicWeight = clusterUrl.getBooleanParameter(URLParamType.dynamicMeta.getName(), URLParamType.dynamicMeta.getBooleanValue());
        if (this.supportDynamicWeight) {
            dynamicWeightedLoadBalances.add(this);
        }
    }

    @Override
    public void onRefresh(List<Referer<T>> referers) {
        super.onRefresh(referers);
        this.refreshRefererHolders();
    }

    private void refreshRefererHolders() {
        List referers = this.getReferers();
        ArrayList<WeightedRefererHolder<T>> allHolders = new ArrayList<WeightedRefererHolder<T>>(referers.size());
        ArrayList<WeightedRefererHolder<T>> newHolders = new ArrayList<WeightedRefererHolder<T>>();
        for (Referer referer : referers) {
            WeightedRefererHolder holder = null;
            if (this.weightedRefererHolders != null) {
                for (WeightedRefererHolder<T> refererHolder : this.weightedRefererHolders) {
                    if (refererHolder.getReferer() != referer) continue;
                    holder = refererHolder;
                    break;
                }
            }
            if (holder == null) {
                int staticWeight = 10;
                try {
                    staticWeight = this.getRefererWeight(referer, false, 10);
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
                holder = new WeightedRefererHolder(referer, staticWeight);
                newHolders.add(holder);
            }
            allHolders.add(holder);
        }
        if (!newHolders.isEmpty()) {
            this.refreshDynamicWeight(newHolders, 15000L);
        }
        this.weightedRefererHolders = allHolders;
        this.notifyWeightChange();
    }

    abstract void notifyWeightChange();

    protected void refreshHoldersDynamicWeightTask() {
        List<WeightedRefererHolder<T>> tempHolders = this.weightedRefererHolders;
        try {
            boolean needNotify = this.refreshDynamicWeight(tempHolders, 30000L);
            if (needNotify) {
                this.notifyWeightChange();
            }
        }
        catch (Exception e) {
            LoggerUtil.warn("refreshHoldersDynamicWeightTask fail. cluster:" + this.clusterUrl.getIdentity() + ", e:" + e.getMessage());
        }
    }

    private boolean refreshDynamicWeight(List<WeightedRefererHolder<T>> holders, long taskTimeout) {
        AtomicBoolean needNotify = new AtomicBoolean(false);
        if (!CollectionUtil.isEmpty(holders)) {
            CountDownLatch countDownLatch = new CountDownLatch(holders.size());
            for (WeightedRefererHolder<T> holder : holders) {
                if (holder.supportDynamicWeight) {
                    taskExecutor.execute(() -> {
                        try {
                            int oldWeight = holder.dynamicWeight;
                            holder.dynamicWeight = this.getRefererWeight(holder.referer, true, 0);
                            if (oldWeight != holder.dynamicWeight) {
                                needNotify.set(true);
                            }
                        }
                        catch (Exception e) {
                            if (e.getCause() instanceof MotanServiceException && ((MotanServiceException)e.getCause()).getStatus() == MotanErrorMsgConstant.SERVICE_NOT_SUPPORT_ERROR.getStatus()) {
                                holder.supportDynamicWeight = false;
                            } else {
                                LoggerUtil.warn("refresh dynamic weight fail! url:" + holder.getReferer().getUrl().getIdentity() + ", error:" + e.getMessage());
                            }
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    });
                    continue;
                }
                countDownLatch.countDown();
            }
            try {
                countDownLatch.await(taskTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return needNotify.get();
    }

    protected int getRefererWeight(Referer<T> referer, boolean fromDynamicMeta, int defaultWeight) throws ExecutionException {
        Map<String, String> meta = fromDynamicMeta ? MetaUtil.getRefererDynamicMeta(referer) : MetaUtil.getRefererStaticMeta(referer);
        String weightString = MetaUtil.getMetaValue(meta, WEIGHT_META_SUFFIX_KEY);
        return this.adjustWeight(referer, weightString, defaultWeight);
    }

    protected int adjustWeight(Referer<T> referer, String weight, int defaultWeight) {
        int w = defaultWeight;
        if (weight != null) {
            try {
                int temp = Integer.parseInt(weight);
                if (temp < 1) {
                    temp = 1;
                } else if (temp > 500) {
                    temp = 500;
                }
                w = temp;
            }
            catch (NumberFormatException e) {
                LoggerUtil.warn("WeightedRefererHolder parse weight fail. " + referer.getUrl().getIdentity() + ", use default weight " + defaultWeight + ", org weight:" + weight + ", error:" + e.getMessage());
            }
        }
        return w;
    }

    static {
        long refreshPeriod = MathUtil.parseLong(MotanGlobalConfigUtil.getConfig("weightRefreshPeriodSecond"), 3L);
        int maxThread = MathUtil.parseInt(MotanGlobalConfigUtil.getConfig("weightRefreshMaxThread"), 100);
        taskExecutor = new StandardThreadExecutor(10, maxThread, 30L, TimeUnit.SECONDS, 10000, (ThreadFactory)new DefaultThreadFactory("AbstractWeightedLoadBalance-refreshWeight-", true), (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        long initDelay = refreshPeriod + (long)ThreadLocalRandom.current().nextInt(10);
        scheduledExecutor.scheduleWithFixedDelay(AbstractWeightedLoadBalance::refreshAll, initDelay, refreshPeriod, TimeUnit.SECONDS);
    }

    protected static class WeightedRefererHolder<T> {
        public Referer<T> referer;
        public int staticWeight;
        public boolean supportDynamicWeight;
        public volatile int dynamicWeight = 0;

        public WeightedRefererHolder(Referer<T> referer, int staticWeight) {
            this.referer = referer;
            this.staticWeight = staticWeight;
            this.supportDynamicWeight = referer.getUrl().getBooleanParameter(URLParamType.dynamicMeta.getName(), URLParamType.dynamicMeta.getBooleanValue());
        }

        public Referer<T> getReferer() {
            return this.referer;
        }

        public int getWeight() {
            if (this.dynamicWeight > 0) {
                return this.dynamicWeight;
            }
            return this.staticWeight;
        }
    }
}

