/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.cluster.group;

import com.weibo.api.motan.cluster.Cluster;
import com.weibo.api.motan.cluster.group.ClusterGroup;
import com.weibo.api.motan.cluster.group.ClusterSelector;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.util.CollectionUtil;
import java.util.List;

@SpiMeta(name="default")
public class DefaultClusterSelector<T>
implements ClusterSelector<T> {
    public static final String DEFAULT_ROUTE_GROUP_SANDBOX = "sandbox";
    protected ClusterGroup<T> clusterGroup;
    protected Cluster<T> defaultSandboxCluster;
    protected Cluster<T> defaultGreyCluster;

    @Override
    public Cluster<T> select(Request request) {
        String routeGroup = request.getAttachment("motan-route-group");
        if (routeGroup != null) {
            String[] routeGroupList;
            String sandboxGroup = null;
            String greyGroup = null;
            if (this.defaultSandboxCluster != null && !CollectionUtil.isEmpty(this.defaultSandboxCluster.getReferers())) {
                sandboxGroup = this.defaultSandboxCluster.getUrl().getGroup();
            }
            if (this.defaultGreyCluster != null && !CollectionUtil.isEmpty(this.defaultGreyCluster.getReferers())) {
                greyGroup = this.defaultGreyCluster.getUrl().getGroup();
            }
            if (sandboxGroup != null && DEFAULT_ROUTE_GROUP_SANDBOX.equals(routeGroup.trim())) {
                return this.defaultSandboxCluster;
            }
            for (String group : routeGroupList = routeGroup.split(",")) {
                group = group.trim();
                if (sandboxGroup != null && sandboxGroup.equals(group)) {
                    return this.defaultSandboxCluster;
                }
                if (greyGroup == null || !greyGroup.equals(group)) continue;
                return this.defaultGreyCluster;
            }
        }
        return this.clusterGroup.getMasterCluster();
    }

    @Override
    public void init(ClusterGroup<T> clusterGroup) {
        List<Cluster<T>> greyClusters;
        if (clusterGroup == null) {
            throw new MotanFrameworkException("ClusterGroup cannot be null");
        }
        this.clusterGroup = clusterGroup;
        List<Cluster<T>> sandboxClusters = clusterGroup.getSandboxClusters();
        if (!CollectionUtil.isEmpty(sandboxClusters)) {
            this.defaultSandboxCluster = sandboxClusters.get(0);
        }
        if (!CollectionUtil.isEmpty(greyClusters = clusterGroup.getGreyClusters())) {
            this.defaultGreyCluster = greyClusters.get(0);
        }
    }

    @Override
    public void destroy() {
    }
}

